/*
 * Decompiled with CFR 0.152.
 */
package jp.livewell.baby.pool.jdbc;

import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import jp.livewell.baby.pool.AbstractWrapper;
import jp.livewell.baby.pool.ComparisonKey;
import jp.livewell.baby.pool.jdbc.ResultSetWrapper;

class StatementWrapper
extends AbstractWrapper
implements Statement {
    private Statement stmt;
    private WeakReference ownRef;
    private WeakReference connRef;
    private ResultSet current = null;

    StatementWrapper(Statement stmt, WeakReference connRef) throws IllegalArgumentException {
        if (stmt != null && connRef != null) {
            if (!(connRef.get() instanceof Connection)) {
                throw new IllegalArgumentException("need java.sql.Connection reference!");
            }
        } else {
            throw new IllegalArgumentException("please check params.\nstmt = " + stmt + "\n" + "connRef = " + connRef + "\n");
        }
        this.stmt = stmt;
        this.connRef = connRef;
        this.ownRef = new WeakReference<StatementWrapper>(this);
        this.activate(this.getComparisonKey());
    }

    public synchronized void destroy(ComparisonKey key) {
        try {
            block5: {
                try {
                    super.destroy(key);
                    if (this.current != null) {
                        this.current.close();
                    }
                    if (this.stmt == null) break block5;
                    this.stmt.close();
                }
                catch (Exception e) {
                    Object var4_3 = null;
                    this.current = null;
                    this.connRef = null;
                    this.ownRef = null;
                }
            }
            Object var4_2 = null;
            this.current = null;
            this.connRef = null;
            this.ownRef = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.current = null;
            this.connRef = null;
            this.ownRef = null;
            throw throwable;
        }
    }

    protected boolean ping() {
        return true;
    }

    protected Statement statement() {
        return this.stmt;
    }

    protected WeakReference ownReference() {
        return this.ownRef;
    }

    protected void setCurrentResultSet(ResultSet res) {
        if (res != null) {
            if (this.current != null) {
                try {
                    this.current.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            this.current = res;
        }
    }

    public void addBatch(String sql) throws SQLException {
        this.statement().addBatch(sql);
    }

    public void cancel() throws SQLException {
        this.statement().cancel();
    }

    public void clearBatch() throws SQLException {
        this.statement().clearBatch();
    }

    public void clearWarnings() throws SQLException {
        this.statement().clearWarnings();
    }

    public void close() throws SQLException {
        this.destroy(this.getComparisonKey());
    }

    public boolean execute(String sql) throws SQLException {
        return this.statement().execute(sql);
    }

    public int[] executeBatch() throws SQLException {
        return this.statement().executeBatch();
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        ResultSetWrapper res = new ResultSetWrapper(this.statement().executeQuery(sql), this.ownReference());
        this.setCurrentResultSet(res);
        return res;
    }

    public int executeUpdate(String sql) throws SQLException {
        return this.statement().executeUpdate(sql);
    }

    public Connection getConnection() throws SQLException {
        return (Connection)this.connRef.get();
    }

    public int getFetchSize() throws SQLException {
        return this.statement().getFetchSize();
    }

    public int getFetchDirection() throws SQLException {
        return this.statement().getFetchDirection();
    }

    public int getMaxFieldSize() throws SQLException {
        return this.statement().getMaxFieldSize();
    }

    public int getMaxRows() throws SQLException {
        return this.statement().getMaxRows();
    }

    public boolean getMoreResults() throws SQLException {
        return this.statement().getMoreResults();
    }

    public int getQueryTimeout() throws SQLException {
        return this.statement().getQueryTimeout();
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.statement().getResultSetConcurrency();
    }

    public ResultSet getResultSet() throws SQLException {
        ResultSetWrapper res = new ResultSetWrapper(this.statement().getResultSet(), this.ownReference());
        this.setCurrentResultSet(res);
        return res;
    }

    public int getUpdateCount() throws SQLException {
        return this.statement().getUpdateCount();
    }

    public int getResultSetType() throws SQLException {
        return this.statement().getResultSetType();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.statement().getWarnings();
    }

    public void setCursorName(String name) throws SQLException {
        this.statement().setCursorName(name);
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.statement().setEscapeProcessing(enable);
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.statement().setFetchDirection(direction);
    }

    public void setFetchSize(int rows) throws SQLException {
        this.statement().setFetchSize(rows);
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.statement().setMaxFieldSize(max);
    }

    public void setMaxRows(int max) throws SQLException {
        this.statement().setMaxRows(max);
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.statement().setQueryTimeout(seconds);
    }
}

