/*
 * Decompiled with CFR 0.152.
 */
package jp.livewell.baby.pool.jdbc;

import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jp.livewell.baby.pool.jdbc.ConnectionPoolInfoLoader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

class XmlLoader
extends ConnectionPoolInfoLoader {
    public static final String TAG_BABY_POOL = "baby-pool";
    public static final String TAG_CONNECTION_POOL = "connection-pool";
    public static final String ATTR_KEY = "key";

    XmlLoader() {
    }

    String getFullName() {
        return '/' + super.getFullName().replace('.', '/') + ".xml";
    }

    boolean isFoundResource() throws IllegalStateException {
        return this.getClass().getResource(this.getFullName()) != null;
    }

    protected Map[] parseResource() throws Exception {
        InputStream is;
        InputSource source;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document root = db.parse(source = new InputSource(is = this.getClass().getResourceAsStream(this.getFullName())));
        NodeList list = root.getElementsByTagName(TAG_BABY_POOL);
        Element babyPool = list.getLength() > 0 ? (Element)list.item(0) : root.createElement(TAG_BABY_POOL);
        HashSet<Map> parseds = new HashSet<Map>();
        Node pool = babyPool.getFirstChild();
        while (pool != null) {
            if (pool.getNodeType() == 1 && pool.getNodeName().equals(TAG_CONNECTION_POOL)) {
                parseds.add(this.parsePool((Element)pool));
            }
            pool = pool.getNextSibling();
        }
        return parseds.toArray(new Map[0]);
    }

    private Map parsePool(Element pool) {
        HashMap<String, String> parsed = new HashMap<String, String>();
        Node prop = pool.getFirstChild();
        while (prop != null) {
            if (prop.getNodeType() == 1) {
                Node val = prop.getFirstChild();
                while (val != null) {
                    if (val.getNodeType() == 3) {
                        parsed.put(this.keyToMethodName((Element)prop), val.getNodeValue().trim());
                        break;
                    }
                    val = val.getNextSibling();
                }
            }
            prop = prop.getNextSibling();
        }
        return parsed;
    }

    private String keyToMethodName(Element prop) {
        StringBuffer buf = new StringBuffer();
        char[] str = prop.getNodeName().toCharArray();
        int i = 0;
        while (i < str.length) {
            if (str[i] != '-') {
                buf.append(str[i]);
            }
            ++i;
        }
        if (prop.hasAttribute(ATTR_KEY)) {
            buf.append('.').append(prop.getAttribute(ATTR_KEY));
        }
        return buf.toString();
    }
}

