/*
 * Decompiled with CFR 0.152.
 */
package jp.livewell.baby.util;

import java.util.Arrays;
import java.util.Comparator;
import jp.livewell.baby.util.HanZenTable;

public class HanZenConverter {
    public static final int HANKANA_FIRST = 65377;
    public static final int HANKANA_LAST = 65439;

    public String convert(String val) {
        if (val == null) {
            return null;
        }
        return new String(this._convert(val, 0, val.length()));
    }

    protected boolean isHankaku(char chr) {
        return '\uff61' <= chr && chr <= '\uff9f';
    }

    private int _putChars(char[] main, int mainPos, char[] parts) {
        int pos = mainPos;
        int i = 0;
        while (i < parts.length) {
            if (parts[i] != '\u0000') {
                main[pos++] = parts[i];
            }
            ++i;
        }
        return pos - mainPos;
    }

    private String _convert(String val, int pos, int length) {
        char[][][] table = HanZenTable.HANZEN_TABLE;
        Comparator comp = HanZenTable.HANZEN_COMPARATOR;
        int retIdx = 0;
        int maxPos = pos + length;
        char[] base = new char[1];
        char[] daku = new char[2];
        char[] nChars = val.toCharArray();
        char[] nRets = new char[length];
        while (pos < maxPos) {
            char[] res;
            char nextChar;
            char currChar;
            if (!this.isHankaku(currChar = nChars[pos++])) {
                nRets[retIdx++] = currChar;
                continue;
            }
            if (pos < maxPos && ((nextChar = nChars[pos]) == '\uff9e' || nextChar == '\uff9f')) {
                ++pos;
                daku[0] = currChar;
                daku[1] = nextChar;
                res = this._convertPart(daku, table, comp);
                retIdx += this._putChars(nRets, retIdx, res);
                continue;
            }
            base[0] = currChar;
            res = this._convertPart(base, table, comp);
            retIdx += this._putChars(nRets, retIdx, res);
        }
        return new String(nRets, 0, retIdx);
    }

    private char[] _convertPart(char[] chars, char[][][] sourceTable, Comparator comparator) {
        int index = Arrays.binarySearch((Object[])sourceTable, chars, comparator);
        if (index >= 0) {
            return sourceTable[index][1];
        }
        if (chars.length == 1) {
            return chars;
        }
        int len = chars.length;
        int i = 0;
        while (i < len) {
            if (chars[i] != '\u0000') {
                char[] atom = new char[]{chars[i]};
                chars[i] = this._convertPart(atom, sourceTable, comparator)[0];
            }
            ++i;
        }
        return chars;
    }
}

