/*
 * $Id: BabyPoolBench0_1_0a.java,v 1.1.1.1 2002/12/10 09:18:09 mitsuhito Exp $
 */


package jp.livewell.baby.pool.jdbc;


import java.util.Set;
import javax.sql.DataSource;
import jp.livewell.baby.pool.jdbc.DataSourceBenchMarker;


/**
 * babyPool ver 0.1.0a٥ޡޤ
 *
 * @author mitsuhito
 */
public class BabyPoolBench0_1_0a
{
    // main -------------------------------------------------------------------
    /**
     * main.
     * 
     * @params	args
     *		index 0 = thread size.
     *		index 1 = loop count.
     */
    public static void main(String[] args)
    {
	/* all args set ok? */
	DataSourceBenchMarker marker = null;
	{
	    try {
		ResourceManager manager = ResourceManager.getInstance();

		if (args.length >= 2) {
		    int threadSize	= Integer.parseInt(args[0]);
		    int loopCount	= Integer.parseInt(args[1]);
		    Set names		= manager.poolNameSet();

		    if (names.size() > 0) {
			String name = (String) names.toArray()[0];

			marker = new DataSourceBenchMarker
			    (manager.findPoolByName(name),
			     threadSize,
			     loopCount);
		    }
		} else {
		    throw new RuntimeException
			("args not enougth\n"
			 + "length = " + args.length + "\n");
		}
	    } catch (Exception e) {
		e.printStackTrace();
	    } finally {
		if (marker == null) {
		    printUsage();
		    System.exit(0);
		}
	    }
	}


	marker.startBench();
	while (!marker.isFinished()) {
	    try {
		synchronized (marker) {
		    marker.wait(1000); // 1sec polling.
		}
	    } catch (InterruptedException e) {
		// do nothing
	    }
	}

	System.out.println("benchmark result is here...\n");

	long[] results	= marker.getResultTimes();
	long   min	= marker.getMin();
	long   max	= marker.getMax();
	long   avg	= marker.getAverage();

	for (int i = 0; i < results.length; i++) {
	    System.out.println((i + 1) + ": " + results[i] + " (ms)");
	}

	System.out.println("[min / avg / max (ms)]: "
			   + min + " / " + avg + " / " + max);
	System.out.println("total time = " 
			   + (marker.getFinishedTime() - marker.getStartTime())
			   + " (ms)");
    }

    /**
     * ˡɸϤ˽Ϥޤ
     */
    private static void printUsage()
    {
	// currently do nothing. (please write down here way of use.)
    }
}
