/*
 * $Id: DataSourceBenchMarker.java,v 1.1.1.1 2002/12/10 09:18:10 mitsuhito Exp $
 */

package jp.livewell.baby.pool.jdbc;


import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import javax.sql.DataSource;


/**
 * DataSource٥ޡޤ
 *
 * @author mitsuhito
 */
public class DataSourceBenchMarker
{
    // attributes -------------------------------------------------------------
    /** ٥ޡԤʤThreadSetǤ*/
    private final Set markers = new HashSet();


    // status -----------------------------------------------------------------
    /** ֥ե饰ǥԤɽޤ*/
    public static final int STATUS_WAIT_START = 0;

    /** ֥ե饰ǥ٥ޡ¹ɽޤ*/
    public static final int STATUS_RUNNING = 1;

    /** ֥ե饰ǥ٥ޡλɽޤ*/
    public static final int STATUS_FINISHED = 2;
      
    /** ٥ޡοʹԾɽޤ */
    private int status;


    // results ----------------------------------------------------------------
    /** ¬ηǤ*/
    private long[] times = new long[0];

    /** ϻǤ */
    private long start = 0;

    /** λǤ*/
    private long end = 0;


    // constructors & init ----------------------------------------------------
    /**
     * constractor
     *
     * @param	source
     *		٥ޡоݤDateSource
     * @param	size
     *		Ʊ¹ԤThreadο
     * @param	loop
     *		1Threadloop
     * @throws	IllegalArgumentException
     *		sizeloop0ʲλ
     *		sourcenullλ
     */
    public DataSourceBenchMarker(DataSource source,
				 int size,
				 int loop)
	throws IllegalArgumentException
    {
	if ((source != null) && (size > 0) && (loop > 0)) {
	    for (int i = 0; i < size; i++) {
		BenchMarkerThread bmth = new BenchMarkerThread();
		bmth.setDataSource(source);
		bmth.setLoopCount(loop);

		markers.add(bmth);
	    }
	    setStatus(STATUS_WAIT_START);
	} else {
	    throw new IllegalArgumentException
		("check parameter value.\n"
		 + "source = " + source + "\n"
		 + "size = " + size + "\n"
		 + "loop = " + loop + "\n");
	}
    }


    // accessor ---------------------------------------------------------------
    /**
     * Υ󥹥󥹤Υ٥ޡ˽λƷ̤Ф֤ˤʤä
     * 뤫ɤޤgetStatus() == STATUS_FINISHEDƱǤ
     *
     * @return	٥ޡ˽λƷ̤Ф֤ˤʤäƤ
     *		ɤ
     */
    public boolean isFinished()
    {
	return (getStatus() == STATUS_FINISHED);
    }

    /**
     * Υ󥹥󥹤Υ٥ޡ¹Ծ֤ޤͤ
     * classSATUS_XXXΤΤ줫Ǥ
     *
     * @return	٥ޡ¹Ծ
     */
    public int getStatus()
    {
	return status;
    }

    /**
     * Υ󥹥󥹤Υ٥ޡ¹Ծ֤ꤷޤξ֤
     * ꤷ褦ȤIllegalArgumentExceptionthrowޤ
     *
     * @param	status
     *		٥ޡ¹Ծ
     * @throws	IllegalArgumentException
     *		ξ֤ꤷ褦ȤȤ
     */
    private void setStatus(int status)
	throws IllegalArgumentException
    {
	synchronized (this) {
	    if (this.status <= status) {
		this.status = status;
	    } else {
		throw new IllegalArgumentException
		    ("can't go back before status.");
	    }
	}
    }

    /**
     * ٥ޡγϻlongǼޤ
     * 
     * @throws	IllegalStateException
     *		٥ޡϤƤʤ硣
     */
    public long getStartTime()
    {
	if (getStatus() >= STATUS_RUNNING) {
	    return start;
	} else {
	    throw new IllegalStateException
		("bench mark is not started!");
	}	    
    }

    /**
     * ٥ޡγϻlongꤷޤ
     * 
     * @throws	IllegalStateException
     *		٥ޡ˳ϤƤ硣
     */
    private void setStartTime(long start)
	throws IllegalStateException
    {
	if (getStatus() == STATUS_WAIT_START) {
	    this.start = start;
	} else {
	    throw new IllegalStateException
		("bench mark is already started!");
	}
    }

    /**
     * ٥ޡνλlongǼޤ
     * 
     * @throws	IllegalStateException
     *		٥ޡλƤʤ硣
     */
    public long getFinishedTime()
    {
	if (isFinished()) {
	    return end;
	} else {
	    throw new IllegalStateException
		("bench mark is not finished!");
	}	    
    }

    /**
     * ٥ޡνλlongꤷޤ
     * 
     * @throws	IllegalStateException
     *		٥ޡλƤʤ硣
     */
    private void setFinishedTime(long end)
	throws IllegalStateException
    {
	if (isFinished()) {
	    this.end = end;
	} else {
	    throw new IllegalStateException
		("bench mark is not finished!");
	}
    }

    /**
     * ٥ޡη̤ޤͤ1Threadμ¹Ի֤
     * Ǥ
     * 
     * @return	1Threadμ¹Ի֤
     * @throws	IllegalStateException
     *		٥ޡλƤʤ硣
     */
    public long[] getResultTimes()
	throws IllegalStateException
    {
	if (isFinished()) {
	    return (long[]) times.clone();
	} else {
	    throw new IllegalStateException
		("bench mark is not finished!");
	}
    }

    /**
     * ٥ޡη̤ꤷޤͤ1Threadμ¹Ի֤
     * Ǥ
     * 
     * @param	times
     *		1Threadμ¹Ի֤
     * @throws	IllegalStateException
     *		٥ޡλƤʤ硣
     * @throws	NullPointerException
     *		timesnullξ硣
     */
    private void setResultTimes(long[] times)
	throws IllegalStateException, NullPointerException
    {
	if (isFinished()) {
	    if (times != null) {
		this.times = times;
	    } else {
		throw new NullPointerException("can't set null times");
	    }
	} else {
	    throw new IllegalStateException("bench mark is not finished!");
	}
    }

    /**
     * ʿѼ¹Ի֤ޤ
     *
     * @return	ʿѼ¹Ի
     * @throws	IllegalStateException
     *		٥ޡλƤʤ
     */
    public long getAverage()
	throws IllegalStateException
    {
	if (isFinished()) {
	    long total = 0;
	    for (int i = 0; i < times.length; i++) {
		total += times[i];
	    }
	    return total / times.length;
	} else {
	    throw new IllegalStateException("bench mark is not finished!");
	}
    }

    /**
     * ¹Ի֤ޤ
     *
     * @return	¹Ի
     * @throws	IllegalStateException
     *		٥ޡλƤʤ
     */
    public long getMax()
	throws IllegalStateException
    {
	if (isFinished()) {
	    long max = 0;

	    for (int i = 0; i < times.length; i++) {
		if (max < times[i]) {
		    max = times[i];
		}
	    }
	    return max;
	} else {
	    throw new IllegalStateException("bench mark is not finished!");
	}
    }
     
    /**
     * Ǿ¹Ի֤ޤ
     *
     * @return	Ǿ¹Ի
     * @throws	IllegalStateException
     *		٥ޡλƤʤ
     */
    public long getMin()
	throws IllegalStateException
    {
	if (isFinished()) {
	    long min = Long.MAX_VALUE;

	    for (int i = 0; i < times.length; i++) {
		if (min > times[i]) {
		    min = times[i];
		}
	    }
	    return min;
	} else {
	    throw new IllegalStateException("bench mark is not finished!");
	}
    }
     

    // action -----------------------------------------------------------------
    /**
     * ٥ޡ򥹥Ȥޤ
     *
     * @throws	IllegalStateException
     *		˥٥ޡȤƤ뤫λƤ硣
     */
    public void startBench()
	throws IllegalStateException
    {
	synchronized (this) {
	    if (getStatus() == STATUS_WAIT_START) {
		setStartTime(System.currentTimeMillis());
		Thread th = new Thread(new BootStrapper(markers));
		th.start();
		setStatus(STATUS_RUNNING);
	    } else {
		throw new IllegalStateException
		    ("already bench mark is starting or finished!");
	    }
	}
    }


    // helper bootstrapper ----------------------------------------------------
    /**
     * BenchMarkerThread򥭥åȤjoinޤǤޤ
     * RunnableˤޤƤޤȤǡƤӽФȤThread֥åʤ
     * ǥ٥ޡ¹ԤǤ褦ˤʤޤ
     */
    private class BootStrapper
	implements Runnable
    {
	// attributes ---------------------------------------------------------
	/** ٥ޡ¹ԤThreadSet */
	private final BenchMarkerThread[] nMarkers;


	// constructors & init ------------------------------------------------
	/**
	 * BootStrapperۤޤ
	 *
	 * @param	markers
	 *		BenchMarkerThreadΤޤstartƤӽФƤʤ
	 *		Thread
	 */
	BootStrapper(Set markers)
	{
	    this.nMarkers = (BenchMarkerThread[]) markers
		.toArray(new BenchMarkerThread[0]);
	}

	
	// Runnable implements ------------------------------------------------
	/**
	 * Runnable#runimplementsޤBenchMarkerThreadstartjoin
	 * ޤԵޤƤThreadjoinä˿classǤ
	 * DataSourceBenchMakersetStatus(STATUS_FINISHED)¹Ԥ٥
	 * ޡλȤΤ餻ޤ
	 */
	public void run()
	{
	    long[] nTimes = new long[nMarkers.length];
	    try {
		for (int i = 0; i < nMarkers.length; i++) {
		    BenchMarkerThread bmth = nMarkers[i];
		    bmth.start();
		}

		/*
		for (int i = 0; i < nMarkers.length; i++) {
		    // sure start
		    BenchMarkerThread bmth = nMarkers[i];
		    
		    synchronized (bmth) {
			bmth.notifyAll();
		    }
		}
		*/
		
		for (int i = 0; i < nMarkers.length; i++) {
		    try {
			BenchMarkerThread bmth = nMarkers[i];
			bmth.join();
			
			if (!bmth.isRunning()) {
			    nTimes[i] = bmth.getTotalTime();
			} else {
			    nTimes[i] = -1;
			}
		    } catch (InterruptedException e) {
			i--;
			continue;
		    }
		}
	    } catch (Exception e) {
		e.printStackTrace();
	    } finally {
		setStatus(STATUS_FINISHED);
	    }
	    setFinishedTime(System.currentTimeMillis());
	    setResultTimes(nTimes);
	}
    }


    // helper thread class ----------------------------------------------------
    /**
     * ٥ޡԤʤ1ThreadɽclassǤThreadɬפʿ
     * ƥ٥ޡ¹Ԥޤ
     */
    private static class BenchMarkerThread
	extends Thread
    {
	// target attributes --------------------------------------------------
	/** ThreadtestLoop */
	private int loop = 1;
	
	/** TestоݤConnectionPool */
	private DataSource source = null;

	
	// status -------------------------------------------------------------
	/** ߥ٥ޡǤtrue򥻥åȤޤ */
	private volatile boolean isRunning = false;
	    

	// results ------------------------------------------------------------
	/** ¹Է̤λ֤ꤷޤ*/
	private long time = -1;

	
	// constructors & init ------------------------------------------------
	/**
	 * ǥեȥ󥹥ȥ饯ǤthreadϾdaemon modeư
	 * ޤ
	 */
	BenchMarkerThread()
	{
	    // do nothing
	}


	// over rides ---------------------------------------------------------
	/**
	 * Thread#start򥪡С饤ɤޤThreadsub classstart
	 * ƤӽФrunǡּʬȤΡwaitƤӽФޤĤޤꡢ
	 * Threadinstancestart˰notify(ޤnotifyAll)Ƥ
	 * Фʤȥ٥ޡϼ¹Ԥޤ
	 * DataSourceåȤƤʤ
	 * IllegalStateExceptionthrowޤ
	 *
	 * @throws	IllegalStateException
	 *		DataSourceåȤƤʤ硣
	 *		˥٥ޡȤƤ
	 */
	public void  start()
	    throws IllegalStateException
	{
	    if (source != null && !isRunning()) {
		setDaemon(true);
		super.start();
	    } else {
		throw new IllegalStateException
		    ("already starting benchMarker thread!!");
	    }
	}

	/**
	 * Thraed#run򥪡С饤ɤޤΥ᥽åǼ¹Ի֤η¬
	 * Ԥʤޤ
	 */
	public void run()
	{
	    long start = 0;
	    long stop  = 0;
	    try {
		setRunning(true);

		/*
		// waiting sure go sign.( is notifyAll() to this instance )
		synchronized (this) {
		    try {
			wait();
		    } catch (InterruptedException e) {
			// do nothing
		    }
		}
		*/

		System.out.println("starting thread...");
		start = System.currentTimeMillis();
		test();
		stop = System.currentTimeMillis();
	    } catch (Exception e) {
		e.printStackTrace();
	    } finally {
		setRunning(false);
	    }
	    setTotalTime(stop - start);
	    System.out.println("stopping thread...");
	}
	

	// accessor -----------------------------------------------------------
	/**
	 * ٥ޡоݤDataSourceޤ
	 *
	 * @return	٥ޡоݤDataSource
	 */
	DataSource getDataSource()
	{
	    return source;
	}

	/**
	 * ٥ޡоݤDataSourceꤷޤ
	 *
	 * @param	source
	 *		٥ޡоݤDataSource
	 * @throws	IllegalStateException
	 *		٥ޡ¹ΤȤ
	 */
	void setDataSource(DataSource source)
	    throws IllegalStateException
	{
	    synchronized (this) {
		if (!isRunning()) {
		    this.source = source;
		} else {
		    throw new IllegalStateException
			("now bench mark is running!");
		}
	    }
	}

	/**
	 * thread loopޤ
	 *
	 * @return	thread loop
	 */
	int getLoopCount()
	{
	    return loop;
	}

	/**
	{
	 * thread loopꤷޤ
	 *
	 * @param	loop
	 *		thread loop
	 * @throws	IllegalStateException
	 *		٥ޡ¹ΤȤ
	 * @throws	IllegalArgumentException
	 *		0ʲͤꤷ褦Ȥ
	 */
	void setLoopCount(int loop)
	    throws IllegalStateException, IllegalArgumentException
	{
	    if (loop > 0) {
		synchronized (this) {
		    if (!isRunning()) {
			this.loop = loop;
		    } else {
			throw new IllegalStateException
			    ("now bench mark is running!");
		    }
		}
	    } else {
		throw new IllegalArgumentException
		    ("can't set under 0");
	    }
	}

	/**
	 * ߥ٥ޡ¹椫ɤޤ
	 *
	 * @return	ߥ٥ޡ¹ʤtrue
	 */
	boolean isRunning()
	{
	    return isRunning;
	}

	/**
	 * ߥ٥ޡ¹椫ɤꤷޤ
	 * 
	 * @param	isRunning
	 *		ߥ٥ޡ¹ʤtrue
	 */
	private void setRunning(boolean isRunning)
	{
	    this.isRunning = isRunning;
	}

	/**
	 * ¹Է̤msñ̤ȤƼޤ 
	 *
	 * @return	msñ̤μ¹Է̻
	 * @throws	IllegalStateException
	 *		٥ޡ¹ΤȤ
	 */
	long getTotalTime()
	    throws IllegalStateException
	{
	    synchronized (this) {
		if (!isRunning()) {
		    return time;
		} else {
		    throw new IllegalStateException
			("now bench mark is running!");
		}
	    }
	}

	/**
	 * ¹Է̤msñ̤Ȥꤷޤ
	 * 
	 * @param	time
	 *		msñ̤μ¹Է̻
	 * @throws	IllegalStateException
	 *		٥ޡ¹ΤȤ
	 * @throws	IllegalArgumentException
	 *		ͤꤷȤ
	 */
	private void setTotalTime(long time)
	    throws IllegalStateException, IllegalArgumentException
	{
	    if (time >= 0) {
		synchronized (this) {
		    if (!isRunning()) {
			this.time = time;
		    } else {
			throw new IllegalStateException
			    ("now bench mark is running!");
		    }
		}
	    } else {
		throw new IllegalArgumentException
		    ("can't set minous value.");
	    }
	}
	    

	// action -------------------------------------------------------------
	/**
	 * ٥ޡưμ¹ԤԤʤޤ
	 */
	private void test()
	{
	    int lp = loop;
	    DataSource ds = source;
	    Connection con;

	    for (int i = 0; i < lp; i++) {
		try {
		    con = source.getConnection();
		    con.close();
		} catch (SQLException e) {
		    e.printStackTrace();
		}
	    }
	}
    }
}
