/*
 * $Id: BabyPoolBench0_0_12.java,v 1.1.1.1 2002/12/10 09:18:10 mitsuhito Exp $
 */


package jp.livewell.baby.db;


import java.util.Collection;
import javax.sql.DataSource;
import jp.livewell.baby.pool.jdbc.DataSourceBenchMarker;


/**
 * babyPool ver 0.0.12٥ޡޤ
 *
 * @author mitsuhito
 */
public class BabyPoolBench0_0_12
{
    // main -------------------------------------------------------------------
    /**
     * main.
     * 
     * @params	args
     *		index 0 = babyPoo.xml's place
     *		index 1 = thread size.
     *		index 2 = loop count.
     */
    public static void main(String[] args)
    {
	/* all args set ok? */
	DataSourceBenchMarker marker = null;
	{
	    DataSourceManager manager = DataSourceManager.getInstance();
	    try {
		if (args.length >= 3) {
		    String place	= args[0];
		    int	   threadSize	= Integer.parseInt(args[1]);
		    int    loopCount	= Integer.parseInt(args[2]);

		    manager.loadDataSources(place);
		    Collection sources = manager.dataSources();

		    if (sources.size() > 0) {
			marker = new DataSourceBenchMarker
			    ((DataSource) sources.toArray()[0],
			     threadSize,
			     loopCount);
		    }
		} else {
		    throw new RuntimeException
			("args not enougth\n"
			 + "length = " + args.length + "\n");
		}
	    } catch (Exception e) {
		e.printStackTrace();
	    } finally {
		if (marker == null) {
		    printUsage();
		    System.exit(0);
		}
	    }
	}


	marker.startBench();
	while (!marker.isFinished()) {
	    try {
		synchronized (marker) {
		    marker.wait(1000); // 1sec polling.
		}
	    } catch (InterruptedException e) {
		// do nothing
	    }
	}

	System.out.println("benchmark result is here...\n");

	long[] results	= marker.getResultTimes();
	long   min	= marker.getMin();
	long   max	= marker.getMax();
	long   avg	= marker.getAverage();

	for (int i = 0; i < results.length; i++) {
	    System.out.println((i + 1) + ". " + results[i] + " (ms)");
	}

	System.out.println("[min / avg / max (ms)]: "
			   + min + " / " + avg + " / " + max + "\n");
    }

    /**
     * ˡɸϤ˽Ϥޤ
     */
    private static void printUsage()
    {
	// currently do nothing. (please write down here way of use.)
    }
}
