/*
 * $Id: AbstractPool.java,v 1.1.1.1 2002/12/10 09:18:11 mitsuhito Exp $
 */


package jp.livewell.baby.pool;


import java.util.Collection;
import java.util.Iterator;


/**
 * סδŪʬAbstract classǤ
 * 
 * @author mitsuhito
 */
public abstract class AbstractPool
    implements Pool
{
    // pool properties attributes ---------------------------------------------
    private final PoolInfo checker;

    /** pool̾ */
    private final String name;

    /** poolκ祵 */
    private int max;
    
    /** poolκǾ */
    private int min;

    /** poolΥॢȻ(ms) */
    private int timeout;

    /** pool⥤󥹥󥹤ó(Ψ 0 < x < 1.0) */
    private float grow;

    /** pool⥤󥹥󥹤θ(Ψ 0 < x < 1.0) */
    private float shrink;

    /** סΥ󥹥󥹿Ĵûλֳִ(ms) */
    private int minInterval;

    /** סΥ󥹥󥹿Ĵ륢ɥλֳִ(ms) */
    private int idleInterval;


    // Pool state attributes --------------------------------------------------
    /** ߿WrapperǤȤtrue */
    private boolean isGrowing = false;

    /** WrapperǤȤtrue */
    private boolean isShrinking = false;


    // pool core parts --------------------------------------------------------
    /** סΥ󥹥factory */
    private final Factory factory;

    /** Poolؤλ */
    private final PoolReference ref;

    /** Poolͭγǧkey object */
    private final ComparisonKey key;


    // constructors & init ----------------------------------------------------
    /**
     * AbstractPoolס빽ۤ(PoolInfo)Factory鹽ۤޤ
     * 
     * @param	info
     *		ס빽ۤ
     * @param	factory
     *		ס뤵륤󥹥󥹤Factory
     */
    public AbstractPool(PoolInfo info,
			Factory  factory)
    {
	this(info, factory, new ComparisonKey());
    }

    /**
     * AbstractPoolס빽ۤ(PoolInfo)Factory鹽ۤޤ
     * 
     * @param	info
     *		ס빽ۤ
     * @param	factory
     *		ס뤵륤󥹥󥹤Factory
     * @param	key
     *		Poolͭγǧkey object
     */
    public AbstractPool(PoolInfo info,
			Factory  factory,
			ComparisonKey key)
    {
	name		= info.getName();
	max		= info.getMaxSize();
	min		= info.getMinSize();
	timeout		= info.getTimeout();
	grow		= info.getGrowPoint();
	shrink		= info.getShrinkPoint();
	minInterval	= info.getMinCheckInterval();
	idleInterval	= info.getIdleCheckInterval();
	checker		= info;
	this.factory	= factory;
	this.ref	= new PoolReference(this);
	this.key	= key;
    }


    // Pool properties implementation & setter --------------------------------
    /**
     * ס̾ޤ
     *
     * @return	Υס̾
     */
    public String getName()
    {
	return name;
    }

    /**
     * סΥॢȻ(ޤǤκԵ)ޤ
     *
     * @return	ॢȻ(ޤǤκԵ)
     */
    public int getTimeout()
    {
	return timeout;
    }

    /**
     * סΥॢȻ(ޤǤκԵ)ꤷޤ
     *
     * @param	timeout
     *		סΥॢȻ
     * @throws	IllegalArgumentException
     *		(PoolInfoʤ)ꤷ褦Ȥ硣
     */
    protected synchronized void setTimeout(int timeout)
	throws IllegalArgumentException
    {
	checker.setTimeout(timeout);
	this.timeout = timeout;
    }

    /**
     * סݻǤ륤󥹥󥹤κ祵ޤ
     *
     * @return	סݻǤ륤󥹥󥹤κ祵
     */
    public int getMaxSize()
    {
	return max;
    }

    /**
     * סݻǤ륤󥹥󥹤κ祵ꤷޤ
     *
     * @param	max
     *		סݻǤ륤󥹥󥹤κ祵
     * @throws	IllegalArgumentException
     *		(PoolInfoʤ)ꤷ褦Ȥ硣
     */
    protected synchronized void setMaxSize(int max)
	throws IllegalArgumentException
    {
	checker.setMaxSize(max);
	this.max = max;
    }

    /**
     * סݻƤ󥹥󥹤κǾޤ
     *
     * @return	סݻƤ󥹥󥹤κǾ
     */
    public int getMinSize()
    {
	return min;
    }

    /**
     * סݻƤ󥹥󥹤κǾꤷޤ
     *
     * @param	min
     *		סݻƤ󥹥󥹤κǾ
     * @throws	IllegalArgumentException
     *		(PoolInfoʤ)ꤷ褦Ȥ硣
     */
    protected synchronized void setMinSize(int min)
	throws IllegalArgumentException
    {
	checker.setMinSize(min);
	this.min = min;
    }

    /**
     * סΥ󥹥󥹿äϤסλΨޤ
     *
     * @return	󥹥󥹿äϤסλΨ
     */
    public float getGrowPoint()
    {
	return grow;
    }

    /**
     * סΥ󥹥󥹿äϤסλΨꤷޤ
     *
     * @param	grow
     *		סΥ󥹥󥹿äϤסλΨ
     * @throws	IllegalArgumentException
     *		(PoolInfoʤ)ꤷ褦Ȥ硣
     */
    protected synchronized void setGrowPoint(float grow)
	throws IllegalArgumentException
    {
	checker.setGrowPoint(grow);
	this.grow = grow;
    }

    /**
     * סΥ󥹥󥹿ϤסλΨޤ
     *
     * @return	󥹥󥹿ϤסλΨ
     */
    public float getShrinkPoint()
    {
	return shrink;
    }

    /**
     * סΥ󥹥󥹿ϤסλΨꤷޤ
     *
     * @param	shrink
     *		סΥ󥹥󥹿ϤסλΨ
     * @throws	IllegalArgumentException
     *		(PoolInfoʤ)ꤷ褦Ȥ硣
     */
    protected synchronized void setShrinkPoint(float shrink)
	throws IllegalArgumentException
    {
	checker.setShrinkPoint(shrink);
	this.shrink = shrink;
    }

    /**
     * סΥ󥹥󥹿Ĵûλֳִ(ms)ޤ
     *
     * @return	סΥ󥹥󥹿Ĵûλֳִ(ms)
     */
    public int getMinCheckInterval()
    {
	return minInterval;
    }

    /**
     * סΥ󥹥󥹿Ĵûλֳִ(ms)ꤷޤ
     * 
     * @param	minInterval
     *		סΥ󥹥󥹿Ĵûλֳִ(ms)
     * @throws	IllegalArgumentException
     *		(PoolInfoʤ)ꤷ褦Ȥ硣
     */
    protected synchronized void setMinCheckInterval(int minInterval)
	throws IllegalArgumentException
    {
	checker.setMinCheckInterval(minInterval);
	this.minInterval = minInterval;
    }

    /**
     * סΥ󥹥󥹿Ĵ륢ɥλֳִ(ms)ޤ
     *
     * @return	סΥ󥹥󥹿Ĵ륢ɥλֳִ(ms)
     */
    public int getIdleCheckInterval()
    {
	return idleInterval;
    }

    /**
     * סΥ󥹥󥹿Ĵ륢ɥλֳִ(ms)ꤷޤ
     *
     * @param	idleInterval
     *		סΥ󥹥󥹿Ĵ륢ɥλֳִ(ms)
     * @throws	IllegalArgumentException
     *		(PoolInfoʤ)ꤷ褦Ȥ硣
     */
    protected synchronized void setIdleCheckInterval(int idleInterval)
	throws IllegalArgumentException
    {
	checker.setIdleCheckInterval(idleInterval);
	this.idleInterval = idleInterval;
    }


    // Pool other accessor ----------------------------------------------------
    /**
     * Υס˳ǼƤinstanceƤFactoryޤ
     *
     * @return	FactoryΥ󥹥
     */
    public Factory getFactory()
    {
	return factory;
    }

    /**
     * PoolؤλȤޤ
     *
     * @return	Poolؤλ
     */
    public PoolReference getPoolReference()
    {
	return ref;
    }

    /**
     * PoolγǧKeyޤ
     *
     * @return	PoolγǧKey
     */
    protected ComparisonKey getComparisonKey()
    {
	return key;
    }


    // Pool action implementation & helpers -----------------------------------
    /**
     * ס뤵Ƥinstance1ļФޤinstance¸ߤʤ
     * getTimeoutǼ(ms)thread֥å졢θ
     * TimeoutExceptionthrowޤtimeout0ꤷƤ
     * ϼǤޤäޤͤꤷƤϼǤ
     * ¨¤null֤ޤ
     *
     * @return	ס뤵ƤWrapper objectޤnull
     * @throws	TimeoutException
     *		instanceʤä硣
     */
    public Wrapper takeout()
	throws TimeoutException
    {
	return takeout(timeout);
    }

    /**
     * instance1ġסᤷޤ⤷Υס뤫
     * instanceǤ̵硢IllegalArgumentExceptionthrowޤ
     *
     * @param	wrp
     *		PoolФ줿Wrapperinstance
     * @throws	IllegalArgumentException
     *		Υס뤫instanceʳ᤽Ȥ
     */
    public void restore(Wrapper wrp)
	throws IllegalArgumentException
    {
	try {
	    if (wrp.passivate(key)) {
		addPooledInstance(wrp);
	    }
	} catch (IllegalStateException e) {
	    dispose(wrp);
	}
    }	

    /**
     * Pool줿Wrapper instancePool᤹μ³򵭽
     * ޤΥ᥽åɤͿWrapperϤPool졢
     * passivateƤ뤳Ȥݾڤޤ
     *
     * @param	wrp
     *		Pool졢passivateƤ뤳Ȥݾڤ줿
     *		Wrapper instance
     */
    protected abstract void addPooledInstance(Wrapper wrp);

    /**
     * ס뤹instance1䤷ޤmaxSize¿䤷ޤ
     * ätrueᤷޤ
     *
     * @return	ätrue
     */
    public boolean grow()
    {
	boolean isSuccess = false;
	try {
	    synchronized (this) {
		if (!isGrowing && (getTotalSize() < max)) {
		    isGrowing = true;
		} else {
		    return false;
		}
	    }

	    Wrapper wrp = factory.create();
	    wrp.init(ref, key);

	    if (addNewInstance(wrp)) {
		isSuccess = true;
	    } else {
		wrp.destroy(key);
	    }

	} catch (Exception e) {
	    /*
	    System.err.println("grow throw exception. stack trace...\n");
	    e.printStackTrace();
	    */
	} finally {
	    synchronized (this) {
		isGrowing = false;
	    }
	}
	return isSuccess;
    }

    /**
     * 줿WrapperPoolinstanceȤϿޤ
     * Ͽtrue֤total+1ʤФʤޤ
     * 
     * @param	wrp
     *		줿Wrapper instance
     * @return	Ͽtrue
     */
    protected abstract boolean addNewInstance(Wrapper wpr);

    /**
     * ס뤹instance1ĸ餷ޤminSize̤ˤϸ餷ޤ
     * trueᤷޤ
     *
     * @return	true
     */
    public boolean shrink()
    {
	boolean isSuccess = false;
	try {
	    synchronized (this) {
		if (!isShrinking && (getTotalSize() > min)) {
		    isShrinking = true;
		} else {
		    return false;
		}
	    }

	    Wrapper wrp = takeout(-1);
	    if (wrp != null) {
		dispose(wrp);
		isSuccess = true;
	    }
	} catch (Exception e) {
	    /*
	    System.err.println("shrink throw exception. stack trace...\n");
	    e.printStackTrace();
	    */
	} finally {
	    synchronized (this) {
		isShrinking = false;
	    }
	}
	return isSuccess;
    }

}
