/*
 * $Id: AbstractWrapper.java,v 1.1.1.1 2002/12/10 09:18:11 mitsuhito Exp $
 */


package jp.livewell.baby.pool;


/**
 * WrapperưδŪʬclassǤ
 * 
 * @author mitsuhito
 */
public abstract class AbstractWrapper
    implements Wrapper
{
    // state attributes -------------------------------------------------------
    /** Ƥtrue */
    private boolean isInit = false;

    /** ͭƤtrue */
    private boolean isActive = false;

    /** destroyƤӽФƤtrue */
    private boolean isDestroy = false;


    // core parts -------------------------------------------------------------
    /** Poolؤλ */
    private PoolReference poolRef;

    /** PoolͭǧKey */
    private ComparisonKey key;


    // constructors & init ----------------------------------------------------
    /**
     * AbstractWrapperۤޤ
     */
    public AbstractWrapper()
    {
	setNullReference();
    }

    /**
     * NullPoolꤷޤ
     */
    private synchronized void setNullReference()
    {
	poolRef = NullPool.getInstance().getPoolReference();
	key	= NullPool.getDefaultComparisonKey();
    }

    /**
     * PoolѤkeyͿWrapperޤ1ٽ
     * 줿Wrapper2ܤνԤʤIllegalStateExceptionthrowޤ
     *
     * @param	ref
     *		Poolؤλ
     * @param	key
     *		Poolͭkey
     * @throws	IllegalStateException
     *		˽Ƥ
     */
    public synchronized void init(PoolReference poolRef,
				  ComparisonKey key)
	throws IllegalStateException
    {
	if (!isInit) {
	    if (poolRef != null) {
		this.poolRef	= poolRef;
		this.key	= key;
	    } else {
		setNullReference();
	    }

	    isInit = true;
	} else {
	    throw new IllegalStateException
		("already init this Wrapper!!");
	}
    }


    // Wrapper implementation & helpers ---------------------------------------
    /**
     * WrapperѲǽɤᤷޤdestroyƤӽФƤʤ
     * ֤ǡactivateƤʤtrueǤ
     *
     * @return	Ѳǽʤtrue
     */
    public synchronized boolean isWorkable()
    {
	return isActive && !isDestroy;
    }

    /**
     * WrapperͭȤPoolƤӽФޤtrue
     * ͭƤfalseᤵޤ񤹤Object
     * (ѤǤʤ)IllegalStateExceptionkeyפʤ
     * IllegalArgumentExceptionthrowޤΥ᥽åɤpingƤӽ
     * ޤ
     *
     * @param	key
     *		WrapperPoolͭComparisonKey
     * @return	trueͭƤfalse
     * @throws	IllegalStateException
     *		񤹤Object(ѤǤʤ)
     * @throws	IllegalArgumentException
     *		keyפʤ
     */
    public synchronized boolean activate(ComparisonKey key)
	throws IllegalStateException, IllegalArgumentException
    {
	boolean isSuccess = false;

	if (!isActive) {
	    if (this.key == key) {
		if (ping()) {
		    isActive	= true;
		    isSuccess	= true;
		} else {
		    throw new IllegalStateException
			("Wrapped Object is invalid state!");
		}
	    } else {
		throw new IllegalArgumentException
		    ("ComparisonKey not matched!");
	    }
	}
	return isSuccess;
    }

    /**
     * 񤹤Objectǧ˻Ѥޤ
     * sub classŬڤƤ򵭽ҤƲ
     *
     * @return	ƤŬڤʤtrue
     */
    protected abstract boolean ping();


    /**
     * Wrapper̵ȤPoolƤӽФޤtrue
     * ̵Ƥfalseᤵޤkeyפʤ
     * IllegalArgumentExceptionthrowޤ
     *
     * @param	key
     *		WrapperPoolͭComparisonKey
     * @return	true̵Ƥfalse
     * @throws	IllegalStateException
     *		Ǥʤͳ̵ʤ
     * @throws	IllegalArgumentException
     *		keyפʤ
     */
    public synchronized boolean passivate(ComparisonKey key)
	throws IllegalStateException, IllegalArgumentException
    {
	boolean isSuccess = false;

	if (isActive) {
	    if (this.key == key) {
		isActive	= false;
		isSuccess	= true;
	    } else {
		throw new IllegalArgumentException
		    ("ComparisonKey not matched!");
	    }
	}
	return isSuccess;
    }

    /**
     * instancePoolᤷޤ
     */
    public void release()
    {
	poolRef.get().restore(this);
    }

    /**
     * WrapperԲĤˤݤƤ꥽ľ˳
     * isWorkablefalseꤷޤ̾盧Υ᥽åɤPoolƤФޤ
     * destroyƤӽФ줿Wrapperưݾڤޤ
     * keyפʤIllegalArgumentExceptionthrowޤ
     *
     * @param	key
     *		WrapperPoolͭComparisonKey
     * @throws	IllegalArgumentException
     *		keyפʤ
     */
    public synchronized void destroy(ComparisonKey key)
	throws IllegalArgumentException
    {
	if (this.key == key) {
	    try {
		if (isActive) {
		    passivate(key);
		}
	    } catch (Exception e) {
		/* System.err.println("destroy throw exception."); // debug
		   e.printStackTrace(); */
	    } finally {
		isDestroy = true;
		setNullReference();
	    }
	} else {
	    throw new IllegalArgumentException
		("ComparisonKey not matched!");
	}
    }


    // over rides -------------------------------------------------------------
    /**
     * java.lang.Objectfinalize򥪡С饤ɤޤWrapperס
     * ᤵ줺ˤλȤ¾Υ󥹥󥹤餿ɤʤʤäν
     * 򵭽Ҥޤ
     *
     * @throws	Throwable
     *		Υ᥽åɤǽǤʤäExceptionError
     */
    protected void finalize()
	throws Throwable
    {
	try {
	    synchronized (this) {
		poolRef.get().dispose(this);
	    }
	} catch (Exception e) {
	    e.printStackTrace();
	    throw e;
	}
    }


    // other accessors --------------------------------------------------------
    /**
     * WrapperƤ뤫ɤᤷޤ
     *
     * @return	Ƥtrue
     */
    protected boolean isInitialized()
    {
	return isInit;
    }

    /**
     * WrapperͭƤ뤫ɤᤷޤ
     *
     * @return	ͭƤtrue
     */
    protected boolean isActivated()
    {
	return isActive;
    }

    /**
     * WrapperԲĤˤƤ뤫ɤᤷޤ
     *
     * @return	ԲĤˤƤtrue
     */
    protected boolean isDestroyed()
    {
	return isDestroy;
    }

    /**
     * Wapper instancePoolؤλȤޤ
     *
     * @return	Wapper instancePoolؤλ
     */
    protected PoolReference getPoolReference()
    {
	return poolRef;
    }

    /**
     * Wapper instancePoolͭǧkeyޤ
     *
     * @return	Wapper instancePoolͭǧkey
     */
    protected ComparisonKey getComparisonKey()
    {
	return key;
    }
}
