/*
 * $Id: DefaultPool.java,v 1.1.1.1 2002/12/10 09:18:11 mitsuhito Exp $
 */


package jp.livewell.baby.pool;


import java.util.Collection;
import java.util.Iterator;


/**
 * סɸμ򤷤classǤ
 * 
 * @author mitsuhito
 */
public class DefaultPool
    extends AbstractPool
{
    // state attributes -------------------------------------------------------
    /** סΥ󥹥󥹤 */
    private int total = 0;

    /** ԵƤThreadο */
    private int waits = 0;


    // pool core parts --------------------------------------------------------
    /** poolγǼQueue */
    private final Queue queue;

    /** סΥ󥹥󥹿ĴThread */
    private final Blancer blancer;

    /** queue˥᤯Ǥ륭å */
    private Wrapper cache = null;


    // constructors & init ----------------------------------------------------
    /**
     * DefaultPoolס빽ۤ(PoolInfo)Factory鹽ۤޤ
     * 
     * @param	info
     *		ס빽ۤ
     * @param	factory
     *		ס뤵륤󥹥󥹤Factory
     */
    public DefaultPool(PoolInfo info,
		       Factory  factory)
    {
	super(info, factory);
	queue		= new Queue(getMaxSize());
	blancer		= new Blancer(this);
	blancer.start();
    }


    // over rides -------------------------------------------------------------
    /**
     * סݻǤ륤󥹥󥹤κ祵ꤷޤ
     *
     * @param	max
     *		סݻǤ륤󥹥󥹤κ祵
     * @throws	IllegalArgumentException
     *		(PoolInfoʤ)ꤷ褦Ȥ硣
     */
    protected synchronized void setMaxSize(int max)
	throws IllegalArgumentException
    {
	super.setMaxSize(max);

	ComparisonKey key = getComparisonKey();
	Collection overs = queue.addjustMax(max);

	for (Iterator itr = overs.iterator(); itr.hasNext();) {
	    Wrapper wrp = (Wrapper) itr.next();
	    wrp.destroy(key);
	}
    }

    /**
     * סΥ󥹥󥹿Ĵûλֳִ(ms)ꤷޤ
     * 
     * @param	minInterval
     *		סΥ󥹥󥹿Ĵûλֳִ(ms)
     * @throws	IllegalArgumentException
     *		(PoolInfoʤ)ꤷ褦Ȥ硣
     */
    protected synchronized void setMinCheckInterval(int minInterval)
	throws IllegalArgumentException
    {
	super.setMinCheckInterval(minInterval);
	blancer.timingChanged();
    }

    /**
     * סΥ󥹥󥹿Ĵ륢ɥλֳִ(ms)ꤷޤ
     *
     * @param	idleInterval
     *		סΥ󥹥󥹿Ĵ륢ɥλֳִ(ms)
     * @throws	IllegalArgumentException
     *		(PoolInfoʤ)ꤷ褦Ȥ硣
     */
    protected synchronized void setIdleCheckInterval(int idleInterval)
	throws IllegalArgumentException
    {
	super.setIdleCheckInterval(idleInterval);
	blancer.timingChanged();
    }


    // Pool current state implementation --------------------------------------
    /**
     * ߳˼ФƤ륤󥹥󥹤οޤ
     *
     * @return	߳˼ФƤ륤󥹥󥹤ο
     */
    public synchronized int getRemovedSize()
    {
	return total - getStoredSize();
    }

    /**
     * ߥסݻƤ륤󥹥󥹤ο֤ޤ
     *
     * @return	ߥסݻƤ륤󥹥󥹤ο
     */
    public synchronized int getStoredSize()
    {
	return queue.size() + ((cache != null) ? 1 : 0);
    }

    /**
     * ݻϳ˼ФƤ륤󥹥󥹤ιפޤ
     *
     * @return	ݻϳ˼ФƤ륤󥹥󥹤ι
     */
    public synchronized int getTotalSize()
    {
	return total;
    }

    /**
     * ߥ󥹥󥹤ԤƤthreadοޤ
     *
     * @return	ߥ󥹥󥹤ԤƤthreadο
     */
    public synchronized int getWaitSize()
    {
	return waits;
    }


    // Pool action implementation & helpers -----------------------------------
    /**
     * ס˳ǼƤ륤󥹥󥹤1ļФޤ
     * 󥹥󥹤¸ߤʤgetTimeoutǼ(ms)thread
     * å졢θTimeoutExceptionthrowޤtimeout0
     * ꤷƤϼǤޤäޤ
     *
     * @param	maxTime
     *		󥹥󥹼κԤ֡0ꤹȼǤޤ
     *		ԤͤꤹȼǤʤnullᤷޤ
     * @return	ǼƤ󥹥󥹤ݻWrapper object
     * @throws	TimeoutException
     *		󥹥󥹤ʤä硣
     */
    public Wrapper takeout(int maxTime)
	throws TimeoutException
    {
	while (true) {
	    Wrapper wrp = null;
	    boolean more = true;

	    synchronized (this) {
		while (true) {
		    if ((wrp = cache) != null) {
			cache = null;
			break;
		    } else if ((wrp = queue.remove()) != null) {
			break;
		    } else if (more) {
			if (maxTime >= 0) {
			    waits++;
			    try {
				wait(maxTime);
			    } catch (InterruptedException e) {
				// do nothing
			    }
			    waits--;
			    more = (maxTime == 0);
			} else {
			    return null;
			}
		    } else {
			throw new TimeoutException();
		    }
		}
	    }

	    // test instance is normal?
	    try {
		wrp.activate(getComparisonKey());
		return wrp;
	    } catch (IllegalStateException e) {
		// case bad condition, dispose it.
		/* 
		System.out.println
		   ("activation fail. wrapper is " + wrp); // for debug
		*/
		dispose(wrp);
	    }
	}
    }

    /**
     *
     */
    protected synchronized void addPooledInstance(Wrapper wrp)
    {
	if (cache == null) {
	    cache = wrp;
	} else if (!queue.add(wrp)) {
	    dispose(wrp);
	    return;
	}

	if (waits > 0) {
	    notify();
	}
    }

    /**
     *
     */
    protected synchronized boolean addNewInstance(Wrapper wrp)
    {
	boolean isSuccess = false;
	if (cache == null) {
	    cache = wrp;
	    isSuccess = true;
	} else {
	    isSuccess = queue.add(wrp);
	}

	if (isSuccess) {
	    total++;
	    
	    if (waits > 0) {
		notify();
	    }
	}
	return isSuccess;
    }

    /**
     * 󥹥󥹤1˴ޤΥס뤫󥹥
     * 󥹤ǤϤʤ硢IllegalArgumentExceptionthrowޤ
     *
     * @param	wrp
     *		˴Wrapper
     * @throws	IllegalArgumentException
     *		Υס뤫󥹥󥹰ʳ˴褦Ȥ
     */
    public void dispose(Wrapper wrp)
	throws IllegalArgumentException
    {
	try {
	    wrp.destroy(getComparisonKey());
	    synchronized (this) {
		total--;
	    }
	} finally {
	    /*System.out.println("Wrapper dispose = " + wrp); // debug */
	}
    }


    // blancer thread ---------------------------------------------------------
    /**
     * ס˳ǼƤ륤󥹥󥹿Ĵ뤿Threadsub class
     * Ǥ
     */
    private final class Blancer
	extends Thread
    {
	// attributes ---------------------------------------------------------
	/** Х󥹤оݤpool */
	private final Pool pool;

	/** PoolΥХ󥹥ߥ󥰤Υѥ᡼ѹ줿򼨤ե饰 */
	private boolean changed = false;

	/** û󥿡ХˤΨ(0 <= x <= 1.0) */
	private float center;

	/** rateAvg = 0λidleInterval */
	private int adjust;
	

	// constructors & init ------------------------------------------------
	/**
	 * Blancerۤޤ
	 * 
	 * @param	pool
	 *		Х󥹤PoolΥ󥹥
	 */
	Blancer(Pool pool)
	{
	    super(pool.getName() + "'s blancer");
	    this.pool = pool;
	    recalcTiming();
	}


	// over rides ---------------------------------------------------------
	/**
	 * start򥪡С饤ɤޤdaemon threadޤ
	 */
	public void start()
	{
	    setDaemon(true);
	    super.start();
	}

	/**
	 * run򥪡С饤ɤޤХ󥹤褦ưޤ
	 */
	public void run()
	{
	    float rateAvg = 0;

	    while (true) {
		/* System.out.println("blancer start"); // for debug */
		int	blance	= 0;
		int	max	= 0;
		int	min	= 0;
		int	removed	= 0;
		int	waits	= 0;
		int	total	= 0;
		float	rate	= 0;
		boolean	isMore	= false;


		/* 1st step. calc current rate & calc blance. */
		synchronized (pool) {
		    max		= pool.getMaxSize();
		    min		= pool.getMinSize();
		    removed	= pool.getRemovedSize();
		    waits	= pool.getWaitSize();
		    total	= pool.getTotalSize();

		    if (total > 0) {
			rate = ((float) (removed + waits)) / (float) total;
		    } else {
			rate = removed + waits; // ( / 1.0F)
		    }
		    /* !caution! ޤʤ
		       ͤĴǤ褦ˤ뤫ɤƤ */
		    rateAvg = ((rateAvg * 7) + rate) / 8;

		    if ((min <= total) && (total <= max)) {
			if ((total != max) && 
				(rateAvg >= pool.getGrowPoint())) {
			    blance++;
			} else if ((total != min) && 
				   (rateAvg <= pool.getShrinkPoint())) {
			    blance--;
			}
		    } else {
			blance++;
		    }

		    /*
		    System.out.println
			("[" + pool.getName() + ": "
                         + "rate = " + rate + "(avg: " + rateAvg + "):: "
			 + "((removed: " + removed 
			 + " + wait: " + waits + ") / "
			 + "total: " + total + ")]"); // for debug
		    */
		}


		/* 2nd step. adjust size */
		if (blance != 0) {
		    if (blance > 0) {
			isMore = pool.grow();
		    } else if (blance < 0) {
			isMore = pool.shrink();
		    }
		    /* totalѹƤΤǺƷ׻
		       newRate = (oldRate * oldTotal) / newTotal */
		    rateAvg = (rateAvg * total) / pool.getTotalSize();
		}


		/* 3rd step. zzz.... */
		if (!isMore) {
		    synchronized (this) {
			if (changed) {
			    recalcTiming();
			}

			float x = rateAvg - center;
			int minIv = getMinCheckInterval();
			int wait = ((int) (adjust * (x * x))) + minIv;

			/*
			System.out.println
			    ("[blancer wait = " + wait + "]"); // for debug
			*/

			try {
			    wait(wait);
			} catch (InterruptedException e) {
			    // do nothing
			}
		    }
		}
	    }
	}


	// accessor -----------------------------------------------------------
	/**
	 * pool˥å򤫤륿ߥ󥰥ѥ᡼ѹ줿Ȥ˸Ƥ
	 * Фޤ
	 */
	synchronized void timingChanged()
	{
	    changed = true;
	}


	// action -------------------------------------------------------------
	/**
	 * waitֳִ֤()׻ޤ
	 * ʲн񤭡
	 * center = (grow - shrink) / 2;
	 * waittime = adjust * ((rateAvg - center)2) + minInterval;
	 * δطǤΤǡidleIntervalrateAvg = 0ξǤ顢
	 * idleInterval = adjust * (center2) + minInterval;
	 * adjust = (idleInterval - minInterval) / (center2)Ǥ
	 */
	private synchronized void recalcTiming()
	{
	    center = (getGrowPoint() + getShrinkPoint()) / 2;
	    adjust = (int) ((getIdleCheckInterval() - getMinCheckInterval())
			    / (center * center));
	    changed = false;
	}
    }
}
