/*
 * $Id: NullPool.java,v 1.1.1.1 2002/12/10 09:18:11 mitsuhito Exp $
 */


package jp.livewell.baby.pool;


/**
 * Poolnull objectǤWrapper ˴ʤɤˤѤޤ
 *
 * @author mitsuhito
 */
final class NullPool
    extends AbstractPool
{
    // singleton --------------------------------------------------------------
    /** singleton instance */
    private static NullPool single = null;

    /**
     * NullPoolƱVMǤͣinstanceޤ
     *
     * @return	NullPoolƱVMǤͣinstance
     */
    static synchronized NullPool getInstance()
    {
	if (single == null) {
	    PoolInfo info = new PoolInfo();
	    info.setName("NullPool");

	    single = new NullPool(info, new NullFactory());
	}
	return single;
    }

    /**
     * singletonΤprivate construstor
     *
     * @param	info
     *		ߡPoolInfo
     * @param	factory
     *		NullFactoryѤޤ
     */
    private NullPool(PoolInfo info,
		     NullFactory factory)
    {
	super(info, factory);
    }


    // Pool implementation ----------------------------------------------------
    /**
     * 0֤ޤ
     * 
     * @return	0
     */
    public int getRemovedSize()
    {
	return 0;
    }

    /**
     * 0֤ޤ
     * 
     * @return	0
     */
    public int getStoredSize()
    {
	return 0;
    }

    /**
     * 0֤ޤ
     * 
     * @return	0
     */
    public int getTotalSize()
    {
	return 0;
    }

    /**
     * 0֤ޤ
     * 
     * @return	0
     */
    public int getWaitSize()
    {
	return 0;
    }

    /**
     * null֤ޤ
     * 
     * @return	null
     */
    public Wrapper takeout(int waitTime)
    {
	return null;
    }

    /**
     * disposeޤ
     * 
     * @param	wrp
     *		Wrapper
     * @throws	IllegalArgumentException
     *		throwޤ 
     */
    public void restore(Wrapper wrp)
	throws IllegalArgumentException
    {
	try {
	    super.restore(wrp);
	} catch (IllegalArgumentException e) {
	    // do nothing
	}
    }

    /**
     * false֤ޤ
     * 
     * @return	false
     */
    public boolean grow()
    {
	return false;
    }

    /**
     * false֤ޤ
     * 
     * @return	false
     */
    public boolean shrink()
    {
	return false;
    }

    /**
     * @param	wrp
     *		˴륤󥹥
     * @throws	IllegalArgumentException
     *		Υס뤫󥹥󥹰ʳ˴褦Ȥ
     */
    public void dispose(Wrapper wrp)
	throws IllegalArgumentException
    {
	try {
	    wrp.destroy(getComparisonKey());
	} catch (IllegalArgumentException e) {
	    // do nothing
	}
    }


    // other accessors --------------------------------------------------------
    /**
     * NullPoolComparisonKeyޤ
     *
     * @return	NullPoolComparisonKey
     */
    public static ComparisonKey getDefaultComparisonKey()
    {
	return getInstance().getComparisonKey();
    }


    // over rides -------------------------------------------------------------
    /**
     * disposeޤ
     *
     * @param	wrp
     *		disposeWrapper
     */
    protected synchronized void addPooledInstance(Wrapper wrp)
    {
	dispose(wrp);
    }

    /**
     * ɲäǤޤ
     *
     * @param	wrp
     *		ꤷƤ̣Ϥޤ
     */
    protected synchronized boolean addNewInstance(Wrapper wrp)
    {
	return false;
    }
}
