/*
 * $Id
 */


package jp.livewell.baby.pool;


/**
 * PoolưԤclassinterfaceǤ
 *
 * @author mitsuhito
 */
public interface Pool
{
    // pool properties --------------------------------------------------------
    /**
     * ס̾ޤ
     *
     * @return	Υס̾
     */
    String getName();

    /**
     * סΥॢȻ(ޤǤκԵ)ޤ
     *
     * @return	ॢȻ(ޤǤκԵ)
     */
    int getTimeout();

    /**
     * סݻǤ륤󥹥󥹤κ祵ޤ
     *
     * @return	סݻǤ륤󥹥󥹤κ祵
     */
    int getMaxSize();

    /**
     * סݻƤ󥹥󥹤κǾޤ
     *
     * @return	סݻƤ󥹥󥹤κǾ
     */
    int getMinSize();

    /**
     * סΥ󥹥󥹿äϤסλΨޤ
     *
     * @return	󥹥󥹿äϤסλΨ
     */
    float getGrowPoint();

    /**
     * סΥ󥹥󥹿ϤסλΨޤ
     *
     * @return	󥹥󥹿ϤסλΨ
     */
    float getShrinkPoint();

    /**
     * סΥ󥹥󥹿Ĵûλֳִ(ms)ޤ
     *
     * @return	סΥ󥹥󥹿Ĵûλֳִ(ms)
     */
    int getMinCheckInterval();

    /**
     * סΥ󥹥󥹿Ĵ륢ɥλֳִ(ms)ޤ
     *
     * @return	סΥ󥹥󥹿Ĵ륢ɥλֳִ(ms)
     */
    int getIdleCheckInterval();
    
    
    // current state ----------------------------------------------------------
    /**
     * ߳˼ФƤ륤󥹥󥹤οޤ
     *
     * @return	߳˼ФƤ륤󥹥󥹤ο
     */
    int getRemovedSize();

    /**
     * ߥסݻƤ륤󥹥󥹤ο֤ޤ
     *
     * @return	ߥסݻƤ륤󥹥󥹤ο
     */
    int getStoredSize();

    /**
     * ݻϳ˼ФƤ륤󥹥󥹤ιפޤ
     *
     * @return	ݻϳ˼ФƤ륤󥹥󥹤ι
     */
    int getTotalSize();

    /**
     * ߥ󥹥󥹤ԤƤthreadοޤ
     *
     * @return	ߥ󥹥󥹤ԤƤthreadο
     */
    int getWaitSize();


    // other accessor ---------------------------------------------------------
    /**
     * Υס˳ǼƤ륤󥹥󥹤ƤFactoryΥ
     * 󥹤ޤ
     *
     * @return	ΥסFactory
     */
    Factory getFactory();

    /**
     * PoolؤλȤޤ
     *
     * @return	Poolؤλ
     */
    PoolReference getPoolReference();


    // action -----------------------------------------------------------------
    /**
     * ס˳ǼƤ륤󥹥󥹤1ļФޤ
     * 󥹥󥹤¸ߤʤgetTimeoutǼ(ms)thread
     * å졢θTimeoutExceptionthrowޤtimeout0
     * ꤷƤϼǤޤäޤͤꤷƤ
     * ϼǤʤ¨¤null֤ޤ
     *
     * @return	ǼƤ󥹥󥹤ݻWrapper object
     *		ޤnull
     * @throws	TimeoutException
     *		󥹥󥹤褺timeout( > 0)ʾ֤вᤷ
     *		硣
     */
    Wrapper takeout()
	throws TimeoutException;

    /**
     * ס˳ǼƤ륤󥹥󥹤1ļФޤ
     * 󥹥󥹤¸ߤʤmaxWaitǼ(ms)thread
     * å졢θTimeoutExceptionthrowޤmaxWait0
     * ꤷƤϼǤޤäޤͤꤷƤ
     * ϼǤʤ¨¤null֤ޤ
     *
     * @param	maxTime
     *		󥹥󥹼κԤ֡0ꤹȼǤޤ
     *		ԤͤꤹȼǤʤnullᤷޤ
     * @return	ǼƤ󥹥󥹤ݻWrapper object
     *		ޤnull
     * @throws	TimeoutException
     *		󥹥󥹤褺maxWait( > 0)ʾ֤вᤷ
     *		硣
     */
    Wrapper takeout(int maxTime)
	throws TimeoutException;

    /**
     * 󥹥󥹤1ġסᤷޤ⤷Υס뤫
     * 󥹥󥹤Ǥ̵硢IllegalArgumentExceptionthrowޤ
     *
     * @param	wrapper
     *		ŪobjectݻWrapperΥ󥹥
     * @throws	IllegalArgumentException
     *		Υס뤫󥹥󥹰ʳ᤽Ȥ
     */
    void restore(Wrapper wrapper)
	throws IllegalArgumentException;

    /**
     * ס뤹륤󥹥󥹤1䤷ޤmaxSize¿䤷ޤ
     * ätrueᤷޤ
     *
     * @return	ätrue
     */
    boolean grow();

    /**
     * ס뤹륤󥹥󥹤1ĸ餷ޤminSize̤ˤϸ餷ޤ
     * trueᤷޤ
     *
     * @return	true
     */
    boolean shrink();

    /**
     * 󥹥󥹤1˴ޤΥס뤫󥹥
     * 󥹤ǤϤʤ硢IllegalArgumentExceptionthrowޤ
     *
     * @param	wrapper
     *		˴륤󥹥
     * @throws	IllegalArgumentException
     *		Υס뤫󥹥󥹰ʳ˴褦Ȥ
     */
    void dispose(Wrapper wrapper)
	throws IllegalArgumentException;
}
