/*
 * $Id: PoolInfo.java,v 1.1.1.1 2002/12/10 09:18:11 mitsuhito Exp $
 */


package jp.livewell.baby.pool;


/**
 * ס빽ۤǼclassǤ
 * 
 * @author mitsuhito
 */
public class PoolInfo
    implements Cloneable
{
    // attributes -------------------------------------------------------------
    /** ס̾ */
    private String name;

    /** סκ祵 */
    private int max;
    
    /** סκǾ */
    private int min;

    /** סΥॢȻ(ޤǤκԵ) */
    private int timeout;

    /** 󥹥󥹤ϤסλΨ(0 < x < 1) */
    private float grow;

    /** 󥹥󥹤˴ϤסλΨ(0 < x < 1) */
    private float shrink;

    /** סΥ󥹥󥹿Ĵûλֳִ(ms) */
    private int minInterval;

    /** סΥ󥹥󥹿Ĵ륢ɥλֳִ(ms) */
    private int idleInterval;
    
    
    // constructors & init ----------------------------------------------------
    /**
     * PoolInfoۤޤ
     */
    public PoolInfo()
    {
	init();
    }

    /**
     * ꤵ줿PoolInfoƱPoolInfoۤޤ
     *
     * @param	master
     *		ԡˤʤPoolInfo
     */
    protected PoolInfo(PoolInfo master)
    {
	name		= master.getName();
	max		= master.getMaxSize();
	min		= master.getMinSize();
	timeout		= master.getTimeout();
	grow		= master.getGrowPoint();
	shrink		= master.getShrinkPoint();
	minInterval	= master.getMinCheckInterval();
	idleInterval	= master.getIdleCheckInterval();
    }

    /**
     * PoolInfoɸͤǽޤ
     *
     * name		= ""
     * max		= 10
     * min		= 5
     * timeout		= 0 
     * grow		= 0.80F 
     * shrink		= 0.20F
     * minInterval	= 100
     * idleInterval	= 1000
     * Ǥ
     */
    private void init()
    {
	name		= "defaultPool";
	max		= 10;
	min		= 5;
	timeout		= 0;
	grow		= 0.80F;
	shrink		= 0.20F;
	minInterval	= 100;
	idleInterval	= 1000;
    }


    // Cloneable implementation -----------------------------------------------
    /**
     * objectʣޤdeep copyϺޤ
     * 
     * @return	objectʣ
     */
    public Object clone()
    {
	return new PoolInfo(this);
    }


    // over rides -------------------------------------------------------------
    /**
     * ꤵ줿objectobjectӤޤ
     *
     * @param	o
     *		оݤobject
     * @return	ƤͤƱJdbcInfoξˤtrueʳfalse
     */
    public boolean equals(Object o)
    {
 	boolean isSame = false;
	if (o instanceof PoolInfo) {
	    PoolInfo other = (PoolInfo) o;
	    
	    isSame = name.equals(other.getName())
		&& max == other.getMaxSize()
		&& min == other.getMinSize()
		&& timeout == other.getTimeout()
		&& grow == other.getGrowPoint()
		&& shrink == other.getShrinkPoint()
		&& minInterval == other.getMinCheckInterval()
		&& idleInterval == other.getIdleCheckInterval();
	}
	return isSame;
    }

    /**
     * Υ󥹥󥹤ʸɽޤ
     *
     * @return	Υ󥹥󥹤ʸɽ
     */
    public String toString()
    {
	return new StringBuffer()
	    .append(getClass().getName()).append("\n")
	    .append("name = ").append(name).append("\n")
	    .append("maxSize = ").append(max).append("\n")
	    .append("minSize = ").append(min).append("\n")
	    .append("timeout = ").append(timeout).append("\n")
	    .append("growPoint = ").append(grow).append("\n")
	    .append("shrinkPoint = ").append(shrink).append("\n")
	    .append("minCheckInterval = ").append(minInterval).append("\n")
	    .append("idleCheckInterval = ").append(idleInterval).append("\n\n")
	    .toString();
    }


    // accessor ---------------------------------------------------------------
    /**
     * ס̾ޤ
     *
     * @return	ס̾
     */
    public String getName()
    {
	return name;
    }

    /**
     * ס̾ꤷޤ
     *
     * @param	name
     *		ס̾
     * @throws	IllegalArgumentException
     *		̾ʸޤޤƤȤ
     */
    public void setName(String name)
	throws IllegalArgumentException
    {
	if (name != null) {
	    boolean found = false;

	    final char[] illegals = 
		{'!', '@', '#', '$', '%', '^', '&', '*', '(', ')', '=', '+',
		 '\\', '|', '`', '~', '[', '{', ']', '}', ';', ':', '\'', 
		 '"', ',', '<', '.', '>', '/', '?'};

	    for (int i = 0; i < illegals.length; i++) {
		if (name.indexOf(illegals[i]) > -1) {
		    throw new IllegalArgumentException
			("illegal string found in name = " + name);
		}
	    }
	    this.name = name;
	} else {
	    throw new NullPointerException("can't set null name");
	}
    }
    
    /**
     * סݻǤ륤󥹥󥹤κ祵ޤ
     *
     * @return	ݻǤ륤󥹥󥹤κ祵
     */
    public int getMaxSize()
    {
	return max;
    }

    /**
     * סݻǤ륤󥹥󥹤κ祵ޤ
     * 
     * @param	max
     *		סκ祵
     * @throws	IllegalArgumentException
     *		祵0ʲꤷ褦ȤȤ
     */
    public void setMaxSize(int max)
	throws IllegalArgumentException
    {
	if (max > 0) {
	    this.max = max;
	} else {
	    throw new IllegalArgumentException("can't set max size under 0");
	}
    }

    /**
     * סκǾޤ
     *
     * @return	סκǾ
     */
    public int getMinSize()
    {
	return min;
    }

    /**
     * סκǾꤷޤ
     * 
     * @param	min
     *		Ǿ
     * @throws	IllegalArgumentException
     *		祵0̤ꤷ褦ȤȤ
     */
    public void setMinSize(int min)
	throws IllegalArgumentException
    {
	if (min >= 0) {
	    this.min = min;
	} else {
	    throw new IllegalArgumentException
		("can't set max size less than 0");
	}
    }

    /**
     * ס뤫objectݤΥॢ(Ԥ)ޤ
     *
     * @return	objectΥॢ(Ԥ)
     */
    public int getTimeout()
    {
	return timeout;
    }

    /**
     * ס뤫objectݤΥॢ(Ԥ)ꤷޤ
     * 0ξϥॢ̵ǤͤϼǤʤ¨¤null
     * ᤷޤ
     *
     * @param	timeout
     *		objectΥॢ(Ԥ)
     */
    public void setTimeout(int timeout)
    {
	this.timeout = timeout;
    }

    /**
     * 󥹥󥹤ϤסλΨޤ
     *
     * @return	grow
     *		󥹥󥹤ϤסλΨ
     */
    public float getGrowPoint()
    {
	return grow;
    }

    /**
     * 󥹥󥹤ϤסλΨꤷޤ
     * 0 < grow < 1 ϰϤǤޤʳͤꤷ褦Ȥ
     * IllegalArgumentExceptionthrowޤ
     *
     * @param	grow
     *		󥹥󥹤ϤסλΨ
     * @throws	IllegalArgumentException
     *		0 < grow < 1 ʳͤꤷ褦Ȥ
     */
    public void setGrowPoint(float grow)
	throws IllegalArgumentException
    {
	if (0 < grow && grow < 1) {
	    this.grow = grow;
	} else {
	    throw new IllegalArgumentException
		("can't set grow point under 0 or over 1.");
	}
    }

    /**
     * 󥹥󥹤˴ϤסλΨޤ
     *
     * @return	shrink
     *		󥹥󥹤˴ϤסλΨ
     */
    public float getShrinkPoint()
    {
	return shrink;
    }

    /**
     * 󥹥󥹤˴ϤסλΨꤷޤ
     * 0 < shrink < 1 ϰϤǤޤʳͤꤷ褦Ȥ
     * IllegalArgumentExceptionthrowޤ
     *
     * @param	shrink
     *		󥹥󥹤˴ϤסλΨ
     * @throws	IllegalArgumentException
     *		0 < shrink < 1 ʳͤꤷ褦Ȥ
     */
    public void setShrinkPoint(float shrink)
	throws IllegalArgumentException
    {
	if (0 < shrink && shrink < 1) {
	    this.shrink = shrink;
	} else {
	    throw new IllegalArgumentException
		("can't set shrink point under 0 or over 1.");
	}
    }

    /**
     * סΥ󥹥󥹿Ĵûλֳִ(ms)ޤ
     *
     * @return	סΥ󥹥󥹿Ĵûλֳִ(ms)
     */
    public int getMinCheckInterval()
    {
	return minInterval;
    }

    /**
     * סΥ󥹥󥹿Ĵûλֳִ(ms)ꤷޤ
     * 
     * @param	minInterval
     *		סΥ󥹥󥹿Ĵûλֳִ(ms)
     * @throws	IllegalArgumentException
     *		0ʲͤꤷ褦Ȥ
     */
    public void setMinCheckInterval(int minInterval)
	throws IllegalArgumentException
    {
	if (0 < minInterval) {
	    this.minInterval = minInterval;
	} else {
	    throw new IllegalArgumentException
		("can't set minimum check interval to under 0.");
	}
    }

    /**
     * סΥ󥹥󥹿Ĵ륢ɥλֳִ(ms)ޤ
     *
     * @return	סΥ󥹥󥹿Ĵ륢ɥλֳִ(ms)
     */
    public int getIdleCheckInterval()
    {
	return idleInterval;
    }

    /**
     * סΥ󥹥󥹿Ĵ륢ɥλֳִ(ms)ꤷޤ
     * 
     * @param	idleInterval
     *		סΥ󥹥󥹿Ĵ륢ɥλֳִ(ms)
     * @throws	IllegalArgumentException
     *		0ʲͤꤷ褦Ȥ
     */
    public void setIdleCheckInterval(int idleInterval)
	throws IllegalArgumentException
    {
	if (0 < idleInterval) {
	    this.idleInterval = idleInterval;
	} else {
	    throw new IllegalArgumentException
		("can't set idle check interval to under 0.");
	}
    }
}
