/*
 * $Id: Queue.java,v 1.1.1.1 2002/12/10 09:18:11 mitsuhito Exp $
 */

package jp.livewell.baby.pool;


import java.util.ArrayList;
import java.util.Collection;


/**
 * PoolγˤˤʤQueueǤclassthreadФưǤϤޤ
 *
 * @author mitsuhito
 */
class Queue
{
    // ------------------------------------------------------------------------
    /** QueueWrapperǤ*/
    private Wrapper[] nWraps;

    /** Queueκ祵Ǥ*/
    private int max;

    /** ߤɲѥݥ󥿤Ǥ*/
    private int head;

    /** ߤμѥݥ󥿤Ǥ*/
    private int tail;

    /** QueueդˤʤäȤtrueꤷޤ*/
    private boolean full;


    // constructors -----------------------------------------------------------
    /**
     * 祵ꤷWrapperQueueۤޤ
     *
     * @param	max
     *		WrapperQueueκǼǽ
     */
    Queue(int max)
    {
	nWraps		= new Wrapper[max];
	this.max	= max;
	head		= 0;
	tail		= 0;
	full		= false;
    }


    // status -----------------------------------------------------------------
    /**
     * QueueκϿǽޤ
     *
     * @return	Ͽǽ
     */
    int max()
    {
	return max;
    }

    /**
     * QueueϿƤWrapperο֤ޤ
     *
     * @return	ϿƤWrapperο
     */
    int size()
    {
	int ret;
	if (!full) {
	    ret = head - tail;

	    if (ret < 0) {
		ret += max;
	    }
	} else {
	    ret = max;
	}
	return ret;
    }

    /**
     * WrapperQueueɤ֤ޤ
     *
     * @return	ʤtrue
     */
    boolean isEmpty()
    {
	return (head == tail) && !full;
    }

    /**
     * WrapperQueueդɤ֤ޤ
     * 
     * @return	դʤtrue
     */
    boolean isFull()
    {
	return full;
    }


    // action -----------------------------------------------------------------
    /**
     * QueueWrapperɲäޤtrueϿǤʤfalse
     * ᤷޤޤnullϿ褦ȤNullPointerExceptionthrow
     * ޤ
     *
     * @param	wrp
     *		ǼWrapper
     * @return	ɲätrue
     * @throws	NullPointerException
     *		nullǼ褦Ȥ
     */
    boolean add(Wrapper wrp)
	throws NullPointerException
    {
	if (!full) {
	    if (wrp != null) {
		head		= ++head % max;
		nWraps[head]	= wrp;
		full		= (head == tail);
		return true;
	    } else {
		throw new NullPointerException("can't add null");
	    }
	} else {
	    return false;
	}
    }

    /**
     * QueueWrapperФޤ̵Ȥˤnullᤷޤ
     * 
     * @return	ǼƤWrapper
     */
    Wrapper remove()
    {
	if (head != tail || full) {
	    tail		= ++tail % max;
	    Wrapper wrp		= nWraps[tail];
	    nWraps[tail]	= null;
	    full		= false;
	    return wrp;
	} else {
	    return null;
	}
    }

    /**
     * maxǻꤵ줿ͤ˺祵ѹޤ⤷ѹη̰
     * 󥹥󥹤¸ߤ硢Collection˳Ǽᤵޤ
     * object̵϶Collection֤ޤ
     *
     * @param	max
     *		祵
     * @return	줿󥹥󥹤ǼCollection̵϶
     *		Collection
     * @throws	IllegalArgumentException
     *		max0ʲͤꤷ
     */
    Collection addjustMax(int max)
	throws IllegalArgumentException
    {
	if (max > 0) {
	    Wrapper[] oldArr = nWraps;

	    nWraps	= new Wrapper[max];
	    this.max	= max;
	    head	= 0;
	    tail	= 0;
	    full	= false;

	    ArrayList overs = new ArrayList();

	    for (int i = 0; i < oldArr.length; i++) {
		Wrapper wrp = oldArr[i];

		if (wrp != null) {
		    if (!full) {
			add(wrp);
		    } else {
			overs.add(wrp);
		    }
		}
	    }
	    return overs;
	} else {
	    throw new IllegalArgumentException("can't set under 0 value.");
	}
    }
}
