/*
 * $Id: Wrapper.java,v 1.1.1.1 2002/12/10 09:18:11 mitsuhito Exp $
 */


package jp.livewell.baby.pool;


/**
 * ס˳ǼƤ륤󥹥󥹤μϤ˻ѤinterfaceǤ
 *
 * @author mitsuhito
 */
public interface Wrapper
{
    // accessor ---------------------------------------------------------------
    /**
     * PoolѤkeyͿWrapperޤ1ٽ
     * 줿Wrapper2ٰʾνԤʤIllegalStateExceptionthrow
     * ޤ
     *
     * @param	ref
     *		Poolؤλ
     * @param	key
     *		Poolͭkey
     * @throws	IllegalStateException
     *		˽Ƥ
     */
    void init(PoolReference ref,
	      ComparisonKey key);

    /**
     * instanceѲǽǤtrueᤷޤŪˤdestroy
     * ӽФƤʤactivate줿instanceǡinitƤɬפ
     * ɤWrapperμˤäѤޤ
     *
     * @return	instanceѲǽǤtrue
     */
    boolean isWorkable();



    // action -----------------------------------------------------------------
    /**
     * WrapperͭȤPoolƤӽФޤtrue
     * ͭƤfalseᤵޤ񤹤Object
     * (ѤǤʤ)IllegalStateExceptionkeyפʤ
     * IllegalArgumentExceptionthrowޤΥ᥽åɤpingƤӽ
     * ޤ
     *
     * @param	key
     *		WrapperPoolͭComparisonKey
     * @return	trueͭƤfalse
     * @throws	IllegalStateException
     *		񤹤Object(ѤǤʤ)
     * @throws	IllegalArgumentException
     *		keyפʤ
     */
    boolean activate(ComparisonKey key)
	throws IllegalStateException, IllegalArgumentException;

    /**
     * Wrapper̵ȤPoolƤӽФޤtrue
     * ̵Ƥfalseᤵޤkeyפʤ
     * IllegalArgumentExceptionthrowޤ
     *
     * @param	key
     *		WrapperPoolͭComparisonKey
     * @return	true̵Ƥfalse
     * @throws	IllegalStateException
     *		Ǥʤͳ̵ʤ
     * @throws	IllegalArgumentException
     *		keyפʤ
     */
    boolean passivate(ComparisonKey key)
	throws IllegalStateException, IllegalArgumentException;

    /**
     * instancePoolᤷޤ
     */
    void release();

    /**
     * WrapperԲĤˤݤƤ꥽ľ˳
     * isWorkablefalseꤷޤ̾盧Υ᥽åɤPoolƤФޤ
     * destroyƤӽФ줿Wrapperưݾڤޤ
     * keyפʤIllegalArgumentExceptionthrowޤ
     *
     * @param	key
     *		WrapperPoolͭComparisonKey
     * @throws	IllegalArgumentException
     *		keyפʤ
     */
    void destroy(ComparisonKey key);
}
