/*
 * $Id: CallableStatementWrapper.java,v 1.1.1.1 2002/12/10 09:18:12 mitsuhito Exp $
 */


package jp.livewell.baby.pool.jdbc;


import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;


/**
 * java.sql.CallableStatement interfaceimplementsCallableStatement
 * ˻ѤǤWrapper classǤ
 *
 * @author mitsuhito
 */
class CallableStatementWrapper
    extends PreparedStatementWrapper
    implements CallableStatement
{
    // constructors ----------------------------------------------------------
    /**
     * CallableStatementWrapinstanceۤޤ
     *
     * @param	cstmt
     *		WrapJDBC CallableStatement instance
     * @param	connRef
     *		WrapperConnectionWrapperؤμ廲
     * @throws	IllegalArgumentException
     *		pstmtnullꤷ褦Ȥ硣
     *		connRefnullꤷ褦Ȥ硣
     *		connRefλȤJDBC ConnectionǤ̵硣
     */
    CallableStatementWrapper(CallableStatement cstmt,
			     WeakReference connRef)
	throws IllegalArgumentException
    {
	super(cstmt, connRef);
    }


    // accessor ---------------------------------------------------------------
    /**
     * raw JDBC CallableStatementᤷޤ
     *
     * @return	raw JDBC CallableStatement
     */
    protected CallableStatement callable()
    {
	return (CallableStatement) statement();
    }


    // CallableStatement implementation ---------------------------------------
    /**
     * Wrap줿JDBC CallableStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @param	index
     *		Wrap줿JDBC CallableStatementؤΰ
     * @return	Wrap줿JDBC CallableStatement줿
     * @throws	SQLException
     *		Wrap줿JDBC CallableStatementthrow
     */
    public Array getArray(int index) 
	throws SQLException 
    { 
	return callable().getArray(index);
    }

    /**
     * Wrap줿JDBC CallableStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @param	index
     *		Wrap줿JDBC CallableStatementؤΰ
     * @return	Wrap줿JDBC CallableStatement줿
     * @throws	SQLException
     *		Wrap줿JDBC CallableStatementthrow
     */
    public  BigDecimal getBigDecimal(int index) 
	throws SQLException 
    { 
	return callable().getBigDecimal(index);
    }

    /**
     * Wrap줿JDBC CallableStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @param	index
     *		Wrap줿JDBC CallableStatementؤΰ
     * @param	scale
     *		Wrap줿JDBC CallableStatementؤΰ
     * @return	Wrap줿JDBC CallableStatement줿
     * @throws	SQLException
     *		Wrap줿JDBC CallableStatementthrow
     */
    public BigDecimal getBigDecimal(int index, 
				    int scale)
	throws SQLException 
    { 
	return callable().getBigDecimal(index, scale);
    }

    /**
     * Wrap줿JDBC CallableStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @param	index
     *		Wrap줿JDBC CallableStatementؤΰ
     * @param	sqlType
     *		Wrap줿JDBC CallableStatementؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC CallableStatementthrow
     */
    public void registerOutParameter(int index,
				     int sqlType)
	throws SQLException 
    {
	callable().registerOutParameter(index, sqlType);
    }

    /**
     * Wrap줿JDBC CallableStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @param	index
     *		Wrap줿JDBC CallableStatementؤΰ
     * @param	sqlType
     *		Wrap줿JDBC CallableStatementؤΰ
     * @param	scale
     *		Wrap줿JDBC CallableStatementؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC CallableStatementthrow
     */
    public void registerOutParameter(int index,
				     int sqlType,
				     int scale)
	throws SQLException 
    {
	callable().registerOutParameter(index, sqlType, scale);
    }

    /**
     * Wrap줿JDBC CallableStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @return	Wrap줿JDBC CallableStatement줿
     * @throws	SQLException
     *		Wrap줿JDBC CallableStatementthrow
     */
    public boolean wasNull()
	throws SQLException 
    {
	return callable().wasNull();
    }

    /**
     * Wrap줿JDBC CallableStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @param	index
     *		Wrap줿JDBC CallableStatementؤΰ
     * @return	Wrap줿JDBC CallableStatement줿
     * @throws	SQLException
     *		Wrap줿JDBC CallableStatementthrow
     */
    public String getString(int index)
	throws SQLException 
    {
	return callable().getString(index);
    }

    /**
     * Wrap줿JDBC CallableStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @param	index
     *		Wrap줿JDBC CallableStatementؤΰ
     * @return	Wrap줿JDBC CallableStatement줿
     * @throws	SQLException
     *		Wrap줿JDBC CallableStatementthrow
     */
    public boolean getBoolean(int index)
	throws SQLException 
    { 
	return callable().getBoolean(index);
    }

    /**
     * Wrap줿JDBC CallableStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @param	index
     *		Wrap줿JDBC CallableStatementؤΰ
     * @return	Wrap줿JDBC CallableStatement줿
     * @throws	SQLException
     *		Wrap줿JDBC CallableStatementthrow
     */
    public byte getByte(int index)
	throws SQLException 
    {
	return callable().getByte(index);
    }

    /**
     * Wrap줿JDBC CallableStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @param	index
     *		Wrap줿JDBC CallableStatementؤΰ
     * @return	Wrap줿JDBC CallableStatement줿
     * @throws	SQLException
     *		Wrap줿JDBC CallableStatementthrow
     */
    public short getShort(int index)
	throws SQLException
    {
	return callable().getShort(index);
    }

    /**
     * Wrap줿JDBC CallableStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @param	index
     *		Wrap줿JDBC CallableStatementؤΰ
     * @return	Wrap줿JDBC CallableStatement줿
     * @throws	SQLException
     *		Wrap줿JDBC CallableStatementthrow
     */
    public int getInt(int index)
	throws SQLException
    {
	return callable().getInt(index);
    }

    /**
     * Wrap줿JDBC CallableStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @param	index
     *		Wrap줿JDBC CallableStatementؤΰ
     * @return	Wrap줿JDBC CallableStatement줿
     * @throws	SQLException
     *		Wrap줿JDBC CallableStatementthrow
     */
    public long getLong(int index)
	throws SQLException
    {
	return callable().getLong(index);
    }

    /**
     * Wrap줿JDBC CallableStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @param	index
     *		Wrap줿JDBC CallableStatementؤΰ
     * @return	Wrap줿JDBC CallableStatement줿
     * @throws	SQLException
     *		Wrap줿JDBC CallableStatementthrow
     */
    public float getFloat(int index)
	throws SQLException
    {
	return callable().getFloat(index);
    }

    /**
     * Wrap줿JDBC CallableStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @param	index
     *		Wrap줿JDBC CallableStatementؤΰ
     * @return	Wrap줿JDBC CallableStatement줿
     * @throws	SQLException
     *		Wrap줿JDBC CallableStatementthrow
     */
    public double getDouble(int index)
	throws SQLException 
    {
	return callable().getDouble(index);
    }

    /**
     * Wrap줿JDBC CallableStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @param	index
     *		Wrap줿JDBC CallableStatementؤΰ
     * @return	Wrap줿JDBC CallableStatement줿
     * @throws	SQLException
     *		Wrap줿JDBC CallableStatementthrow
     */
    public byte[] getBytes(int index)
	throws SQLException 
    {
	return callable().getBytes(index);
    }

    /**
     * Wrap줿JDBC CallableStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @param	index
     *		Wrap줿JDBC CallableStatementؤΰ
     * @return	Wrap줿JDBC CallableStatement줿
     * @throws	SQLException
     *		Wrap줿JDBC CallableStatementthrow
     */
    public Date getDate(int index)
	throws SQLException
    {
	return callable().getDate(index);
    }

    /**
     * Wrap줿JDBC CallableStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @param	index
     *		Wrap줿JDBC CallableStatementؤΰ
     * @return	Wrap줿JDBC CallableStatement줿
     * @throws	SQLException
     *		Wrap줿JDBC CallableStatementthrow
     */
    public Time getTime(int index)
	throws SQLException 
    {
	return callable().getTime(index);
    }

    /**
     * Wrap줿JDBC CallableStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @param	index
     *		Wrap줿JDBC CallableStatementؤΰ
     * @return	Wrap줿JDBC CallableStatement줿
     * @throws	SQLException
     *		Wrap줿JDBC CallableStatementthrow
     */
    public Timestamp getTimestamp(int index)
	throws SQLException
    {
	return callable()
	    .getTimestamp(index);
    }

    /**
     * Wrap줿JDBC CallableStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @param	index
     *		Wrap줿JDBC CallableStatementؤΰ
     * @return	Wrap줿JDBC CallableStatement줿
     * @throws	SQLException
     *		Wrap줿JDBC CallableStatementthrow
     */
    public Object getObject(int index)
	throws SQLException
    {
	return callable().getObject(index);
    }

    /**
     * Wrap줿JDBC CallableStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @param	index
     *		Wrap줿JDBC CallableStatementؤΰ
     * @param	map
     *		Wrap줿JDBC CallableStatementؤΰ
     * @return	Wrap줿JDBC CallableStatement줿
     * @throws	SQLException
     *		Wrap줿JDBC CallableStatementthrow
     */
    public Object getObject(int index,
			    Map map)
	throws SQLException
    {
	return callable().getObject(index, map);
    }

    /**
     * Wrap줿JDBC CallableStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @param	index
     *		Wrap줿JDBC CallableStatementؤΰ
     * @return	Wrap줿JDBC CallableStatement줿
     * @throws	SQLException
     *		Wrap줿JDBC CallableStatementthrow
     */
    public Ref getRef(int index)
	throws SQLException
    {
	return callable().getRef(index);
    }

    /**
     * Wrap줿JDBC CallableStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @param	index
     *		Wrap줿JDBC CallableStatementؤΰ
     * @return	Wrap줿JDBC CallableStatement줿
     * @throws	SQLException
     *		Wrap줿JDBC CallableStatementthrow
     */
    public Blob getBlob(int index)
	throws SQLException
    {
	return callable().getBlob(index);
    }

    /**
     * Wrap줿JDBC CallableStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @param	index
     *		Wrap줿JDBC CallableStatementؤΰ
     * @return	Wrap줿JDBC CallableStatement줿
     * @throws	SQLException
     *		Wrap줿JDBC CallableStatementthrow
     */
    public Clob getClob(int index)
	throws SQLException
    {
	return callable().getClob(index);
    }

    /**
     * Wrap줿JDBC CallableStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @param	index
     *		Wrap줿JDBC CallableStatementؤΰ
     * @param	cal
     *		Wrap줿JDBC CallableStatementؤΰ
     * @return	Wrap줿JDBC CallableStatement줿
     * @throws	SQLException
     *		Wrap줿JDBC CallableStatementthrow
     */
    public Date getDate(int index,
			Calendar cal)
	throws SQLException
    {
	return callable().getDate(index, cal);
    }

    /**
     * Wrap줿JDBC CallableStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @param	index
     *		Wrap줿JDBC CallableStatementؤΰ
     * @param	cal
     *		Wrap줿JDBC CallableStatementؤΰ
     * @return	Wrap줿JDBC CallableStatement줿
     * @throws	SQLException
     *		Wrap줿JDBC CallableStatementthrow
     */
    public Time getTime(int index,
			Calendar cal)
	throws SQLException
    {
	return callable().getTime(index, cal);
    }

    /**
     * Wrap줿JDBC CallableStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @param	index
     *		Wrap줿JDBC CallableStatementؤΰ
     * @param	cal
     *		Wrap줿JDBC CallableStatementؤΰ
     * @return	Wrap줿JDBC CallableStatement줿
     * @throws	SQLException
     *		Wrap줿JDBC CallableStatementthrow
     */
    public Timestamp getTimestamp(int index,
				  Calendar cal)
	throws SQLException 
    {
	return callable().getTimestamp(index, cal);
    }

    /**
     * Wrap줿JDBC CallableStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @param	index
     *		Wrap줿JDBC CallableStatementؤΰ
     * @param	sqlType
     *		Wrap줿JDBC CallableStatementؤΰ
     * @param	typeName
     *		Wrap줿JDBC CallableStatementؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC CallableStatementthrow
     */
    public void registerOutParameter(int index,
				     int sqlType,
				     String typeName)
	throws SQLException
    {
	callable().registerOutParameter(index, sqlType, typeName);
    }
}
