/*
 * $Id: ConnectionFactory.java,v 1.1.1.1 2002/12/10 09:18:12 mitsuhito Exp $
 */


package jp.livewell.baby.pool.jdbc;


import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Properties;

import jp.livewell.baby.io.NullWriter;
import jp.livewell.baby.pool.Factory;
import jp.livewell.baby.pool.Wrapper;


/**
 * JDBC Connection뤿classǤ󥹥ȥ饯init³
 * ϤƤޤ³ѹǤޤ
 * ConnectionPoolѤޤ
 *
 * @author mitsuhito
 */
public class ConnectionFactory
    implements Factory
{
    // attributes -------------------------------------------------------------
    /** JDBC Driver */
    private Driver driver;

    /** ǡ١³URL */
    private String url;

    /** ǡ١³ץѥƥ */
    private Properties prop;

    /** ConnectionWrapperping command(SQL) */
    private String command;

    /** ConnectionWrapperping interval(ms) */
    private long interval;

    /** ĤƤJDBC Connection */
    private Connection closedConn = null;

    /** FactoryJDBC DriverConnectionν */
    private ConnectionWrapper.DefaultValues defaults = null;

    /**  */
    private boolean isInit = false;

    /** ν */
    private PrintWriter logger = new PrintWriter(System.err, true);


    // constructors & init ----------------------------------------------------
    /**
     * ǡ١³̵ConnectionPoolۤޤ
     */
    protected ConnectionFactory()
    {
	driver		= null;
	url		= "";
	prop		= new Properties();
	command		= "";
	interval	= 0;
    }
    
    /**
     * ǡ١³ꤷConnectionPoolۤޤϤ줿
     * ³ǥǡ١ؤ³ʤä硢SQLException
     * throwޤ
     *
     * @param	info
     *		ǡ١³
     * @throws	SQLException
     *		Ϥ줿³ǥǡ١ؤ³Ԥ
     */
    public ConnectionFactory(ConnectionPoolInfo info)
	throws SQLException
    {
	init(info);
    }
    
    /**
     * ConnectionFactoryޤ
     *
     * @param	info
     *		ǡ١³
     * @throws	SQLException
     *		Ϥ줿³ǥǡ١ؤ³Ԥ
     * @throws	IllegalStateException
     *		˽ƤΤˤΥ᥽åɤƤӽФ
     */
    protected void init(ConnectionPoolInfo info)
	throws SQLException, IllegalStateException
    {
	if (!isInit) {
	    if (connectTest(info)) {
		try {
		    driver	= loadDriver(info.getDriverName());
		    url		= info.getUrl();
		    prop	= info.toProperties();
		    command	= info.getPingCommand();
		    interval	= info.getPingInterval();
		    isInit	= true;

		    /* already all param is OK. prepare Factory work! */
		    Connection conn = getConnection();
		    defaults = new ConnectionWrapper.DefaultValues(conn);
		    conn.close();
		    closedConn = conn;

		} catch (Exception e) {
		    logger.println("[ConnectionFactory: error] test is done."
				   + " but catch exception. why??? "
				   + "stack trace...");
		    e.printStackTrace(logger);
		    throw new SQLException
			("factory initializing failed!\n"
			 + " error is " + e + "\n"
			 + " dump ConnectionPoolInfo.\n" + info + ".\n");
		}
	    } else {
		// case test failed or can't get driver.
		throw new SQLException
		    ("factory initializing failed!\n"
		     + " dump ConnectionPoolInfo.\n" + info);
	    }
	} else { 
	    logger.println("[ConnectionFactory: error] already initialized!");
	    throw new IllegalStateException
		("already initialized. can't call init already init.");
	}
    }
    

    // accessor ---------------------------------------------------------------
    /**
     * νޤsetLogWriterǻꤵƤʤˤϡ
     * ɸ२顼ϤؽϤPrintWriter֤ޤ
     *
     * @return	νˤʤPrintWriter
     */
    public PrintWriter getLogWriter()
    {
	return logger;
    }

    /**
     * νꤷޤϤԤʤnullꤷƲ
     * nullꤵ줿硢ɤˤϤԤʤPrintWriteråȤ
     * ޤ
     *
     * @param	logger
     *		νˤʤPrintWriter
     */
    public void setLogWriter(PrintWriter logger)
    {
	if (logger != null) {
	    this.logger = logger;
	} else {
	    this.logger = new PrintWriter(new NullWriter(), true);
	}
    }

    /**
     * instanceƤ뤫ޤ
     *
     * @return	Ƥtrue
     */
    public boolean isInit()
    {
	return isInit;
    }

    /**
     * ΥեȥJDBC Driverޤ
     *
     * @return	ΥեȥJDBC Driver
     * @throws	IllegalStateException
     *		Ƥʤ֤ǸƤӽФ줿
     */
    Driver getDriver()
	throws IllegalStateException
    {
	if (isInit) {
	    return driver;
	} else {
	    throw new IllegalStateException("this pool is not initialized!");
	}
    }

    /**
     * ΥեȥΥǡ١URLޤ
     *
     * @return	ΥեȥΥǡ١URL
     * @throws	IllegalStateException
     *		Ƥʤ֤ǸƤӽФ줿
     */
    String getUrl()
	throws IllegalStateException
    {
	if (isInit) {
	    return url;
	} else {
	    throw new IllegalStateException("this pool is not initialized!");
	}
    }
    
    /**
     * ΥեȥΥǡ١³ץѥƥޤ
     *
     * @return	ΥեȥΥǡ١³ץѥƥ
     * @throws	IllegalStateException
     *		Ƥʤ֤ǸƤӽФ줿
     */
    Properties getInfo()
	throws IllegalStateException
    {
	if (isInit) {
	    return (Properties) prop.clone();
	} else {
	    throw new IllegalStateException("this pool is not initialized!");
	}
    }

    /**
     * ꤵ줿³󤬤Υեȥλ³ƱǤ뤫ɤ
     * ֤ޤƱtrueʳfalse
     *
     * @param	url
     *		ǡ١URL
     * @param	info
     *		ǡ١³ץѥƥ
     * @return	Ʊ³ľtrue
     * @throws	IllegalStateException
     *		Ƥʤ֤ǸƤӽФ줿
     */
    boolean hasSameData(String url,
			Properties info)
	throws IllegalStateException
    {
	if (isInit) {
	    return (this.url.equals(url) && this.prop.equals(info));
	} else {
	    throw new IllegalStateException("this pool is not initialized!");
	}
    }


    // Factory implementation -------------------------------------------------
    /**
     * Wrapper(FactoryǤConnectionWrapper)ᤷޤ
     *
     * @return	ConnectionWrapperWrapper interfaceᤷޤ
     * @throws	Exception
     *		ǡ١³Ǥʤä
     *		Ƥʤ֤ǸƤӽФ줿
     */
    public Wrapper create()
	throws Exception
    {
	Connection conn = getConnection();
	return new ConnectionWrapper
	    (conn, closedConn, command, interval, defaults);
    }


    // action -----------------------------------------------------------------
    /**
     * ConnectionFactory˥ǡ١³ƥȤԤޤ
     *
     * @param	info
     *		ǡ١³
     * @return	ǡ١ؤ³pingCommandȯԤtrue,
     *		Ԥfalse
     */
    public boolean connectTest(ConnectionPoolInfo info)
    {
	boolean isSuccess;
	try {
	    Driver drv = loadDriver(info.getDriverName());

	    Connection conn = null;
	    try {
		conn = drv.connect(info.getUrl(), info.toProperties());

		Statement stmt = conn.createStatement();
		// stmt.setFetchSize(1); // postgres can't understand this.
		stmt.executeQuery(info.getPingCommand());

		isSuccess = true;
	    } finally {
		if (conn != null) {
		    conn.close();
		}
	    }
	} catch (Exception e) {
	    logger.println
		("[ConnectionFactory: error] "
		 + "connect test failed! stack trace...");
	    e.printStackTrace(logger);
	    logger.println("ConnectionPoolInfo dump here");
	    logger.println(info);
	    isSuccess = false;
	}
	return isSuccess;
    }

    /**
     * JDBC Connectionޤ
     *
     * @return	JDBC Connection
     * @throws	SQLException
     *		ǡ١³Ǥʤä
     * @throws	IllegalStateException
     *		Ƥʤ֤ǸƤӽФ줿Ȥ
     */
    public Connection getConnection()
	throws SQLException, IllegalStateException
    {
	Connection conn = null;
	if (isInit) {
	    conn = driver.connect(url, prop);

	    if (conn != null) {
		return conn;
	    } else {
		throw new SQLException("get JDBC Connection failed!");
	    }
	} else {
	    throw new IllegalStateException("this pool is not initialized!");
	}
    }

    /**
     * JDBC Driverinstanceޤ
     * @param	driverName
     *		JDBC Driverδ̾
     * @return	JDBC DriverΥ󥹥
     * @throws	ClassNotFoundException
     *		ꤵ줿³JDBC Dirverclass pathǸĤ
     *		
     * @throws	RuntimeException
     *		DriverManagerdriverNameǻꤵ줿Driver򸫤Ĥ뤳Ȥ
     *		ʤä
     */
    protected Driver loadDriver(String driverName)
	throws ClassNotFoundException, RuntimeException
    {
	Driver drv = null;
	{
	    /* check other Pool's Driver */
	    ResourceManager manager = ResourceManager.getInstance();
	    drv = manager.findDriverByName(driverName);
	}

	if (drv == null) {
	    Class.forName(driverName); // load JDBC Driver

	    for (Enumeration enum = DriverManager.getDrivers();
		 enum.hasMoreElements();) {
		Driver d = (Driver) enum.nextElement();
		
		if (d.getClass().getName().equals(driverName)) {
		    drv = d;
		    logger.println
			("[ConnectionFactory: status] load JDBC Driver '"
			 + driverName + "' success.");
		    break;
		}
	    }
	}

	if (drv == null) {
	    /* newInstance¹ԤʤϿʤΤ⤢餷 */
	    try {
		drv = (Driver) Class.forName(driverName).newInstance();
	    } catch (Exception e) {
		/* ʤ㳰ŪʾǤ*/
		logger.println
		    ("[ConnectionFactory: error] load JDBC Driver '" 
		     + driverName + "' failed!!");
		throw new RuntimeException
		    ("cannot load jdbc driver for babyPool.\n"
		     + "driver name = " + driverName + "\n");
	    }
	}
	return drv;
    }
}
