/*
 * $Id: ConnectionPool.java,v 1.1.1.1 2002/12/10 09:18:12 mitsuhito Exp $
 */

package jp.livewell.baby.pool.jdbc;


import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;

import jp.livewell.baby.pool.DefaultPool;
import jp.livewell.baby.pool.TimeoutException;


/**
 * JDBC Connection(Wrapper)ס뤹classǤ
 *
 * @author mitsuhito
 */
public class ConnectionPool
    extends DefaultPool
    implements DataSource, Referenceable
{
    // URL & info's match levels ----------------------------------------------
    /** ΥסǤ³ΤΤʤͤ0Ǥ */
    public static final int CONNECT_IMPOSSIBLE = 0;

    /** Υס뤫³Ͻ뤬ס󥰤оݤˤʤäƤʤͤ
	1Ǥ */
    public static final int CONNECT_ACCEPT = 1;

    /** Υסǥס󥰤Ƥͤ2Ǥ*/
    public static final int CONNECT_POOLING = 2;


    // empty dummy objects ----------------------------------------------------
    /** ³ΥߡȤƻѤޤ*/
    private static final Properties EMPTY_PROPERTIES = new Properties();


    // non block takeout param ------------------------------------------------
    /** ֥å˼Ԥʤ(Ǥʤnull) */
    private static final int NON_BLOCK = -1;


    // constructors & init ----------------------------------------------------
    /**
     * ConnectionPoolס빽ۤ(PoolInfo)ConnectionFactory
     * 鹽ۤޤ
     * 
     * @param	info
     *		ס빽ۤ
     * @throws	SQLException
     *		ConnectionPoolInfo³ǥǡ١³˼Ԥ
     */
    public ConnectionPool(ConnectionPoolInfo info)
	throws SQLException
    {
	super(info, new ConnectionFactory(info));
    }

    
    // accessor ---------------------------------------------------------------
    /**
     * Υס뤬ꤵ줿urlinfoJDBC Connectionס뤷ƤΤ
     * ɤޤ³ϲǽɤint֤ͤޤ֤ͤϤ
     * class CONNECT_XXXǻꤵͤΤ줫Ǥ
     *
     * @param	url
     *		åǡ١URL
     * @return	³ǽɤס뤵Ƥ뤫ɤint
     * @throws	SQLException
     *		ǡ١顼ȯ
     */
    int checkAvailable(String url)
	throws SQLException
    {
	return checkAvailable(url, EMPTY_PROPERTIES);
    }

    /**
     * Υס뤬ꤵ줿urlinfoJDBC Connectionס뤷ƤΤ
     * ɤޤ³ϲǽɤint֤ͤޤ֤ͤϤ
     * class CONNECT_XXXǻꤵͤΤ줫Ǥ
     *
     * @param	url
     *		åǡ١URL
     * @param	info
     *		åǡ١³ץѥƥ
     * @return	³ǽɤס뤵Ƥ뤫ɤint
     * @throws	SQLException
     *		ǡ١顼ȯ
     */
    int checkAvailable(String url,
		       Properties info)
	throws SQLException
    {
	int available = CONNECT_IMPOSSIBLE;
	ConnectionFactory fac = (ConnectionFactory) getFactory();

	if (fac.hasSameData(url, info)) {
	    available = CONNECT_POOLING;
	} else if (fac.getUrl().equals(url)) {
	    available = CONNECT_ACCEPT;
	} else if (fac.getDriver().acceptsURL(url)) {
	    available = CONNECT_ACCEPT;
	}
	return available;
    }

    /**
     * ꤵ줿url³򤷡JDBC Connectionޤurlprop
     * ConnectionFactoryλ³ƱϤΥ󥹥󥹤³
     * ޤ
     *
     * @param	url
     *		ǡ١url
     * @param	prop
     *		ǡ١³ץѥƥ
     * @return	ꤵ줿urlJDBC Connection
     * @throws	SQLException
     *		ס뤬ॢȤ硣
     *		ǡ١³ʤä硣
     *		ConnectionFactoryƤʤ硣
     */
    public Connection getConnection(String url,
				    Properties prop)
	throws SQLException
    {
	Connection conn;
	{
	    ConnectionFactory fac = (ConnectionFactory) getFactory();
	    if (fac.hasSameData(url, prop)) {
		/* ­: Υɤ¹ԤThreadϤ餯DriverManager
		   synchronizedƤϤʤΤ¾Threadtakeout
		   ǿConnection褦ȤȡJDBC Driver 
		   DriverManagerprintlnʤ¾synchronized methodƤ
		   Ф˥ǥåɥåޤΤ
		   ޤNON_BLOCKtakeoutƤӽФʾ
		   ʤ˻Ϥư̵takeoutƤӽФޤ */

		while ((conn = (Connection) takeout(NON_BLOCK)) == null) {
		    if (!grow()) {
			try {
			    conn = (Connection) takeout();
			    break;
			} catch (TimeoutException e) {
			    throw new SQLException(e.toString());
			}
		    }
		}
	    } else {
		try {
		    conn = fac.getDriver().connect(url, prop);
		} catch (IllegalStateException e) {
		    throw new SQLException(e.toString());
		}
	    }
	}
	return conn;
    }


    // DataSource implements --------------------------------------------------
    /**
     * DataSource#getConnectionޤPoolƤConnectionWrapper
     * ޤPooltimeoutSQLExceptionthrowޤ
     *
     * @return	ס뤵ƤConnectionWrapper
     * @throws	SQLException
     *		ס뤬timeout
     */
    public final Connection getConnection()
	throws SQLException
    {
	try {
	    return (Connection) takeout();
	} catch (TimeoutException e) {
	    throw new SQLException("pool timeout.");
	}
    }

    /**
     * DataSource#getConnectionޤꤵ줿userpassword³
     * ߤޤꤵ줿ͤΤɤ⤬ConnectionFactory˻ꤷͤ
     * ƱξConnectionPool³ޤ㤦ˤϡ
     * JDBC Driver³褦Ȼߤޤ
     * 
     * @param	user
     *		ǡ١Υ桼̾
     * @param	password
     *		桼Υѥ
     * @return	JDBC Connection
     * @throws	SQLException
     *		ס뤫ФȤƤϥס뤬ॢȤ
     *		ʳϥǡ١顼ȯ
     */
    public Connection getConnection(String user,
				    String password)
	throws SQLException
    {
	ConnectionFactory fac = (ConnectionFactory) getFactory();
	Properties info = fac.getInfo();
	info.setProperty(ConnectionPoolInfo.KEY_USER, user);
	info.setProperty(ConnectionPoolInfo.KEY_PASSWORD, password);

	return getConnection(fac.getUrl(), info);
    }

    /**
     * DataSource#getLoginTimeoutޤPoolΥॢȤ
     * 
     *
     * @return	PoolΥॢ
     * @throws	SQLException
     *		ºݤˤthrowޤ
     */
    public int getLoginTimeout()
	throws SQLException
    {
	return getTimeout();
    }

    /**
     * DataSource#setLoginTimeoutޤPoolΥॢȤꤷ
     * 
     *
     * @param	timeout
     *		PoolΥॢ
     * @throws	SQLException
     *		(PoolInfoʤ)ꤷ褦Ȥ
     */
    public void setLoginTimeout(int timeout)
	throws SQLException
    {
	try {
	    setTimeout(timeout);
	} catch (IllegalArgumentException e) {
	    throw new SQLException(e.toString());
	}
    }

    /**
     * DataSource#getLogWriterޤConnectionPoolConnectionFactory
     * PrintWriterޤ
     *
     * @return	ConnectionFactoryPrintWriter
     * @throws	SQLException
     *		ºݤˤthrowޤ
     */
    public PrintWriter getLogWriter()
	throws SQLException
    {
	return ((ConnectionFactory) getFactory()).getLogWriter();
    }

    /**
     * DataSource#setLogWriterޤConnectionFactorylogWriter
     * ꤵ줿LogWriterꤷޤ
     *
     * @param	pw
     *		LogWriter
     * @throws	SQLException
     *		ºݤˤthrowޤ
     */
    public void setLogWriter(PrintWriter pw)
	throws SQLException
    {
	((ConnectionFactory) getFactory()).setLogWriter(pw);
    }


    // Referenceable implements -----------------------------------------------
    /**
     * Υ󥹥󥹤JNDI黲Ȥ뤿Reference instrance
     * ޤбObjectFactory
     * jp.livewell.baby.pool.jdbc.DataSourceFactoryǤ
     *
     * @return	Υ󥹥󥹤JNDI黲Ȥ뤿Reference instrance
     */
    public Reference getReference()
    {
	StringRefAddr refAddr 
	    = new StringRefAddr(DataSource.class.getName(), getName());
	return new Reference(getClass().getName(),
			     refAddr,
			     DataSourceFactory.class.getName(),
			     null);
    }
}
