/*
 * $Id: ConnectionPoolInfo.java,v 1.1.1.1 2002/12/10 09:18:12 mitsuhito Exp $
 */

package jp.livewell.baby.pool.jdbc;


import java.util.Enumeration;
import java.util.Properties;
import jp.livewell.baby.pool.PoolInfo;


/**
 * JDBC ConnectionPoolۤǼclassǤ
 *
 * @author mitsuhito
 */
public class ConnectionPoolInfo
    extends PoolInfo
{
    // parameter names --------------------------------------------------------
    /** JDBC DriverǻѤdatabase userΥץѥƥ̾ */
    public static final String KEY_USER = "user";
    
    /** JDBC DriverǻѤdatabase user's passwordΥץѥƥ̾ */
    public static final String KEY_PASSWORD = "password";
    

    // attributes -------------------------------------------------------------
    /** JDBC Driverclass nameǼޤ*/
    private String driver;

    /** databaseURLǼޤ*/
    private String url;
    
    /** JDBC DriverϤ³Ǽޤ*/
    private final Properties connInfo = new Properties();

    /** ǡ١ؤ³ǧ˻ѤSQLʸ */
    private String command;

    /** ǡ١ؤ³ǧǽλֳִ(ms) */
    private long interval;


    // constructors & init ----------------------------------------------------
    /**
     * ConnectionPoolInfoۤޤ
     */
    public ConnectionPoolInfo()
    {
	super();
	init();
    }

    /**
     * ꤵ줿ConnectionPoolInfoƱͤConnectionPoolInfo
     * ޤ
     * 
     * @param	master
     *		ԡConnectionPoolInfo
     */
    protected ConnectionPoolInfo(ConnectionPoolInfo master)
    {
	super(master);
	driver		= master.getDriverName();
	url		= master.getUrl();
	command		= master.getPingCommand();
	interval	= master.getPingInterval();
	connInfo.putAll(master.toProperties());
    }

    /**
     * instanceޤ
     */
    private void init()
    {
	driver		= "";
	url		= "";
	command		= "select 1";
	interval	= 1000;
	connInfo.setProperty(KEY_USER, "");
	connInfo.setProperty(KEY_PASSWORD, "");
    }


    // Cloneable implementation -----------------------------------------------
    /**
     * objectʣޤdeep copyϺޤ
     * 
     * @return	objectʣ
     */
    public Object clone()
    {
	return new ConnectionPoolInfo(this);
    }


    // over rides -------------------------------------------------------------
    /**
     * ꤵ줿objectobjectӤޤ
     *
     * @param	o
     *		оݤobject
     * @return	ƤͤƱConnectionPoolInfoξˤtrueʳfalse
     */
    public boolean equals(Object o)
    {
	boolean isSame = false;

	if (super.equals(o)) {
	    if (o instanceof ConnectionPoolInfo) {
		ConnectionPoolInfo other = (ConnectionPoolInfo) o;
	    
		isSame = driver.equals(other.getDriverName())
		    && url.equals(other.getUrl())
		    && connInfo.equals(other.toProperties())
		    && command.equals(other.getPingCommand())
		    && interval == other.getPingInterval();
	    }
	}
	return isSame;
    }

    /**
     * Υ󥹥󥹤ʸɽޤ
     *
     * @return	Υ󥹥󥹤ʸɽ
     */
    public String toString()
    {
	StringBuffer buf = new StringBuffer(super.toString())
	    .append("driverName = ").append(driver).append("\n")
	    .append("url = ").append(url).append("\n");

	for (Enumeration names = connInfo.propertyNames();
	     names.hasMoreElements();) {

	    String name = (String) names.nextElement();
	    buf.append(name).append(" = ")
		.append(connInfo.getProperty(name)).append("\n");
	}
	
	buf.append("pingCommand = " + command).append("\n")
	    .append("pingInterval = " + interval).append("\n")
	    .append("\n");
	return buf.toString();
    }


    // accessor ---------------------------------------------------------------
    /**
     * JDBC Driver̾ޤ
     *
     * @return	JDBC Driverclass nameꤵƤʤ϶ʸ
     */
    public String getDriverName()
    {
	return driver;
    }

    /**
     * JDBC Driver̾ꤷޤ
     *
     * @param	className
     *		JDBC Driverclass name
     * @throws	IllegalArgumentException
     *		ꤵ줿classNameDriverɽʤȤ
     */
    public void setDriverName(String className)
	throws IllegalArgumentException
    {
	try {
	    Class cls = Class.forName(className);
	    driver = className;
	} catch (Exception e) {
	    throw new IllegalArgumentException(e.toString());
	}
    }

    /**
     * database URLޤ
     *
     * @return	databaseURLꤵƤʤ϶ʸ
     */
    public String getUrl()
    {
	return url;
    }

    /**
     * database URLꤷޤnullꤹNullPointerExceptionthrow
     * ޤ
     *
     * @param	url
     *		databaseURL
     * @throws	NullPointerException
     *		nullꤷ褦Ȥ
     */
    public void setUrl(String url)
	throws NullPointerException
    {
	if (url != null) {
	    this.url = url;
	} else {
	    throw new NullPointerException
		("can't set null database URL!!");
	}
    }

    /**
     * database userޤ
     * 
     * @return	database user̾ꤵƤʤ϶ʸ
     */
    public String getUser()
    {
	return connInfo.getProperty(KEY_USER);
    }

    /**
     * database userꤷޤnullꤹNullPointerException
     * throwޤ
     * 
     * @param	userName
     *		database user̾
     * @throws	NullPointerException
     *		nullꤷ褦Ȥ
     */
    public void setUser(String userName)
	throws NullPointerException
    {
	if (userName != null) {
	    connInfo.setProperty(KEY_USER, userName);
	} else {
	    throw new NullPointerException
		("can't set null database user name!!");
	}
    }

    /**
     * database user's passwordޤ
     *
     * @return	database user's passwordꤵƤʤ϶ʸ
     */
    public String getPassword()
    {
	return connInfo.getProperty(KEY_PASSWORD);
    }

    /**
     * database user's passwordꤷޤnullꤹ
     * NullPointerExceptionthrowޤ
     *
     * @param	password
     *		database user's password
     * @throws	NullPointerException
     *		nullꤷ褦Ȥ
     */
    public void setPassword(String password)
	throws NullPointerException
    {
	if (password != null) {
	    connInfo.setProperty(KEY_PASSWORD, password);
	} else {
	    throw new NullPointerException
		("can't set null database user's password.");
	}
    }

    /**
     * JDBC Driverͭγĥ°ޤ
     *
     * @param	key
     *		ĥ°̾
     * @return	ꤵƤĥ°̾
     * @throws	NullPointerException
     *		nullkeyꤷ硣
     */
    public String getExtention(String key)
	throws NullPointerException
    {
	if (key != null) {
	    return connInfo.getProperty(key);
	} else {
	    throw new NullPointerException("can't use null key.");
	}
    }

    /**
     * JDBC Driverͭγĥ°ꤷޤ
     * keyڤvaluenullǤޤ󡣻ꤷNullPointerException
     * throwޤ
     *
     * @param	key
     *		ĥ°̾
     * @param	val
     *		ĥ°
     * @throws	NullPointerException
     *		keyvalnullꤷ
     */
    public void setExtention(String key,
			     String val)
	throws NullPointerException
    {
	if (key != null && val != null) {
	    connInfo.setProperty(key, val);
	} else {
	    throw new NullPointerException("key or val is null.");
	}
    }

    /**
     * ǡ١ؤ³ǧ˻ѤSQLʸޤ
     * 
     * @return	ǡ١ؤ³ǧ˻ѤSQLʸɸ[ select 1; ]
     */
    public String getPingCommand()
    {
	return command;
    }

    /**
     * ǡ١ؤ³ǧ˻ѤSQLʸꤷޤ
     * nullꤹNullPointerExceptionthrowޤ
     * 
     * @param	command
     *		ǡ١ؤ³ǧ˻ѤSQLʸ
     * @throws	NullPointerException
     *		nullꤷ褦Ȥ
     */
    public void setPingCommand(String command)
	throws NullPointerException
    {
	if (command != null) {
	    this.command = command;
	} else {
	    throw new NullPointerException
		("can't set null ping command!!");
	}
    }

    /**
     * ǡ١ؤ³ǧǽλֳִ(ms)
     * ޤ
     * 
     * @return	ǡ١ؤ³ǧǽλֳִ(ms)
     */
    public long getPingInterval()
    {
	return interval;
    }

    /**
     * ǡ١ؤ³ǧǽλֳִ(ms)ꤷ
     * ޤͤꤹIllegalArgumentExceptionthrowޤ
     * 
     * @param	interval
     *		ǡ١ؤ³ǧ˻ѤSQLʸ
     * @throws	IllegalArgumentException
     *		ͤꤷ褦Ȥ
     */
    public void setPingInterval(long interval)
	throws IllegalArgumentException
    {
	if (interval >= 0) {
	    this.interval = interval;
	} else {
	    throw new IllegalArgumentException
		("can't set minous value to pingInterval!!");
	}
    }

    /**
     * JDBC DriverϤProperties֤ޤ
     * ֤줿PropertiesϥԡʤΤԤäƤꤢޤ
     *
     * @return	JDBC DriverϤ³
     */
    public Properties toProperties()
    {
	return  (Properties) connInfo.clone();
    }
}
