/*
 * $Id: ConnectionPoolInfoLoader.java,v 1.1.1.1 2002/12/10 09:18:12 mitsuhito Exp $
 */

package jp.livewell.baby.pool.jdbc;


import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;


/**
 * ConnectionPoolInfo򲿤餫Υ꥽classݴclassǤ
 *
 * @author mistuhito
 */
abstract class ConnectionPoolInfoLoader
{
    // default values ---------------------------------------------------------
    /** ǡ꥽ξ */
    private static final String RESOURCE_PATH
	= "jp.livewell.baby.pool.jdbc";

    /** ǡ꥽̾ */
    private static final String RESOURCE_NAME = "babyPool";


    // sub class names --------------------------------------------------------
    /** createInstance᥽åɤsub class̾ */
    private static final String[] SUB_CLASS_NAMES = new String[]
    {
	"jp.livewell.baby.pool.jdbc.PropertiesLoader",
	"jp.livewell.baby.pool.jdbc.XmlLoader"
    };


    // factory methods --------------------------------------------------------
    /**
     * ŬڤConnectionInfoLoaderޤŪˤ
     * class pathjp.livewell.baby.pool.jdbc.babyPool.propertiesդ
     * äˤPropertiesLoader򡢸դʤäˤƱ֤
     * babyPool.xmlõդXmlLoader֤ޤƤΥ꥽
     * ȯʤȤˤRuntimeExceptionthrowޤ
     *
     * @return	ŬڤConnectionPoolInfoLoadersub class
     * @throws	RuntimeException
     *		ƤΥ꥽ȯǤʤäȤ
     */
    static ConnectionPoolInfoLoader createInstance()
	throws RuntimeException
    {
	boolean isFound = false;
	ConnectionPoolInfoLoader loader = null;

	for (int i = 0; i < SUB_CLASS_NAMES.length; i++) {
	    Class cls = null;
	    {
		String subclassName = SUB_CLASS_NAMES[i];
		try {
		    cls = Class.forName(subclassName);
		} catch (ClassNotFoundException e) {
		    continue;
		}
	    }

	    try {
		loader = (ConnectionPoolInfoLoader) cls.newInstance();
	    } catch (InstantiationException e) {
		continue;
	    } catch (IllegalAccessException e) {
		continue;
	    }

	    loader.init(RESOURCE_PATH, RESOURCE_NAME);

	    if (loader.isFoundResource()) {
		isFound = true;
		break;
	    }
	}

	if (isFound) {
	    return loader;
	} else {
	    throw new RuntimeException
		("can't find babyPool resource. please check classpath.");
	}
    }	


    // attributes -------------------------------------------------------------
    /** ե饰 */
    private boolean isInit = false;

    /** ꥽¸ߤPATHǤ*/
    private String resourcePath = "";
    
    /** ꥽̾Ǥ*/
    private String resourceName = "";


    // constructors & init ----------------------------------------------------
    /**
     * ͣprotected constructor
     */
    protected ConnectionPoolInfoLoader()
    {
	// do nothing
    }

    /**
     * ꥽ΰ(path)ȥ꥽̾(full nameǤϤʤ)ꤷ
     * ConnectionPoolInfoLoaderޤ
     *
     * @param	resPath
     *		꥽path
     * @param	resName
     *		꥽̾(full nameǤϤʤĥϴޤޤ)
     */
    void init(String resPath,
	      String resName)
    {
	resourcePath = resPath;
	resourceName = resName;
	isInit = true;
    }


    // accessor ---------------------------------------------------------------
    /**
     * ConnectionPoolInfoLoaderƤ뤫ɤޤ
     *
     * @return	 Ƥtrue
     */
    boolean isInit()
    {
	return isInit;
    }

    /**
     * ConnectionPoolInfoLoader׵᤹꥽ξͿ
     * 줿path˸դtrue򡢸դʤfalse֤ޤ
     * ƤʤIllegalStateExceptionthrowޤ
     *
     * @return	׵᤹꥽դtrueʳfalse
     * @throws	IllegalStateException
     *		Ƥʤ
     */
    abstract boolean isFoundResource()
	throws IllegalStateException;
    
    /**
     * ꥽ConnectionPoolInfoLoaderԤ꥽˥
     *		äȤ
     *		Ƥʤ祹pathޤ
     *
     * @return	꥽path
     * @throws	IllegalStateException
     *		Ƥʤä
     */
    String getResourcePath()
	throws IllegalStateException
    {
	if (isInit()) {
	    return resourcePath;
	} else {
	    throw new IllegalStateException("this Loader is not init.");
	}
    }

    /**
     * ꥽̾(full nameǤϤʤ)ޤ
     * 
     * @return	꥽̾(full nameǤϤʤĥҤϴޤޤ)
     * @throws	IllegalStateException
     *		Ƥʤä
     */
    String getResourceName()
	throws IllegalStateException
    {
	if (isInit()) {
	    return resourceName;
	} else {
	    throw new IllegalStateException("this Loader is not init.");
	}   
    }
    
    /**
     * ꥽full nameޤ
     * 
     * @return	꥽full name
     * @throws	IllegalStateException
     *		Ƥʤä
     */
    String getFullName()
	throws IllegalStateException
    {
	return getResourcePath() + "." + getResourceName();
    }


    // action -----------------------------------------------------------------
    /**
     * ꥽Ϥ1ĤConnectionPoolInfoξMapkeyvalue
     * Map֤ޤ
     *
     * @return	ConnectionPool1ʬξ1ĤMap instanceбƤ
     *		Map
     * @throws	Exception
     *		ConnectionPoolInfoLoaderԤ꥽˥
     *		äȤ
     *		Ƥʤ
     */
    protected abstract Map[] parseResource()
	throws Exception;

    /**
     * ƤConnectionPoolInfoSetǼޤ
     *
     * @return	ConnectionPoolInfoǤȤSet
     * @throws	Exception
     *		ConnectionPoolInfoLoaderԤ꥽˥
     *		äȤ
     *		Ƥʤ
     */
    Set loadAll()
	throws Exception
    {
	HashSet infos = new HashSet();
	{
	    Map[] parseds = parseResource();
	
	    for (int i = 0; i < parseds.length; i++) {
		Map parsed = parseds[i];
		ConnectionPoolInfo info = new ConnectionPoolInfo();
		
		setValues(info, parsed);
		infos.add(info);
	    }
	}
	return infos;
    }

    /**
     * info˲Ϻѥǡ(parsed)ͤꤷޤparsedǻꤹmapkey
     * ConnectionPoolInfoγsetXXX᥽åɤXXXʬ˰פƤ
     * ɬפޤâʸʸϴطޤ󡣤ޤĥץ
     * ƥextention.XXXΥեޥåȤ˰פƤɬפޤͤ
     * оݤȤ᥽åɤɤ߹javaηȤƲ褦˻ꤷƲ
     * 
     * 
     * @param	info
     *		ͤꤹConnectionPoolInfo
     * @param	parsed
     *		ϺѤΥ꥽keysetXXXXXXʬ뤤
     *		extention.XXXΥեޥå
     */
    private void setValues(ConnectionPoolInfo info,
			   Map parsed)
    {
	Set methodSet 
	    = new HashSet(Arrays.asList(info.getClass().getMethods()));

	for (Iterator keys = parsed.keySet().iterator(); keys.hasNext();) {

	    String key	= (String) keys.next();
	    Object val	= parsed.get(key);

	    String methodName;
	    String extKey = "";
	    {
		int index;
		String lower;

		if ((index = key.indexOf('.')) == -1) {
		    lower = key.toLowerCase();
		} else {
		    lower = key.substring(0, index).toLowerCase();
		    extKey = key.substring(++index);
		}
		methodName = "set" + lower;
	    }

	    for (Iterator methods = methodSet.iterator(); methods.hasNext();) {
		Method m = (Method) methods.next();

		try {
		    if (methodName.equals(m.getName().toLowerCase())) {
			Class[] types = m.getParameterTypes();

			if (types.length == 1) {
			    /* case normal setter */
			    Object conv = convert(types[0], val);
			    m.invoke(info, new Object[] {conv});
			    methods.remove();

			} else if (types.length == 2) {
			    /* case extention setter. do not remove method */
			    Object conv = convert(types[1], val);
			    m.invoke(info, new Object[] {extKey, conv});

			} else {
			    /* case not match */
			    continue;
			}
			break;
		    }
		} catch (Exception e) {
		    e.printStackTrace();
		    throw new IllegalArgumentException
			("invalid value found in babyPool's config file.\n"
			 + "  name = " + key + "\n"
			 + "  value = " + val + "\n");
		}
	    }
	}		
    }

    /**
     * clsͿ줿Classɽ󥹥󥹤valͿ줿󥹥󥹤
     * 褦ȤޤΤByte, Double, Float, Integer, Long
     * StringǤѴʤϸΥ󥹥󥹤ᤷޤ
     *
     * @param	cls
     *		Ѵߤ󥹥󥹤Class
     * @param	val
     *		Ѵ󥹥
     * @return	Ѵ̤Υ󥹥󥹡ѴǤʤϸΥ󥹥
     */
    private Object convert(Class cls,
			   Object val)
    {
	Object ret = null;
	try {
	    String str;
	    if (val instanceof String) {
		str = (String) val;
	    } else {
		str = val.toString();
	    }

	    if (cls.isPrimitive()) {
		if (cls == Byte.TYPE) {
		    ret = new Byte(str);
		} else if (cls == Double.TYPE) {
		    ret = new Double(str);
		} else if (cls == Float.TYPE) {
		    ret = new Float(str);
		} else if (cls == Integer.TYPE) {
		    ret = new Integer(str);
		} else if (cls == Long.TYPE) {
		    ret = new Long(str);
		}
	    } else if (!cls.isArray()) {
		Constructor cnst 
		    = cls.getConstructor(new Class[] {String.class});
		ret = cnst.newInstance(new Object[] {str});
	    } else {
		ret = val;
	    }
	} catch (Exception e) {
	    ret = val;
	}
	return ret;
    }
}
