/*
 * $Id: DataSourceFactory.java,v 1.1.1.1 2002/12/10 09:18:12 mitsuhito Exp $
 */


package jp.livewell.baby.pool.jdbc;


import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.sql.DataSource;


/**
 * ConnectionPoolǡȤưJNDI䤤碌Ф̾
 * ١ˤƳConnectionPool᤹classǤ
 *
 * @author mitsuhito
 */
public class DataSourceFactory
    implements ObjectFactory
{
    // constructors & init ----------------------------------------------------
    /**
     * DataSourceFactoryۤޤ
     */
    public DataSourceFactory()
    {
	// do nothing
    }


    // ObjectFactory inplementation ------------------------------------------
    /**
     * DataSource(ConnectionPool)instance֤ޤ
     * objectReferenceξReference.getClassName
     * jp.livewell.baby.pool.jdbc.ConnectionPool֤nameǻꤵ줿
     * ̾ConnectionPoolinstance褦Ȼߤޤ⤷ꤵ
     * ̾Pool¸ߤʤnull֤ޤPool˼Ԥ
     * (ۤȤɤcaseǤproperties(xml) fileεҤְäƤ뤫
     * classpaht¸ߤʤʤɤ̿Ūʥ顼)Exceptionthrow
     * ޤ
     *
     * @param	object
     *		JNDI䤤碌Reference instance
     * @param	name
     *		pool̾ΤߤޤJNDI Name instance
     * @param	nameContext
     *		classˤä˰̣ޤ
     * @param	environment
     *		classˤä˰̣ޤ
     * @return	javax.sql.DataSource interfaceConnectionPool
     * @throws	Exception
     *		ConnectionPool˼ԤȤ(¸ߤʤnull
     *		ޤ)
     */
    public Object getObjectInstance(Object    object,
				    Name      name,
				    Context   nameContext,
				    Hashtable environment)
	throws Exception
    {
	ConnectionPool pool = null;

	if (object instanceof Reference) {
	    Reference ref = (Reference) object;
	    String className = ref.getClassName();

	    if (ConnectionPool.class.getName().equals(className)) {
		RefAddr addr = ref.get(DataSource.class.getName());

		String poolName;

		if ((addr != null) && (addr instanceof StringRefAddr)) {
		    poolName = (String) addr.getContent();
		} else if (name != null) {
		    poolName = name.toString();
		} else {
		    poolName = "";
		}

		ResourceManager manager = ResourceManager.getInstance();
		pool = manager.findPoolByName(poolName);
	    }
	}
	return pool;
    }
}
