/*
 * $Id: PoolDriver.java,v 1.1.1.1 2002/12/10 09:18:12 mitsuhito Exp $
 */


package jp.livewell.baby.pool.jdbc;


import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;


/**
 * babyPoolJDBC DriverǤDriverManager׵ŬȻפ
 * ConnectionPoolžޤ
 *
 * @author mitsuhito
 */
public class PoolDriver
    implements Driver
{
    // Driver requiement ------------------------------------------------------
    static {
	try {
	    PoolDriver pd = new PoolDriver();
	    DriverManager.registerDriver(pd);
	} catch (SQLException e) {
	    throw new RuntimeException(e.toString());
	}
    }


    // attributes -------------------------------------------------------------
    /** ConnectionPoolݻinstance */
    private final ResourceManager manager;


    // constructors & init ----------------------------------------------------
    /**
     * PoolDriverۤޤ
     */
    public PoolDriver()
    {
	manager = ResourceManager.getInstance();
    }


    // Driver implementation --------------------------------------------------
    /**
     * java.sql.Driver#acceptsURLޤ
     * PoolDriverϡϿƤConnectionPoolConnectionFactory
     * ݻJDBC DriverΤ1ĤacceptsURLtrue᤻true֤
     * ޤ
     *
     * @param	url
     *		ǡ١URL
     * @return	ꤵ줿URL³true
     * @throws	SQLException
     *		JDBC Driverthrow
     */
    public boolean acceptsURL(String url)
	throws SQLException
    {
	return manager.isAvailableUrl(url);
    }

    /**
     * java.sql.Driver#connectޤ
     *
     * @param	url
     *		ǡ١URL
     * @param	info
     *		³ȤƤΡǤդʸ󥿥ͤΥڥΥꥹȡ
     *		̾ϡʤȤ "user" ץѥƥ "password" ץѥƥ
     *		ϻꤷʤФʤʤ
     * @return	JDBC Connection(Wrapper)
     * @throws	SQLException
     *		ǡ١顼ȯ硣
     *		Pooltimeout硣
     */
    public Connection connect(String url,
			      Properties info)
	throws SQLException
    {
	ConnectionPool pool = manager.findPoolByBetter(url, info);
	if (pool != null) {
	    return pool.getConnection(url, info);
	} else {
	    return null;
	}
    }

    /**
     * java.sql.Driver#getMajorVersionޤ
     * babyPoolΥ᥸㡼Сޤ
     * 
     * @return	babyPoolΥ᥸㡼С
     */
    public int getMajorVersion()
    {
	return 1;
    }

    /**
     * java.sql.Driver#getMinorVersionޤ
     * babyPoolΥޥʡСޤ
     *
     * @return	babyPoolΥޥʡС
     */
    public int getMinorVersion()
    {
	return 0;
    }

    /**
     * java.sql.Driver#getPropertyInfoޤ
     * Υɥ饤ФϾ˶֤ޤ
     *
     * @param	url
     *		ǡ١URL
     * @param	info
     *		³ץΤ륿/ͥڥο侩ꥹ
     * @return	JDBC Driver֤DriverPropertyInfo
     * @throws	SQLException
     *		ǡ١顼ȯ
     */
    public DriverPropertyInfo[] getPropertyInfo(String url,
						Properties info)
	throws SQLException
    {
	return new DriverPropertyInfo[0];
    }
    
    /**
     * java.sql.Driver#jdbcCompliantޤ
     * Υɥ饤ФϾfalse֤ޤ
     *
     * @return	false
     */
    public boolean jdbcCompliant()
    {
	return false;
    }
}
