/*
 * $Id: PreparedStatementWrapper.java,v 1.1.1.1 2002/12/10 09:18:12 mitsuhito Exp $
 */


package jp.livewell.baby.pool.jdbc;


import java.io.InputStream;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;


/**
 * java.sql.PreparedStatement interfaceimplementsPreparedStatement
 * ˻ѤǤWrapper classǤ
 *
 * @author mitsuhito
 */
class PreparedStatementWrapper
    extends StatementWrapper
    implements PreparedStatement 
{
    // constructors ----------------------------------------------------------
    /**
     * PreparedStatementWrapinstanceۤޤ
     *
     * @param	pstmt
     *		WrapJDBC PreparedStatement instance
     * @param	connRef
     *		WrapperConnectionWrapperؤμ廲
     * @throws	IllegalArgumentException
     *		pstmtnullꤷ褦Ȥ硣
     *		connRefnullꤷ褦Ȥ硣
     *		connRefλȤJDBC ConnectionǤ̵硣
     */
    PreparedStatementWrapper(PreparedStatement pstmt,
			     WeakReference connRef)
	throws IllegalArgumentException
    {
	super(pstmt, connRef);
    }


    // accessor ---------------------------------------------------------------
    /**
     * raw JDBC PreparedStatementᤷޤ
     *
     * @return	raw JDBC PreparedStatement
     */
    protected PreparedStatement prepared()
    {
	return (PreparedStatement) statement();
    }


    // PreparedStatement implementation ---------------------------------------
    /**
     * Wrap줿JDBC PreparedStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @throws	SQLException
     *		Wrap줿JDBC PreparedStatementthrow
     */
    public void addBatch()
	throws SQLException 
    {
	prepared().addBatch();
    }
     
    /**
     * Wrap줿JDBC PreparedStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @throws	SQLException
     *		Wrap줿JDBC PreparedStatementthrow
     */
    public void clearParameters()
	throws SQLException 
    {
	prepared().clearParameters();
    }
     
    /**
     * Wrap줿JDBC PreparedStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @return	Wrap줿JDBC PreparedStatement줿
     * @throws	SQLException
     *		Wrap줿JDBC PreparedStatementthrow
     */
    public boolean execute()
	throws SQLException 
    {
	return prepared().execute();
    }
     
    /**
     * Wrap줿JDBC PreparedStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @return	Wrap줿JDBC PreparedStatement줿
     * @throws	SQLException
     *		Wrap줿JDBC PreparedStatementthrow
     */
    public ResultSet executeQuery()
	throws SQLException 
    {
	ResultSet res = new ResultSetWrapper
	    (prepared().executeQuery(), ownReference());
	setCurrentResultSet(res);
	return res;
    }
     
    /**
     * Wrap줿JDBC PreparedStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @return	Wrap줿JDBC PreparedStatement줿
     * @throws	SQLException
     *		Wrap줿JDBC PreparedStatementthrow
     */
    public int executeUpdate()
	throws SQLException 
    {
	return prepared().executeUpdate();
    }
     
    /**
     * Wrap줿JDBC PreparedStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @return	Wrap줿JDBC PreparedStatement줿
     * @throws	SQLException
     *		Wrap줿JDBC PreparedStatementthrow
     */
    public ResultSetMetaData getMetaData()
	throws SQLException 
    {
	return prepared().getMetaData();
    }
     
    /**
     * Wrap줿JDBC PreparedStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @param	index
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @param	val
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC PreparedStatementthrow
     */
    public void setArray(int index,
			 Array val)
	throws SQLException
    {
	prepared().setArray(index, val);
    }
     
    /**
     * Wrap줿JDBC PreparedStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @param	index
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @param	val
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @param	length
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC PreparedStatementthrow
     */
    public void setAsciiStream(int index,
			       InputStream val,
			       int length)
	throws SQLException 
    {
	prepared().setAsciiStream(index, val, length);
    }
     
    /**
     * Wrap줿JDBC PreparedStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @param	index
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @param	val
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC PreparedStatementthrow
     */
    public void setBigDecimal(int index,
			      BigDecimal val)
	throws SQLException
    {
	prepared().setBigDecimal(index, val);
    }
     
    /**
     * Wrap줿JDBC PreparedStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @param	index
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @param	val
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @param	length
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC PreparedStatementthrow
     */
    public void setBinaryStream(int index,
				InputStream val,
				int length)
	throws SQLException 
    {
	prepared().setBinaryStream(index, val, length);
    }
     
    /**
     * Wrap줿JDBC PreparedStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @param	index
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @param	val
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC PreparedStatementthrow
     */
    public void setBlob(int index,
			Blob val)
	throws SQLException 
    {
	prepared().setBlob(index, val);
    }
     
    /**
     * Wrap줿JDBC PreparedStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @param	index
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @param	val
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC PreparedStatementthrow
     */
    public void setBoolean(int index,
			   boolean val)
	throws SQLException 
    {
	prepared().setBoolean(index, val);
    }
     
    /**
     * Wrap줿JDBC PreparedStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @param	index
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @param	val
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC PreparedStatementthrow
     */
    public void setByte(int index,
			byte val)
	throws SQLException 
    {
	prepared().setByte(index, val);
    }
     
    /**
     * Wrap줿JDBC PreparedStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @param	index
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @param	val
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC PreparedStatementthrow
     */
    public void setBytes(int index,
			 byte[] val)
	throws SQLException 
    {
	prepared().setBytes(index, val);
    }
     
    /**
     * Wrap줿JDBC PreparedStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @param	index
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @param	reader
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @param	length
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC PreparedStatementthrow
     */
    public void setCharacterStream(int index,
				   Reader reader,
				   int length)
	throws SQLException 
    {
	prepared().setCharacterStream(index, reader, length);
    }

    /**
     * Wrap줿JDBC PreparedStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @param	index
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @param	val
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC PreparedStatementthrow
     */
    public void setClob(int index,
			Clob val)
	throws SQLException 
    {
	prepared().setClob(index, val);
    }

    /**
     * Wrap줿JDBC PreparedStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @param	index
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @param	val
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC PreparedStatementthrow
     */
    public void setDate(int index,
			Date val)
	throws SQLException 
    {
	prepared().setDate(index, val);
    }
     
    /**
     * Wrap줿JDBC PreparedStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @param	index
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @param	val
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @param	cal
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC PreparedStatementthrow
     */
    public void setDate(int index,
			Date val,
			Calendar cal)
	throws SQLException 
    {
	prepared().setDate(index, val, cal);
    }
     
    /**
     * Wrap줿JDBC PreparedStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @param	index
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @param	val
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC PreparedStatementthrow
     */
    public void setDouble(int index,
			  double val)
	throws SQLException 
    {
	prepared().setDouble(index, val);
    }
     
    /**
     * Wrap줿JDBC PreparedStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @param	index
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @param	val
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC PreparedStatementthrow
     */
    public void setFloat(int index,
			 float val)
	throws SQLException 
    {
	prepared().setFloat(index, val);
    }
     
    /**
     * Wrap줿JDBC PreparedStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @param	index
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @param	val
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC PreparedStatementthrow
     */
    public void setInt(int index,
		       int val)
	throws SQLException 
    {
	prepared().setInt(index, val);
    }
     
    /**
     * Wrap줿JDBC PreparedStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @param	index
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @param	val
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC PreparedStatementthrow
     */
    public void setLong(int index,
			long val)
	throws SQLException 
    {
	prepared().setLong(index, val);
    }
     
    /**
     * Wrap줿JDBC PreparedStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @param	index
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @param	sqlType
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC PreparedStatementthrow
     */
    public void setNull(int index,
			int sqlType)
	throws SQLException 
    {
	prepared().setNull(index, sqlType);
    }
     
    /**
     * Wrap줿JDBC PreparedStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @param	index
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @param	sqlType
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @param	typeName
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC PreparedStatementthrow
     */
    public void setNull(int index,
			int sqlType,
			String typeName)
	throws SQLException 
    {
	prepared().setNull(index, sqlType, typeName);
    }
     
    /**
     * Wrap줿JDBC PreparedStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @param	index
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @param	val
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @param	targetSqlType
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @param	scale
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC PreparedStatementthrow
     */
    public void setObject(int index,
			  Object val,
			  int targetSqlType,
			  int scale)
	throws SQLException 
    {
	prepared().setObject(index, val, targetSqlType, scale);
    }
         
    /**
     * Wrap줿JDBC PreparedStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @param	index
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @param	val
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @param	targetSqlType
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC PreparedStatementthrow
     */
    public void setObject(int index,
			  Object val,
			  int targetSqlType)
	throws SQLException 
    {
	prepared().setObject(index, val, targetSqlType);
    }
     
    /**
     * Wrap줿JDBC PreparedStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @param	index
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @param	val
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC PreparedStatementthrow
     */
    public void setObject(int index,
			  Object val)
	throws SQLException 
    {
	prepared().setObject(index, val);
    }

    /**
     * Wrap줿JDBC PreparedStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @param	index
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @param	val
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC PreparedStatementthrow
     */
    public void setRef(int index,
		       Ref val)
	throws SQLException 
    {
	prepared().setRef(index, val);
    }
     
    /**
     * Wrap줿JDBC PreparedStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @param	index
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @param	val
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC PreparedStatementthrow
     */
    public void setShort(int index,
			 short val)
	throws SQLException 
    {
	prepared().setShort(index, val);
    }
     
    /**
     * Wrap줿JDBC PreparedStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @param	index
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @param	val
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC PreparedStatementthrow
     */
    public void setString(int index,
			  String val)
	throws SQLException 
    {
	prepared().setString(index, val);
    }
     
    /**
     * Wrap줿JDBC PreparedStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @param	index
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @param	val
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC PreparedStatementthrow
     */
    public void setTime(int index,
			Time val)
	throws SQLException 
    {
	prepared().setTime(index, val);
    }
     
    /**
     * Wrap줿JDBC PreparedStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @param	index
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @param	val
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @param	cal
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC PreparedStatementthrow
     */
    public void setTime(int index,
			Time val,
			Calendar cal)
	throws SQLException 
    {
	prepared().setTime(index, val, cal);
    }
     
    /**
     * Wrap줿JDBC PreparedStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @param	index
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @param	val
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC PreparedStatementthrow
     */
    public void setTimestamp(int index,
			     Timestamp val)
	throws SQLException 
    {
	prepared().setTimestamp(index, val);
    }
     
    /**
     * Wrap줿JDBC PreparedStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @param	index
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @param	val
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @param	cal
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC PreparedStatementthrow
     */
    public void setTimestamp(int index,
			     Timestamp val,
			     Calendar cal)
	throws SQLException 
    {
	prepared().setTimestamp(index, val, cal);
    }
     
    /**
     * Wrap줿JDBC PreparedStatementƱ쥷ͥ᥽åɤ׵ž
     * ޤ
     *
     * @param	index
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @param	val
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @param	length
     *		Wrap줿JDBC PreparedStatementؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC PreparedStatementthrow
     */
    public void setUnicodeStream(int index,
				 InputStream val,
				 int length)
	throws SQLException 
    {
	prepared().setUnicodeStream(index, val, length);
    }
}
