/*
 * $Id: PropertiesLoader.java,v 1.1.1.1 2002/12/10 09:18:12 mitsuhito Exp $
 */


package jp.livewell.baby.pool.jdbc;


import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;


/**
 * babyPool.properties fileConnectionPoolInfoޤ
 *
 * @author mitsuhito
 */
class PropertiesLoader
    extends ConnectionPoolInfoLoader
{
    // constructors & init ----------------------------------------------------
    /**
     * ͣdefault constructorsǤPropertiesLoaderۤޤ
     */
    PropertiesLoader()
    {
	// do nothing
    }


    // over rides -------------------------------------------------------------
    /**
     * getFullName򥪡С饤ɤޤ
     * ResourceBundleǤ̾ޤ
     * 
     * @return	ResourceBundleǤ̾
     */
    String getFullName()
    {
	return super.getFullName().replace('.', '/');
    }

    /**
     * babyPool.properties fileξͿ줿path˸դ
     * true򡢸դʤfalse֤ޤ
     * ƤʤIllegalStateExceptionthrowޤ
     *
     * @return	׵᤹꥽դtrueʳfalse
     * @throws	IllegalStateException
     *		Ƥʤ
     */
    boolean isFoundResource()
	throws IllegalStateException
    {
	boolean isFound = false;
	try {
	    ResourceBundle.getBundle(getFullName());
	    isFound = true;
	} catch (MissingResourceException e) {
	    // do nothing
	}
	return isFound;
    }

    /**
     * ConnectionPoolnfoLoader#parseResource򥪡С饤ɤޤ
     * Properties fileɤ߹ǡMapkeyvalueǲϷ̤դޤ
     *
     * @return	Ϸ̤MapLoader̾1ĤMap֤ޤ
     * @throws	Exception
     *		ConnectionPoolInfoLoaderԤ꥽˥
     *		äȤ
     *		Ƥʤ
     */
    protected Map[] parseResource()
	throws Exception
    {
	HashMap parsed = new HashMap();
	{
	    ResourceBundle bundle = ResourceBundle.getBundle(getFullName());

	    for (Enumeration keys = bundle.getKeys();
		 keys.hasMoreElements();) {
		String key = (String) keys.nextElement();

		parsed.put(key, bundle.getString(key));
	    }
	}
	return new Map[] {parsed};
    }
}
