/*
 * $Id: ResourceManager.java,v 1.1.1.1 2002/12/10 09:18:12 mitsuhito Exp $
 */


package jp.livewell.baby.pool.jdbc;


import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;


/**
 * babyPooljdbcʬǻѤƼ꥽(ConnectionPoolޤ)ݻ
 * classǤ
 *
 * @author mitsuhito
 */
class ResourceManager
{
    // singleton --------------------------------------------------------------
    /** singleton instance */
    private static ResourceManager single = null;

    /**
     * ƱJVMͣinstanceޤ
     *
     * @return	ƱJVMͣinstance
     * @throws	RuntimeException
     *		ConnectionPool˼ԤȤ
     */
    static ResourceManager getInstance()
	throws RuntimeException
    {
	synchronized (ResourceManager.class) {
	    if (single == null) {
		single = new ResourceManager();
		
		try {
		    single.loadPoolAll();
		} catch (Exception e) {
		    throw new RuntimeException
			("loading pools fail.\n" + e);
		}
	    }
	    return single;
	}
    }


    // attributes -------------------------------------------------------------
    /** ConnectionPool's array List */
    private final ArrayList pools = new ArrayList();

    /** ConnectionPool map key = pool-name, value = ConnectionPool */
    private final HashMap poolNameMap = new HashMap();


    // constructors & init ----------------------------------------------------
    /**
     * singletonΤᡢprivate construcorǤƤΥסɤ߹ߤޤ
     * ɤ߹ߤˡConnectionPoolInfoLoader˽ޤ
     */
    private ResourceManager()
    {
	// do nothing
    }


    // pool accessor ----------------------------------------------------------
    /**
     * ꤷ̾ConnectionPoolޤ¸ߤʤnull
     * ᤷޤ
     *
     * @param	name
     *		ConnectionPool̾
     * @return	ꤷ̾ConnectionPool¸ߤʤnull
     */
    ConnectionPool findPoolByName(String name)
    {
	return (ConnectionPool) poolNameMap.get(name);
    }

    /**
     * ꤷurl³ȿǤȻפŬConnectionPool
     * ޤ¸ߤʤnullᤷޤ
     *
     * @param	url
     *		ǡ١URL
     * @param	info
     *		ǡ١³
     * @return	ꤷurl³ȿǤȻפConnectionPool
     *		¸ߤʤnull
     * @throws	SQLException
     *		ǡ١顼ȯ
     */
    ConnectionPool findPoolByBetter(String url,
				    Properties info)
	throws SQLException
    {
	ConnectionPool pool = null;
	{
	    ArrayList		pls = pools;
	    ConnectionPool	pl;

	    int available;  
	    int size = pls.size();

	    for (int i = 0; i < size; i++) {
		pl = (ConnectionPool) pls.get(i);
		available = pl.checkAvailable(url, info);

		if (available == ConnectionPool.CONNECT_POOLING) {
		    pool = pl;
		    break;
		} else if (available == ConnectionPool.CONNECT_ACCEPT) {
		    pool = pl;
		}
	    }
	}
	return pool;
    }

    /**
     * ϿƤConnectionPoolΤ1ĤǤꤵ줿urlȿǤ뤫
     * ɤᤷޤ
     *
     * @param	url
     *		ǡ١URL
     * @return	ϿƤConnectionPoolΤ1ĤǤꤵ줿urlȿ
     *		Ǥtrue, ʳfalse
     * @throws	SQLException
     *		ǡ١顼ȯ
     */
    boolean isAvailableUrl(String url)
	throws SQLException
    {
	boolean isAvailable = false;
	{
	    ConnectionPool pl;
	    ArrayList pls = pools;
	    int size = pls.size();

	    for (int i = 0; i < size; i++) {
		pl = (ConnectionPool) pls.get(i);
		
		if (pl.checkAvailable(url) 
			    != ConnectionPool.CONNECT_IMPOSSIBLE) {
		    isAvailable = true;
		    break;
		}
	    }
	}
	return isAvailable;
    }

    /**
     * ꤵ줿ConnectionPoolϿޤ
     *
     * @param	pool
     *		ϿConnectionPool
     * @throws	IllegalArgumentException
     *		Ʊ̾poolϿƤ硣
     *		nullꤷ硣
     */
    void registerPool(ConnectionPool pool)
	throws IllegalArgumentException
    {
	if (pool != null) {
	    String name = pool.getName();

	    synchronized (this) {
		if (!poolNameMap.containsKey(name)) {
		    poolNameMap.put(name, pool);
		    pools.add(pool);

		    ConnectionFactory fac
			= (ConnectionFactory) pool.getFactory();

		    try {
			DriverManager.deregisterDriver(fac.getDriver());
		    } catch (SQLException e) {
			// do nothing
		    }
		} else {
		    /* can't regist case. */
		    throw new IllegalArgumentException
			("already registed this ConnectionPool. name = "
			 + name + ".\n");
		}
	    }
	} else {
	    /* null case */
	    throw new IllegalArgumentException
		("can't regist null to ResourceManager.");
	}
    }

    /**
     * ꤵ줿̾ConnectionPoolϿConnectionPool
     * ᤷޤϿƤʤnullᤷޤ
     * 
     * @param	name
     *		ϿPool̾
     * @return	Ͽ줿Pool
     */
    ConnectionPool deregisterPool(String name)
    {
	ConnectionPool pool = null;

	synchronized (this) {
	    if (poolNameMap.containsKey(name)) {
		pool = (ConnectionPool) poolNameMap.remove(name);

		while (pools.remove(pool)) {
		    // do nothing
		}

		/* ¾ƱDriverѤƤPoolʤDriverϿ */
		ConnectionFactory fac = (ConnectionFactory) pool.getFactory();
		Driver drv = fac.getDriver();

		if (findDriverByName(drv.getClass().getName()) == null) {
		    try {
			DriverManager.registerDriver(drv);
		    } catch (SQLException e) {
			// do nothing
		    }
		}
	    }
	}
	return pool;
    }

    /**
     * ϿƤConnectionPool֤̾ޤ
     *
     * @return	ϿƤConnectionPool̾Set
     */
    Set poolNameSet()
    {
	return new HashSet(poolNameMap.keySet());
    }


    // Driver accessor --------------------------------------------------------
    /**
     * classNameǻꤵ줿JDBC DriverѤƤConnectionPoolС
     * Driverᤷޤ̵nullᤷޤ
     *
     * @param	className
     *		JDBC Driverfull class name
     * @return	ConnectionPoolǻѤƤJDBC Driver̵null
     */
    Driver findDriverByName(String className)
    {
	Driver drv = null;

	for (Iterator itr = poolNameMap.values().iterator(); itr.hasNext();) {
	    ConnectionPool pool = (ConnectionPool) itr.next();

	    Driver d = ((ConnectionFactory) pool.getFactory()).getDriver();
	    if (d.getClass().getName().equals(className)) {
		drv = d;
		break;
	    }
	}
	return drv;
    }


    // action -----------------------------------------------------------------
    /**
     * ƤConnectionPoolե뤫ɤߤϿޤ
     *
     * @throws	Exception
     *		ե(babyPool.xxxx)˥ʤäȤ
     *		ConnectionPoolιۤ˼ԤȤ
     *		Ʊ̾ConnectionPool¸ߤȤ
     */
    private void loadPoolAll()
	throws Exception
    {
	Set infos;
	{
	    ConnectionPoolInfoLoader loader
		= ConnectionPoolInfoLoader.createInstance();
	    infos = loader.loadAll();
	}

	for (Iterator itr = infos.iterator(); itr.hasNext();) {
	    ConnectionPoolInfo info = (ConnectionPoolInfo) itr.next();

	    ConnectionPool pool = new ConnectionPool(info);
	    registerPool(pool);
	}
    }
}
