/*
 * $Id: ResultSetWrapper.java,v 1.1.1.1 2002/12/10 09:18:13 mitsuhito Exp $
 */


package jp.livewell.baby.pool.jdbc;


import java.io.InputStream;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

import jp.livewell.baby.pool.AbstractWrapper;
import jp.livewell.baby.pool.ComparisonKey;


/**
 * java.sql.ResultSet interfaceimplementsResultSet˻ѤǤ
 * Wrapper classǤ
 *
 * @author mitsuhito
 */
class ResultSetWrapper
    extends AbstractWrapper
    implements ResultSet
{
    // attributes -------------------------------------------------------------
    /** ºݤJDBC ResultSetǤ */
    private ResultSet result;

    /** StatementWrapperؤμ廲 */
    private WeakReference stmtRef;


    // constructors & init ----------------------------------------------------
    /**
     * StatementWrapinstanceۤޤ
     *
     * @param	result
     *		WrapJDBC Resultset instance
     * @param	stmtRef
     *		WrapperStatementWrapper(sub class)ؤμ廲
     * @throws	IllegalArgumentException
     *		resultnullꤷ褦Ȥ硣
     *		stmtRefnullꤷ褦Ȥ硣
     *		stmtRefλȤJDBC Statement(sub class)Ǥ̵硣
     */
    ResultSetWrapper(ResultSet result,
		     WeakReference stmtRef)
	throws IllegalArgumentException
    {
	if ((result != null) && (stmtRef != null)) {
	    if (stmtRef.get() instanceof Statement) {
		this.result	= result;
		this.stmtRef	= stmtRef;
	    } else {
		throw new IllegalArgumentException
		    ("need java.sql.Statement(or it's sub class) reference!");
	    }
	} else {
	    throw new IllegalArgumentException
		("please check params.\n"
		 + "result = " + result + "\n"
		 + "stmtRef = " + stmtRef + "\n");
	}
	activate(getComparisonKey());
    }


    // over rides -------------------------------------------------------------
    /**
     * Wrapper˳ǼƤJDBC ResultSetcloseƤΥ꥽
     * ƻԲĤˤޤ
     */
    public synchronized void destroy(ComparisonKey key)
    {
	try {
	    super.destroy(key);
	    if (result != null) {
		result.close();
	    }
	} catch (Exception e) {
	    // do nothing
	} finally {
	    //result	= null;
	    stmtRef	= null;
	}
    }

    /**
     * trueᤷޤ
     *
     * @return	true
     */
    protected boolean ping()
    {
	return true;
    }


    // accessor ---------------------------------------------------------------
    /**
     * raw ResultSetᤷޤ
     *
     * @return	raw ResultSet
     */
    private ResultSet resultSet()
    {
	return result;
    }


    // ResultSet implementation -----------------------------------------------
    /**
     * ResultSet ObjectĤƳޤ
     * @throws	SQLException
     *		ºݤˤthrowޤ
     */
    public void close()
	throws SQLException
    {
	destroy(getComparisonKey());
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	row
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public boolean absolute(int row)
	throws SQLException 
    { 
	return resultSet().absolute(row);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public void afterLast()
	throws SQLException 
    {
	resultSet().afterLast();
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public void beforeFirst()
	throws SQLException 
    {
	resultSet().beforeFirst();
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public void cancelRowUpdates()
	throws SQLException 
    {
	resultSet().cancelRowUpdates();
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public void clearWarnings()
	throws SQLException 
    {
	resultSet().clearWarnings();
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public void deleteRow()
	throws SQLException 
    {
	resultSet().deleteRow();
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	name
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public int findColumn(String name)
	throws SQLException 
    {
	return resultSet().findColumn(name);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public boolean first()
	throws SQLException 
    {
	return resultSet().first();
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public int getConcurrency()
	throws SQLException 
    {
	return resultSet().getConcurrency();
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public String getCursorName()
	throws SQLException
    {
	return resultSet().getCursorName();
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public int getFetchDirection()
	throws SQLException 
    {
	return resultSet().getFetchDirection();
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public int getFetchSize()
	throws SQLException 
    {
	return resultSet().getFetchSize();
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public ResultSetMetaData getMetaData()
	throws SQLException
    {
	return resultSet().getMetaData();
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public int getRow()
	throws SQLException 
    {
	return resultSet().getRow();
    }

    /**
     * ResultSetWrapperStatementWrapper(sub class)ᤷޤ
     *
     * @return	ResultSetWrapperStatementWrapper(sub class)
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public Statement getStatement()
	throws SQLException
    {
	return (Statement) stmtRef.get();
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public int getType()
	throws SQLException 
    {
	return resultSet().getType();
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public SQLWarning getWarnings()
	throws SQLException
    {
	return resultSet().getWarnings();
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public void insertRow()
	throws SQLException
    {
	resultSet().insertRow();
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public boolean isAfterLast()
	throws SQLException
    {
	return resultSet().isAfterLast();
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public boolean isBeforeFirst()
	throws SQLException
    {
	return resultSet().isBeforeFirst();
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public boolean isFirst()
	throws SQLException
    {
	return resultSet().isFirst();
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public boolean isLast()
	throws SQLException
    {
	return resultSet().isLast();
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public boolean last()
	throws SQLException
    {
	return resultSet().last();
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public void moveToCurrentRow()
	throws SQLException
    {
	resultSet().moveToCurrentRow();
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public void moveToInsertRow()
	throws SQLException
    {
	resultSet().moveToInsertRow();
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public boolean next()
	throws SQLException
    {
	return resultSet().next();
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public boolean previous()
	throws SQLException
    {
	return resultSet().previous();
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public void refreshRow()
	throws SQLException
    {
	resultSet().refreshRow();
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	rows
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public boolean relative(int rows)
	throws SQLException 
    {
	return resultSet().relative(rows);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public boolean rowDeleted()
	throws SQLException
    {
	return resultSet().rowDeleted();
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public boolean rowInserted()
	throws SQLException
    {
	return resultSet().rowInserted();
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public boolean rowUpdated()
	throws SQLException
    {
	return resultSet().rowUpdated();
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	direction
     *		Wrap줿JDBC ResultSetؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public void setFetchDirection(int direction)
	throws SQLException
    {
	resultSet().setFetchDirection(direction);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	size
     *		Wrap줿JDBC ResultSetؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public void setFetchSize(int size)
	throws SQLException
    {
	resultSet().setFetchSize(size);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public void updateRow()
	throws SQLException
    {
	resultSet().updateRow();
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	index
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public Array getArray(int index)
	throws SQLException
    {
	return resultSet().getArray(index);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	name
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public Array getArray(String name)
	throws SQLException 
    {
	return resultSet().getArray(name);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	index
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public InputStream getAsciiStream(int index)
	throws SQLException 
    {
	return resultSet().getAsciiStream(index);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	name
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public InputStream getAsciiStream(String name)
	throws SQLException
    {
	return resultSet().getAsciiStream(name);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	index
     *		Wrap줿JDBC ResultSetؤΰ
     * @param	val
     *		Wrap줿JDBC ResultSetؤΰ
     * @param	length
     *		Wrap줿JDBC ResultSetؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public void updateAsciiStream(int         index,
				  InputStream val,
				  int         length)
	throws SQLException
    {
	resultSet().updateAsciiStream(index, val, length);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	name
     *		Wrap줿JDBC ResultSetؤΰ
     * @param	val
     *		Wrap줿JDBC ResultSetؤΰ
     * @param	length
     *		Wrap줿JDBC ResultSetؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public void updateAsciiStream(String      name,
				  InputStream val,
				  int         length)
	throws SQLException
    {
	resultSet().updateAsciiStream(name, val, length);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	index
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public InputStream getBinaryStream(int index)
	throws SQLException
    {
	return resultSet().getBinaryStream(index);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	name
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public InputStream getBinaryStream(String name)
	throws SQLException
    {
	return resultSet().getBinaryStream(name);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	index
     *		Wrap줿JDBC ResultSetؤΰ
     * @param	val
     *		Wrap줿JDBC ResultSetؤΰ
     * @param	length
     *		Wrap줿JDBC ResultSetؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public void updateBinaryStream(int         index,
				   InputStream val,
				   int         length)
	throws SQLException
    {
	resultSet().updateBinaryStream(index, val, length);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	name
     *		Wrap줿JDBC ResultSetؤΰ
     * @param	val
     *		Wrap줿JDBC ResultSetؤΰ
     * @param	length
     *		Wrap줿JDBC ResultSetؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public void updateBinaryStream(String      name,
				   InputStream val,
				   int         length)
	throws SQLException
    {
	resultSet().updateBinaryStream(name, val, length);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	index
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public BigDecimal getBigDecimal(int index)
	throws SQLException
    {
	return resultSet().getBigDecimal(index);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	name
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public BigDecimal getBigDecimal(String name)
	throws SQLException
    {
	return resultSet().getBigDecimal(name);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	index
     *		Wrap줿JDBC ResultSetؤΰ
     * @param	scale
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public BigDecimal getBigDecimal(int index,
				    int scale)
	throws SQLException
    {
	return resultSet().getBigDecimal(index, scale);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	name
     *		Wrap줿JDBC ResultSetؤΰ
     * @param	scale
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public BigDecimal getBigDecimal(String name,
				    int    scale)
	throws SQLException
    {
	return resultSet().getBigDecimal(name, scale);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	index
     *		Wrap줿JDBC ResultSetؤΰ
     * @param	val
     *		Wrap줿JDBC ResultSetؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public void updateBigDecimal(int        index,
				 BigDecimal val)
	throws SQLException
    {
	resultSet().updateBigDecimal(index, val);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	name
     *		Wrap줿JDBC ResultSetؤΰ
     * @param	val
     *		Wrap줿JDBC ResultSetؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public void updateBigDecimal(String     name,
				 BigDecimal val)
	throws SQLException
    {
	resultSet().updateBigDecimal(name, val);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	index
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public Blob getBlob(int index)
	throws SQLException
    {
	return resultSet().getBlob(index);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	name
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public Blob getBlob(String name)
	throws SQLException
    {
	return resultSet().getBlob(name);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	index
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public boolean getBoolean(int index)
	throws SQLException
    {
	return resultSet().getBoolean(index);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	name
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public boolean getBoolean(String name)
	throws SQLException
    {
	return resultSet().getBoolean(name);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	index
     *		Wrap줿JDBC ResultSetؤΰ
     * @param	val
     *		Wrap줿JDBC ResultSetؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public void updateBoolean(int     index,
			      boolean val)
	throws SQLException
    {
	resultSet().updateBoolean(index, val);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	name
     *		Wrap줿JDBC ResultSetؤΰ
     * @param	val
     *		Wrap줿JDBC ResultSetؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public void updateBoolean(String  name,
			      boolean val)
	throws SQLException
    {
	resultSet().updateBoolean(name, val);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	index
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public byte getByte(int index)
	throws SQLException
    {
	return resultSet().getByte(index);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	name
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public byte getByte(String name)
	throws SQLException
    {
	return resultSet().getByte(name);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	index
     *		Wrap줿JDBC ResultSetؤΰ
     * @param	val
     *		Wrap줿JDBC ResultSetؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public void updateByte(int  index,
			   byte val)
	throws SQLException
    {
	resultSet().updateByte(index, val);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	name
     *		Wrap줿JDBC ResultSetؤΰ
     * @param	val
     *		Wrap줿JDBC ResultSetؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public void updateByte(String name,
			   byte   val)
	throws SQLException
    {
	resultSet().updateByte(name, val);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	index
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public byte[] getBytes(int index)
	throws SQLException
    {
	return resultSet().getBytes(index);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	name
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public byte[] getBytes(String name)
	throws SQLException
    {
	return resultSet().getBytes(name);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	index
     *		Wrap줿JDBC ResultSetؤΰ
     * @param	val
     *		Wrap줿JDBC ResultSetؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public void updateBytes(int    index,
			    byte[] val)
	throws SQLException
    {
	resultSet().updateBytes(index, val);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	name
     *		Wrap줿JDBC ResultSetؤΰ
     * @param	val
     *		Wrap줿JDBC ResultSetؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public void updateBytes(String name,
			    byte[] val)
	throws SQLException
    {
	resultSet().updateBytes(name, val);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	index
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public Reader getCharacterStream(int index)
	throws SQLException
    {
	return resultSet().getCharacterStream(index);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	name
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public Reader getCharacterStream(String name)
	throws SQLException
    {
	return resultSet().getCharacterStream(name);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	index
     *		Wrap줿JDBC ResultSetؤΰ
     * @param	reader
     *		Wrap줿JDBC ResultSetؤΰ
     * @param	length
     *		Wrap줿JDBC ResultSetؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public void updateCharacterStream(int    index,
				      Reader reader,
				      int    length)
	throws SQLException
    {
	resultSet().updateCharacterStream(index, reader, length);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	name
     *		Wrap줿JDBC ResultSetؤΰ
     * @param	reader
     *		Wrap줿JDBC ResultSetؤΰ
     * @param	length
     *		Wrap줿JDBC ResultSetؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public void updateCharacterStream(String name,
				      Reader reader,
				      int    length)
	throws SQLException
    {
	resultSet().updateCharacterStream(name, reader, length);
    }
 
    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	index
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public Clob getClob(int index)
	throws SQLException
    {
	return resultSet().getClob(index);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	name
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public Clob getClob(String name)
	throws SQLException 
    {
	return resultSet().getClob(name);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	index
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public Date getDate(int index)
	throws SQLException
    {
	return resultSet().getDate(index);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	name
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public Date getDate(String name)
	throws SQLException
    {
	return resultSet().getDate(name);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	index
     *		Wrap줿JDBC ResultSetؤΰ
     * @param	cal
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public Date getDate(int      index,
			Calendar cal)
	throws SQLException
    {
	return resultSet().getDate(index, cal);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	name
     *		Wrap줿JDBC ResultSetؤΰ
     * @param	cal
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public Date getDate(String   name,
			Calendar cal)
	throws SQLException
    {
	return resultSet().getDate(name, cal);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	index
     *		Wrap줿JDBC ResultSetؤΰ
     * @param	val
     *		Wrap줿JDBC ResultSetؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public void updateDate(int  index,
			   Date val)
	throws SQLException
    {
	resultSet().updateDate(index, val);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	name
     *		Wrap줿JDBC ResultSetؤΰ
     * @param	val
     *		Wrap줿JDBC ResultSetؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public void updateDate(String name,
			   Date   val)
	throws SQLException
    {
	resultSet().updateDate(name, val);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	index
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public double getDouble(int index)
	throws SQLException
    {
	return resultSet().getDouble(index);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	name
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public double getDouble(String name)
	throws SQLException
    {
	return resultSet().getDouble(name);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	index
     *		Wrap줿JDBC ResultSetؤΰ
     * @param	val
     *		Wrap줿JDBC ResultSetؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public void updateDouble(int    index,
			     double val)
	throws SQLException
    {
	resultSet().updateDouble(index, val);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	name
     *		Wrap줿JDBC ResultSetؤΰ
     * @param	val
     *		Wrap줿JDBC ResultSetؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public void updateDouble(String name,
			     double val)
	throws SQLException
    {
	resultSet().updateDouble(name, val);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	index
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public float getFloat(int index)
	throws SQLException
    {
	return resultSet().getFloat(index);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	name
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public float getFloat(String name)
	throws SQLException
    {
	return resultSet().getFloat(name);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	index
     *		Wrap줿JDBC ResultSetؤΰ
     * @param	val
     *		Wrap줿JDBC ResultSetؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public void updateFloat(int   index,
			    float val)
	throws SQLException
    {
	resultSet().updateFloat(index, val);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	name
     *		Wrap줿JDBC ResultSetؤΰ
     * @param	val
     *		Wrap줿JDBC ResultSetؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public void updateFloat(String name,
			    float  val)
	throws SQLException
    {
	resultSet().updateFloat(name, val);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	index
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public int getInt(int index)
	throws SQLException
    {
	return resultSet().getInt(index);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	name
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public int getInt(String name)
	throws SQLException
    {
	return resultSet().getInt(name);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	index
     *		Wrap줿JDBC ResultSetؤΰ
     * @param	val
     *		Wrap줿JDBC ResultSetؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public void updateInt(int index,
			  int val)
	throws SQLException
    {
	resultSet().updateInt(index, val);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	name
     *		Wrap줿JDBC ResultSetؤΰ
     * @param	val
     *		Wrap줿JDBC ResultSetؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public void updateInt(String name,
			  int    val)
	throws SQLException
    {
	resultSet().updateInt(name, val);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	index
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public long getLong(int index)
	throws SQLException
    {
	return resultSet().getLong(index);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	name
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public long getLong(String name)
	throws SQLException
    {
	return resultSet().getLong(name);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	index
     *		Wrap줿JDBC ResultSetؤΰ
     * @param	val
     *		Wrap줿JDBC ResultSetؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public void updateLong(int  index,
			   long val)
	throws SQLException
    {
	resultSet().updateLong(index, val);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	name
     *		Wrap줿JDBC ResultSetؤΰ
     * @param	val
     *		Wrap줿JDBC ResultSetؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public void updateLong(String  name,
			   long val)
	throws SQLException
    {
	resultSet().updateLong(name, val);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	index
     *		Wrap줿JDBC ResultSetؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public void updateNull(int  index)
	throws SQLException
    {
	resultSet().updateNull(index);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	name
     *		Wrap줿JDBC ResultSetؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public void updateNull(String  name)
	throws SQLException 
    {
	resultSet().updateNull(name);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	index
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public Object getObject(int index)
	throws SQLException
    {
	return resultSet().getObject(index);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	name
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public Object getObject(String name)
	throws SQLException
    {
	return resultSet().getObject(name);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	index
     *		Wrap줿JDBC ResultSetؤΰ
     * @param	map
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public Object getObject(int index,
			    Map map)
	throws SQLException
    {
	return resultSet().getObject(index, map);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	name
     *		Wrap줿JDBC ResultSetؤΰ
     * @param	map
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public Object getObject(String name,
			    Map    map)
	throws SQLException
    {
	return resultSet().getObject(name, map);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	index
     *		Wrap줿JDBC ResultSetؤΰ
     * @param	val
     *		Wrap줿JDBC ResultSetؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public void updateObject(int    index,
			     Object val)
	throws SQLException
    {
	resultSet().updateObject(index, val);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	name
     *		Wrap줿JDBC ResultSetؤΰ
     * @param	val
     *		Wrap줿JDBC ResultSetؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public void updateObject(String name,
			     Object val)
	throws SQLException
    {
	resultSet().updateObject(name, val);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	index
     *		Wrap줿JDBC ResultSetؤΰ
     * @param	val
     *		Wrap줿JDBC ResultSetؤΰ
     * @param	scale
     *		Wrap줿JDBC ResultSetؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public void updateObject(int    index,
			     Object val,
			     int    scale)
	throws SQLException
    {
	resultSet().updateObject(index, val, scale);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	name
     *		Wrap줿JDBC ResultSetؤΰ
     * @param	val
     *		Wrap줿JDBC ResultSetؤΰ
     * @param	scale
     *		Wrap줿JDBC ResultSetؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public void updateObject(String name,
			     Object val,
			     int    scale)
	throws SQLException
    {
	resultSet().updateObject(name, val, scale);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	index
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public Ref getRef(int index)
	throws SQLException
    {
	return resultSet().getRef(index);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	name
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public Ref getRef(String name)
	throws SQLException
    {
	return resultSet().getRef(name);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	index
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public short getShort(int index)
	throws SQLException
    {
	return resultSet().getShort(index);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	name
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public short getShort(String name)
	throws SQLException
    {
	return resultSet().getShort(name);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	index
     *		Wrap줿JDBC ResultSetؤΰ
     * @param	val
     *		Wrap줿JDBC ResultSetؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public void updateShort(int   index,
			    short val)
	throws SQLException
    {
	resultSet().updateShort(index, val);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	name
     *		Wrap줿JDBC ResultSetؤΰ
     * @param	val
     *		Wrap줿JDBC ResultSetؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public void updateShort(String name,
			    short  val)
	throws SQLException
    {
	resultSet().updateShort(name, val);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	index
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public String getString(int index)
	throws SQLException
    {
	return resultSet().getString(index);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	name
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public String getString(String name)
	throws SQLException 
    {
	return resultSet().getString(name);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	index
     *		Wrap줿JDBC ResultSetؤΰ
     * @param	val
     *		Wrap줿JDBC ResultSetؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public void updateString(int    index,
			     String val)
	throws SQLException 
    {
	resultSet().updateString(index, val);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	name
     *		Wrap줿JDBC ResultSetؤΰ
     * @param	val
     *		Wrap줿JDBC ResultSetؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public void updateString(String name,
			     String val)
	throws SQLException 
    {
	resultSet().updateString(name, val);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	index
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public Time getTime(int index)
	throws SQLException 
    {
	return resultSet().getTime(index);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	name
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public Time getTime(String name)
	throws SQLException 
    {
	return resultSet().getTime(name);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	index
     *		Wrap줿JDBC ResultSetؤΰ
     * @param	cal
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public Time getTime(int      index,
			Calendar cal)
	throws SQLException
    {
	return resultSet().getTime(index, cal);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	name
     *		Wrap줿JDBC ResultSetؤΰ
     * @param	cal
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public Time getTime(String   name,
			Calendar cal)
	throws SQLException
    {
	return resultSet().getTime(name, cal);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	index
     *		Wrap줿JDBC ResultSetؤΰ
     * @param	val
     *		Wrap줿JDBC ResultSetؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public void updateTime(int  index,
			   Time val)
	throws SQLException
    {
	resultSet().updateTime(index, val);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	name
     *		Wrap줿JDBC ResultSetؤΰ
     * @param	val
     *		Wrap줿JDBC ResultSetؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public void updateTime(String name,
			   Time   val)
	throws SQLException
    {
	resultSet().updateTime(name, val);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	index
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public Timestamp getTimestamp(int index)
	throws SQLException
    {
	return resultSet().getTimestamp(index);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	name
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public Timestamp getTimestamp(String name)
	throws SQLException
    {
	return resultSet().getTimestamp(name);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	index
     *		Wrap줿JDBC ResultSetؤΰ
     * @param	cal
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public Timestamp getTimestamp(int      index,
				  Calendar cal)
	throws SQLException
    {
	return resultSet().getTimestamp(index, cal);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	name
     *		Wrap줿JDBC ResultSetؤΰ
     * @param	cal
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public Timestamp getTimestamp(String   name,
				  Calendar cal)
	throws SQLException
    {
	return resultSet().getTimestamp(name, cal);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	index
     *		Wrap줿JDBC ResultSetؤΰ
     * @param	val
     *		Wrap줿JDBC ResultSetؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public void updateTimestamp(int       index,
				Timestamp val)
	throws SQLException
    {
	resultSet().updateTimestamp(index, val);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	name
     *		Wrap줿JDBC ResultSetؤΰ
     * @param	val
     *		Wrap줿JDBC ResultSetؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public void updateTimestamp(String    name,
				Timestamp val)
	throws SQLException
    {
	resultSet().updateTimestamp(name, val);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	index
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public InputStream getUnicodeStream(int index)
	throws SQLException
    {
	return resultSet().getUnicodeStream(index);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	name
     *		Wrap줿JDBC ResultSetؤΰ
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public InputStream getUnicodeStream(String name)
	throws SQLException
    {
	return resultSet().getUnicodeStream(name);
    }

    /**
     * Wrap줿JDBC ResultSetƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @return	Wrap줿JDBC ResultSet줿
     * @throws	SQLException
     *		Wrap줿JDBC ResultSetthrow
     */
    public boolean wasNull()
	throws SQLException
    {
	return resultSet().wasNull();
    }
}
