/*
 * $Id: StatementWrapper.java,v 1.1.1.1 2002/12/10 09:18:13 mitsuhito Exp $
 */


package jp.livewell.baby.pool.jdbc;


import java.lang.ref.WeakReference;
import java.sql.Statement;
import java.sql.Connection;
import java.sql.SQLWarning;
import java.sql.SQLException;
import java.sql.ResultSet;

import jp.livewell.baby.pool.AbstractWrapper;
import jp.livewell.baby.pool.ComparisonKey;


/**
 * java.sql.Statement interfaceimplementsStatement˻ѤǤ
 * Wrapper classǤ
 *
 * @author mitsuhito
 */
class StatementWrapper
    extends AbstractWrapper
    implements Statement
{
    // attributes ------------------------------------------------------------
    /** ºݤJDBC StatementǤ */
    private Statement stmt;

    /** ʬȤؤλȤǤ */
    private WeakReference ownRef;

    /** ConnectionWrapperؤμ廲 */
    private WeakReference connRef;

    /** ߳ƤResultSet */
    private ResultSet current = null;


    // constructors ----------------------------------------------------------
    /**
     * StatementWrapinstanceۤޤ
     *
     * @param	stmt
     *		WrapJDBC Statement instance
     * @param	connRef
     *		WrapperConnectionWrapperؤμ廲
     * @throws	IllegalArgumentException
     *		stmtnullꤷ褦Ȥ硣
     *		connRefnullꤷ褦Ȥ硣
     *		connRefλȤJDBC ConnectionǤ̵硣
     */
    StatementWrapper(Statement stmt,
		     WeakReference connRef)
	throws IllegalArgumentException
    {
	if ((stmt != null) && (connRef != null)) {
	    if (connRef.get() instanceof Connection) {
		this.stmt	= stmt;
		this.connRef	= connRef;
		ownRef		= new WeakReference(this);
	    } else {
		throw new IllegalArgumentException
		    ("need java.sql.Connection reference!");
	    }
	} else {
	    throw new IllegalArgumentException
		("please check params.\n"
		 + "stmt = " + stmt + "\n"
		 + "connRef = " + connRef + "\n");
	}
	activate(getComparisonKey());
    }
		     

    // over rides -------------------------------------------------------------
    /**
     * Wrapper˳ǼƤJDBC StatementcloseƤΥ꥽
     * ƻԲĤˤޤ
     */
    public synchronized void destroy(ComparisonKey key)
    {
	try {
	    super.destroy(key);
	    if (current != null) {
		current.close();
	    }

	    if (stmt != null) {
		stmt.close();
	    }
	} catch (Exception e) {
	    // do nothing
	} finally {
	    //stmt	= null;
	    current	= null;
	    connRef	= null;
	    ownRef	= null;
	}
    }

    /**
     * trueᤷޤ
     *
     * @return	true
     */
    protected boolean ping()
    {
	return true;
    }


    // accessor ---------------------------------------------------------------
    /**
     * raw JDBC Statementᤷޤ
     *
     * @return	raw JDBC Statement
     */
    protected Statement statement()
    {
	return stmt;
    }

    /**
     * ʬȤؤμ廲ȤᤷޤinstanceϡֶͭפΤФ
     * clearƤӽФʤǲ
     *
     * @return	ʬȤؤμ廲
     */
    protected WeakReference ownReference()
    {
	return ownRef;
    }

    /**
     * ResultSet򸽺ߤStatementResultSetꤷޤ
     * ˳ResultSet¸ߤФResultSetĤޤ
     *
     * @param	res
     *		ResultSet
     */
    protected void setCurrentResultSet(ResultSet res)
    {
	if (res != null) {
	    if (current != null) {
		try {
		    current.close();
		} catch (SQLException e) {
		    // do nothing
		}
	    }
	    current = res;
	}
    }


    // Statement implementation & helpers -------------------------------------
    /**
     * Wrap줿JDBC StatementƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	sql
     *		Wrap줿JDBC Connectionؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC Statementthrow
     */
    public void addBatch(String sql)
	throws SQLException 
    {
	statement().addBatch(sql);
    }

    /**
     * Wrap줿JDBC StatementƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @throws	SQLException
     *		Wrap줿JDBC Statementthrow
     */
    public void cancel()
	throws SQLException 
    {
	statement().cancel();
    }

    /**
     * Wrap줿JDBC StatementƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @throws	SQLException
     *		Wrap줿JDBC Statementthrow
     */
    public void clearBatch()
	throws SQLException 
    {
	statement().clearBatch();
    }

    /**
     * Wrap줿JDBC StatementƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @throws	SQLException
     *		Wrap줿JDBC Statementthrow
     */
    public void clearWarnings()
	throws SQLException 
    {
	statement().clearWarnings();
    }

    /**
     * Wrap줿JDBC StatementƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @throws	SQLException
     *		Wrap줿JDBC Statementthrow
     */
    public void close()
	throws SQLException 
    {
	destroy(getComparisonKey());
    }

    /**
     * Wrap줿JDBC StatementƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	sql
     *		Wrap줿JDBC Statementؤΰ
     * @return	Wrap줿JDBC Statement줿
     * @throws	SQLException
     *		Wrap줿JDBC Statementthrow
     */
    public boolean execute(String sql)
	throws SQLException 
    {
	return statement().execute(sql);
    }

    /**
     * Wrap줿JDBC StatementƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @return	Wrap줿JDBC Statement줿
     * @throws	SQLException
     *		Wrap줿JDBC Statementthrow
     */
    public int[] executeBatch()
	throws SQLException 
    {
	return statement().executeBatch();
    }

    /**
     * Wrap줿JDBC StatementƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	sql
     *		Wrap줿JDBC Statementؤΰ
     * @return	Wrap줿JDBC Statement줿
     * @throws	SQLException
     *		Wrap줿JDBC Statementthrow
     */
    public ResultSet executeQuery(String sql)
	throws SQLException 
    {
	ResultSet res = new ResultSetWrapper
	    (statement().executeQuery(sql), ownReference());
	setCurrentResultSet(res);
	return res;
    }

    /**
     * Wrap줿JDBC StatementƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	sql
     *		Wrap줿JDBC Statementؤΰ
     * @return	Wrap줿JDBC Statement줿
     * @throws	SQLException
     *		Wrap줿JDBC Statementthrow
     */
    public int executeUpdate(String sql)
	throws SQLException 
    {
	return statement().executeUpdate(sql);
    }

    /**
     * Wrap줿JDBC StatementƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @return	Wrap줿JDBC Connection
     * @throws	SQLException
     *		Wrap줿JDBC Statementthrow
     */
    public Connection getConnection()
	throws SQLException 
    {
	return (Connection) connRef.get();
    }

    /**
     * Wrap줿JDBC StatementƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @return	Wrap줿JDBC Statement줿
     * @throws	SQLException
     *		Wrap줿JDBC Statementthrow
     */
    public int getFetchSize()
	throws SQLException 
    {
	return statement().getFetchSize();
    }
 
    /**
     * Wrap줿JDBC StatementƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @return	Wrap줿JDBC Statement줿
     * @throws	SQLException
     *		Wrap줿JDBC Statementthrow
     */
    public int getFetchDirection()
	throws SQLException 
    {
	return statement().getFetchDirection();
    }

    /**
     * Wrap줿JDBC StatementƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @return	Wrap줿JDBC Statement줿
     * @throws	SQLException
     *		Wrap줿JDBC Statementthrow
     */
    public int getMaxFieldSize()
	throws SQLException 
    {
	return statement().getMaxFieldSize();
    }

    /**
     * Wrap줿JDBC StatementƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @return	Wrap줿JDBC Statement줿
     * @throws	SQLException
     *		Wrap줿JDBC Statementthrow
     */
    public int getMaxRows()
	throws SQLException 
    {
	return statement().getMaxRows();
    }

    /**
     * Wrap줿JDBC StatementƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @return	Wrap줿JDBC Statement줿
     * @throws	SQLException
     *		Wrap줿JDBC Statementthrow
     */
    public boolean getMoreResults()
	throws SQLException 
    {
	return statement().getMoreResults();
    }

    /**
     * Wrap줿JDBC StatementƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @return	Wrap줿JDBC Statement줿
     * @throws	SQLException
     *		Wrap줿JDBC Statementthrow
     */
    public int getQueryTimeout()
	throws SQLException 
    {
	return statement().getQueryTimeout();
    }

    /**
     * Wrap줿JDBC StatementƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @return	Wrap줿JDBC Statement줿
     * @throws	SQLException
     *		Wrap줿JDBC Statementthrow
     */
    public int getResultSetConcurrency()
	throws SQLException 
    {
	return statement().getResultSetConcurrency();
    }

    /**
     * Wrap줿JDBC StatementƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @return	Wrap줿JDBC Statement줿
     * @throws	SQLException
     *		Wrap줿JDBC Statementthrow
     */
    public ResultSet getResultSet()
	throws SQLException 
    {
	ResultSet res = new ResultSetWrapper
	    (statement().getResultSet(), ownReference());
	setCurrentResultSet(res);
	return res;
    }

    /**
     * Wrap줿JDBC StatementƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @return	Wrap줿JDBC Statement줿
     * @throws	SQLException
     *		Wrap줿JDBC Statementthrow
     */
    public int getUpdateCount()
	throws SQLException 
    {
	return statement().getUpdateCount();
    }

    /**
     * Wrap줿JDBC StatementƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @return	Wrap줿JDBC Statement줿
     * @throws	SQLException
     *		Wrap줿JDBC Statementthrow
     */
    public int getResultSetType()
	throws SQLException 
    {
	return statement().getResultSetType();
    }

    /**
     * Wrap줿JDBC StatementƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @return	Wrap줿JDBC Statement줿
     * @throws	SQLException
     *		Wrap줿JDBC Statementthrow
     */
    public SQLWarning getWarnings()
	throws SQLException 
    {
	return statement().getWarnings();
    }

    /**
     * Wrap줿JDBC StatementƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	name
     *		Wrap줿JDBC Statementؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC Statementthrow
     */
    public void setCursorName(String name)
	throws SQLException 
    {
	statement().setCursorName(name);
    }

    /**
     * Wrap줿JDBC StatementƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	enable
     *		Wrap줿JDBC Statementؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC Statementthrow
     */
    public void setEscapeProcessing(boolean enable)
	throws SQLException 
    {
	statement().setEscapeProcessing(enable);
    }

    /**
     * Wrap줿JDBC StatementƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	direction
     *		Wrap줿JDBC Statementؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC Statementthrow
     */
    public void setFetchDirection(int direction)
	throws SQLException 
    {
	statement().setFetchDirection(direction);
    }

    /**
     * Wrap줿JDBC StatementƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	rows
     *		Wrap줿JDBC Statementؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC Statementthrow
     */
    public void setFetchSize(int rows)
	throws SQLException 
    {
	statement().setFetchSize(rows);
    }

    /**
     * Wrap줿JDBC StatementƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	max
     *		Wrap줿JDBC Statementؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC Statementthrow
     */
    public void setMaxFieldSize(int max)
	throws SQLException 
    {
	statement().setMaxFieldSize(max);
    }

    /**
     * Wrap줿JDBC StatementƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	max
     *		Wrap줿JDBC Statementؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC Statementthrow
     */
    public void setMaxRows(int max)
	throws SQLException 
    {
	statement().setMaxRows(max);
    }

    /**
     * Wrap줿JDBC StatementƱ쥷ͥ᥽åɤ׵žޤ
     *
     * @param	seconds
     *		Wrap줿JDBC Statementؤΰ
     * @throws	SQLException
     *		Wrap줿JDBC Statementthrow
     */
    public void setQueryTimeout(int seconds)
	throws SQLException 
    {
	statement().setQueryTimeout(seconds);
    }
}
