/*
 * $Id: XmlLoader.java,v 1.1.1.1 2002/12/10 09:18:13 mitsuhito Exp $
 */


package jp.livewell.baby.pool.jdbc;


import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;


/**
 * babyPool.xml fileConnectionPoolInfoޤ
 *
 * @author mitsuhtio
 */
class XmlLoader
    extends ConnectionPoolInfoLoader
{
    // tag names --------------------------------------------------------------
    /** babyPoolϤtag˵Ҥޤͤ[baby-pool]Ǥ*/
    public static final String TAG_BABY_POOL = "baby-pool";

    /** ConnectionPoolϤtag˵Ҥޤͤ[connection-pool]
	Ǥ*/
    public static final String TAG_CONNECTION_POOL = "connection-pool";

    /** ĥץѥƥ̾ɽ°̾Ǥ(ԤǤ) extention tag
	ߤǻѤޤ*/
    public static final String ATTR_KEY = "key";


    // constructors & init ----------------------------------------------------
    /**
     * ͣΥǥեȥ󥹥ȥ饯
     */
    XmlLoader()
    {
	// do nothing
    }


    // over rides -------------------------------------------------------------
    /**
     * getFullName򥪡С饤ɤޤ
     * ClassLoaderǤ̾ޤ
     * 
     * @return	ResourceBundleǤ̾
     */
    String getFullName()
    {
	return '/' + super.getFullName().replace('.', '/') + ".xml";
    }

    /**
     * babyPool.xml fileξͿ줿path˸դ
     * true򡢸դʤfalse֤ޤ
     * ƤʤIllegalStateExceptionthrowޤ
     *
     * @return	׵᤹꥽դtrueʳfalse
     * @throws	IllegalStateException
     *		Ƥʤ
     */
    boolean isFoundResource()
	throws IllegalStateException
    {
	return (getClass().getResource(getFullName()) != null);
    }

    /**
     * ConnectionPoolnfoLoader#parseResource򥪡С饤ɤޤ
     * Properties fileɤ߹ǡMapkeyvalueǲϷ̤դޤ
     *
     * @return	Ϸ̤MapLoader̾1ĤMap֤ޤ
     * @throws	Exception
     *		ConnectionPoolInfoLoaderԤ꥽˥
     *		äȤ
     *		Ƥʤ
     */
    protected Map[] parseResource()
	throws Exception
    {
	Element babyPool; // as first finding babyPool tag.
	{
	    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
	    DocumentBuilder	   db  = dbf.newDocumentBuilder();

	    InputSource source;
	    {
		InputStream is = getClass().getResourceAsStream(getFullName());
		source = new InputSource(is);
	    }
	    Document root = db.parse(source);
	    NodeList list = root.getElementsByTagName(TAG_BABY_POOL);
	    
	    if (list.getLength() > 0) {
		babyPool = (Element) list.item(0); // 1file1nodeʾ̵
	    } else {
		babyPool = root.createElement(TAG_BABY_POOL);
	    }
	}

	Set parseds = new HashSet(); // next step, loop and parse pool tag.
	{
	    Node pool = babyPool.getFirstChild();
	    while (pool != null) {

		if (pool.getNodeType() == Node.ELEMENT_NODE 
		    && pool.getNodeName().equals(TAG_CONNECTION_POOL)) {

		    parseds.add(parsePool((Element) pool));
		}
		pool = pool.getNextSibling();
	    }
	}
	return (Map[]) parseds.toArray(new Map[0]);
    }

    /**
     * TAG_CONNECTION_POOLElementϤMapη֤ޤ
     *
     * @param	pool
     *		TAG_CONNECTION_POOLElement
     * @return	ϤͤǼMap
     */
    private Map parsePool(Element pool)
    {
	Map parsed = new HashMap();
	{
	    Node prop = pool.getFirstChild();
	    while (prop != null) {
		if (prop.getNodeType() == Node.ELEMENT_NODE) {
		    Node val = prop.getFirstChild();

		    while (val != null) {
			if (val.getNodeType() == Node.TEXT_NODE) {
			    parsed.put(keyToMethodName((Element) prop),
				       val.getNodeValue().trim());
			    break;
			} else {
			    val = val.getNextSibling();
			}
		    }
		}
		prop = prop.getNextSibling();
	    }
	}
	return parsed;
    }

    /**
     * xml tag̾'-'ϢʸޤbabyPoolxmlǤϡ
     * maxSizemax-sizeȽ񤫤ޤϻˤtag name
     * ConnecitonPoolInfoΥ᥽å̾˷ӤĤƹͤ뤿ᡢʸ
     * ƤɬפޤޤĥץѥƥxmlǤɽ
     * extention key="XXX" ȤʤޤΤǡkey attributeäƤΤߡ
     * attribute᤹ɬפޤ
     *
     * @param	prop
     *		ƥץѥƥɽxml node
     * @return	ConnectionPoolInfosetXXX ᥽åɤXXX̾
     */
    private String keyToMethodName(Element prop)
    {
	StringBuffer buf = new StringBuffer();
	{
	    char[] str = prop.getNodeName().toCharArray();
	    for (int i = 0; i < str.length; i++) {
		if (str[i] != '-') {
		    buf.append(str[i]);
		}
	    }

	    if (prop.hasAttribute(ATTR_KEY)) {
		buf.append('.').append(prop.getAttribute(ATTR_KEY));
	    }
	}
	return buf.toString();
    }
}
