/*
 * test for DefaultPool
 * $Id: DefaultPoolTest.java,v 1.1.1.1 2002/12/10 09:18:13 mitsuhito Exp $
 */

package jp.livewell.baby.pool;


import junit.framework.TestCase;
import jp.livewell.baby.pool.jdbc.ConnectionFactory;
import jp.livewell.baby.pool.jdbc.ConnectionFactoryTest;


/**
 * DefaultPool classƥȤޤ
 *
 * @author mitsuhito
 */
public class DefaultPoolTest
    extends TestCase
{
    // main -------------------------------------------------------------------
    /**
     * test by unit
     * 
     * @param	args
     *		do nothing
     */
    public static void main(String[] args)
    {
	junit.textui.TestRunner.run(DefaultPoolTest.class);
    }


    // share DefaultPool ------------------------------------------------------
    /**
     * μ¤˻ѤǤʬäƤDefaultPoolᤷޤ
     * ¾ΥƥȥǤѤޤ
     *
     * @return	ѲǽDefaultPool
     */
    public static DefaultPool getAbsolute()
    {
	PoolInfo info = new PoolInfo();
	PoolInfoTest.setAbsolute(info);

	ConnectionFactory factory = ConnectionFactoryTest.getAbsolute();
	DefaultPool pl = null;

	try {
	    System.err.println(info);
	    pl = new DefaultPool(info, factory);
	} catch (Exception e) {
	    fail("create DefaultPool. chech PoolInfo, ConnectionFactory");
	}
	return pl;
    }


    // attributes -------------------------------------------------------------
    /** test target */
    private DefaultPool pool;


    // constructors & init ----------------------------------------------------
    /**
     * ƥȤۤޤ
     *
     * @param	name	test̾
     */
    public DefaultPoolTest(String name)
    {
	super(name);
    }

    /**
     * ɬפʥ꥽ξ֤狼ɤƥȤޤ
     *
     * @throws	Exception
     *		꥽ν˼Ԥ
     */
    public void setUp()
	throws Exception
    {
	setPool(getAbsolute());
    }

    /**
     * ƥȤǻѤPoolꤷޤ
     *
     * @param	pool
     *		ƥȤǻѤPool
     */
    protected void setPool(DefaultPool pool)
    {
	this.pool = pool;
    }

    
    // test methods -----------------------------------------------------------
    /**
     * PoolۻͤȿǤƤ뤫?
     */
    public void testPoolPropertiers()
    {
	PoolInfo inf = new PoolInfo();
	PoolInfoTest.setAbsolute(inf);
	Factory  fac = ConnectionFactoryTest.getAbsolute();

	DefaultPool pl = new DefaultPool(inf, fac);
	assertTrue("getName fail.",
		   pl.getName().equals(inf.getName()));
	assertTrue("getTimeout fail.",
		   pl.getTimeout() == inf.getTimeout());
	assertTrue("getMaxSize fail.",
		   pl.getMaxSize() == inf.getMaxSize());
	assertTrue("getMinSize fail.",
		   pl.getMinSize() == inf.getMinSize());
	assertTrue("getGrowPoint fail.",
		   pl.getGrowPoint() == inf.getGrowPoint());
	assertTrue("getShrinkPoint fail.",
		   pl.getShrinkPoint() == inf.getShrinkPoint());
	assertTrue("getMinCheckInterval fail.",
		   pl.getMinCheckInterval() == inf.getMinCheckInterval());
	assertTrue("getIdleCheckInterval fail.",
		   pl.getIdleCheckInterval() == inf.getIdleCheckInterval());
	assertTrue("getFactory fail.",
		   pl.getFactory() == fac);
    }
	
    /**
     * ˥ס뤵줿󥹥󥹤Ǥ뤫?
     */
    public void testTakeout()
    {
	Wrapper wrp = null;
	try {
	    wrp = pool.takeout();
	    System.out.println("total = " + pool.getTotalSize());
	    assertNotNull("why return null wrapper?", wrp);
	} catch (Exception e) {
	    fail("takeout failed!");
	} finally {
	    if (wrp != null) {
		wrp.release();
	    }
	}
    }

    /**
     * η׻ϤäƤ뤫?
     */
    public void _testGetTotalSize()
    {
	Wrapper[] wrps = new Wrapper[pool.getMaxSize()];
	try {
	    // maxޤǼƤߤ
	    for (int i = 0; i < pool.getMaxSize(); i++) {
		  wrps[i] = pool.takeout();
		  System.out.println
		      ("get wrapper success. count = " + (i + 1));
	    }
	    assertTrue("mismatch total.",
		       pool.getMaxSize() == pool.getTotalSize());
	    assertTrue("removed size is not max!",
		       pool.getRemovedSize() == pool.getMaxSize());
	} catch (TimeoutException e) {
	    fail("can't take sizeof max. timeout!");
	} finally {
	    // ٤˴Ƥߤ
	    for (int i = 0; i < wrps.length; i++) {
		pool.dispose(wrps[i]);
	    }
	}
	assertTrue("all wrapper disposed. why total != 0",
		   pool.getTotalSize() == 0);


	/* ϴĶˤäƤϼԤΤǡ˱ƥȥ
	   Ʋ */
	synchronized (this) {
	    try {
		wait(2000); // Ф餯Ԥä
	    } catch (InterruptedException e) {
		// do nothing
	    }
	}

	System.gc();
	assertTrue("minimum size is must keep.",
		   pool.getTotalSize() == pool.getMinSize());
	assertTrue("removed size is not 0!", pool.getRemovedSize() == 0);
    }

    /**
     * minSizeѹơȿǤ뤫?
     */
    public void testSetMinSize()
    {
	// wait pool blanced
	synchronized (this) {
	    try {
		wait(2000);
	    } catch (InterruptedException e) {
		// do nothing
	    }
	}
	int min = pool.getMinSize();
	System.out.println("current size is " + pool.getTotalSize());
	System.out.println("current min is " + min);
	pool.setMinSize(++min);

	assertTrue("set min but get min is not equal",
		   min == pool.getMinSize());

	// wait pool blanced
	synchronized (this) {
	    try {
		wait(2000);
	    } catch (InterruptedException e) {
		// do nothing
	    }
	}
	assertTrue("pool min size is not keeped!",
		   min == pool.getTotalSize());
	System.out.println("changed size is " + pool.getTotalSize());
	System.out.println("changed min is " + min);
    }
}
