/*
 * test for PoolInfo
 * $Id: PoolInfoTest.java,v 1.1.1.1 2002/12/10 09:18:13 mitsuhito Exp $
 */

package jp.livewell.baby.pool;


import junit.framework.TestCase;


/**
 * PoolInfo classƥȤޤ
 *
 * @author mitsuhito
 */
public class PoolInfoTest
    extends TestCase
{
    // main -------------------------------------------------------------------
    /**
     * test by unit
     * 
     * @param	args
     *		do nothing
     */
    public static void main(String[] args)
    {
	junit.textui.TestRunner.run(PoolInfoTest.class);
    }


    // share PoolInfo ---------------------------------------------------------
    /**
     * μ¤˹ۤǤʬäƤסᤷޤ
     * ¾ΥƥȥǤѤޤ
     *
     * @param	info
     *		Ԥʤinfo instance
     */
    public static void setAbsolute(PoolInfo info)
    {
	try {
	    info.setName(NAME);
	    info.setMaxSize(MAX);
	    info.setMinSize(MIN);
	    info.setTimeout(TIMEOUT);
	    info.setGrowPoint(GROW_POINT);
	    info.setShrinkPoint(SHRINK_POINT);
	    info.setMinCheckInterval(MIN_INTERVAL);
	    info.setIdleCheckInterval(IDLE_INTERVAL);
	} catch (Exception e) {
	    fail("check name, max, min, timeout, "
		 + "grow point, shrink point, "
		 + "min check interval, idle check interval");
	}
    }
	    

    // attributes -------------------------------------------------------------
    /** ס̾ */
    public static final String NAME = "testpool";

    /** 祵 > 0 */
    public static final int MAX = 10;

    /** Ǿ >= 0 */
    public static final int MIN = 1;

    /** ॢ >= 0 (ms) */
    public static final int TIMEOUT = 0;

    /** 󥹥󥹤ϤסλΨ */
    public static final float GROW_POINT = 0.70F;

    /** 󥹥󥹤˴ϤסλΨ */
    public static final float SHRINK_POINT = 0.30F;

    /** 󥹥󥹿åûֳִ(ms) */
    public static final int MIN_INTERVAL = 150;

    /** 󥹥󥹿å륢ɥλֳִ(ms) */
    public static final int IDLE_INTERVAL = 1200;

    /** ס */
    private PoolInfo info;

    

    // constructors & init ----------------------------------------------------
    /**
     * ƥȤۤޤ
     *
     * @param	name	test̾
     */
    public PoolInfoTest(String name)
    {
	super(name);
    }

    /**
     * ɬפʥ꥽ξ֤狼ɤƥȤޤ
     *
     * @throws	Exception
     *		꥽ν˼Ԥ
     */
    public void setUp()
	throws Exception
    {
	info = new PoolInfo();
	setAbsolute(info);
    }

    
    // method test ------------------------------------------------------------
    /**
     * ̾˼Ǥ뤫?
     */
    public void testGetName()
    {
	// same name?
	assertTrue("testGetName fail", info.getName().equals(NAME));
    }

    /**
     * ̾Ǥ뤫?
     * ѽʤʸꤷ顢IllegalArgumentExceptionthrow뤫?
     */
    public void testSetName()
    {
	// can set name?
	final String name = "otherName";
	info.setName(name);
	assertTrue("testSetName fail.", name.equals(info.getName()));

	// throw IllegalArgument?
	char[] illegals = 
	    {'!', '@', '#', '$', '%', '^', '&', '*', '(', ')', '=', '+',
	     '\\', '|', '`', '~', '[', '{', ']', '}', ';', ':', '\'', '"',
	     ',', '<', '.', '>', '/', '?'};
	for (int i = 0; i < illegals.length; i++) {
	    try {
		info.setName(illegals[i] + name);
		fail("testSetName fail. why can set illegal string "
		     + illegals[i] + ".");
	    } catch (IllegalArgumentException e) {
		// do nothing
	    }
	}
    }

    /**
     * 祵˼Ǥ뤫? 
     */
    public void testGetMaxSize()
    {
	// same max size?
	assertTrue("testGetMaxSize fail.", MAX == info.getMaxSize());
    }
	
    /**
     * 祵Ǥ뤫?
     * 0ʲꤷIllegalArgumentExceptionthrow뤫?
     */
    public void testSetMaxSize()
    {
	// can set maxSize?
	final int max = 100;
	info.setMaxSize(max);
	assertTrue("testSetMaxSize fail.", max == info.getMaxSize());

	// throw IllegalArgument case val =< 0?
	try {
	    info.setMaxSize(0);
	    fail("Oh! why can set 0 value to max size?");
	} catch (IllegalArgumentException e) {
	    // do nothing
	}
    }
	
    /**
     * Ǿ˼Ǥ뤫?
     */
    public void testGetMinSize()
    {
	// same min size?
	assertTrue("testGetMinSize fail.", MIN == info.getMinSize());
    }

    /**
     * ǾǤ뤫?
     * ΥꤷIlegalArgumentExceptionthrow뤫?
     */
    public void testSetMinSize()
    {
	// can set minSize?
	final int min = 10;
	info.setMinSize(min);
	assertTrue("testSetMinSize fail.", min == info.getMinSize());

	// throw IllegalArgument by minouse value?
	try {
	    info.setMinSize(-1);
	    fail("Oh! why can set minouse value to min size?");
	} catch (IllegalArgumentException e) {
	    // do nothing
	}
    }

    /**
     * ॢȤ˼Ǥ뤫?
     */
    public void testGetTimeout()
    {
	// same timeout size?
	assertTrue("testGetTimeOut fail.", TIMEOUT == info.getTimeout());
    }

    /**
     * ॢȤ뤫?
     */
    public void testSetTimeout()
    {
	// can set timeout?
	final int timeout = -1;
	info.setTimeout(timeout);
	assertTrue("testSetTimeout fail.", timeout == info.getTimeout());
    }

    /**
     * ˼Ǥ뤫
     */
    public void testGetShrinkPoint()
    {
	assertTrue("testGetShrinkPoint fail.",
		   SHRINK_POINT == info.getShrinkPoint());
    }

    /**
     * 뤫?
     * ϰϳͤꤷIllegalArgumentExceptionthrow뤫?
     */
    public void testSetShrinkPoint()
    {
	// can set shrink point?
	final float shrink = 0.90F;
	info.setShrinkPoint(shrink);
	assertTrue("testSetShrinkPoint fail.",
		   shrink == info.getShrinkPoint());
	
	// throw IllegalArgument by 0?
	try {
	    info.setShrinkPoint(0);
	    fail("Oh! why can set 0 to shrinkPoint?");
	} catch (IllegalArgumentException e) {
	    // do nothing
	}

	// throw IllegalArgument by 1?
	try {
	    info.setShrinkPoint(1);
	    fail("Oh! why can set 1 to shrinkPoint?");
	} catch (IllegalArgumentException e) {
	    // do nothing
	}
    }

    /**
     * û󥹥󥹿å֤˼Ǥ뤫?
     */
    public void testGetMinCheckInterval()
    {
	assertTrue("testGetMinInterval fail.",
		   MIN_INTERVAL == info.getMinCheckInterval());
    }

    /**
     * û󥹥󥹿å֤Ǥ뤫?
     * ϰϳͤꤷIllegalArgumentExceptionthrow뤫?
     */
    public void testSetMinCheckInterval()
    {
	// can set value?
	final int minInterval = 200;
	info.setMinCheckInterval(minInterval);
	assertTrue("testSetMinInterval fail.",
		   minInterval == info.getMinCheckInterval());
	
	// throw IllegalArgument by 0?
	try {
	    info.setMinCheckInterval(0);
	    fail("Oh! why can set 0 to minCheckInterval?");
	} catch (IllegalArgumentException e) {
	    // do nothing
	}

	// throw IllegalArgument by -1?
	try {
	    info.setMinCheckInterval(-1);
	    fail("Oh! why can set -1 to minCheckInterval?");
	} catch (IllegalArgumentException e) {
	    // do nothing
	}
    }

    /**
     * ɥ󥹥󥹿å֤˼Ǥ뤫?
     */
    public void testGetIdleCheckInterval()
    {
	assertTrue("testGetIdleInterval fail.",
		   IDLE_INTERVAL == info.getIdleCheckInterval());
    }

    /**
     * ɥ󥹥󥹿å֤Ǥ뤫?
     * ϰϳͤꤷIllegalArgumentExceptionthrow뤫?
     */
    public void testSetIdleCheckInterval()
    {
	// can set value?
	final int idleInterval = 200;
	info.setIdleCheckInterval(idleInterval);
	assertTrue("testSetIdleInterval fail.",
		   idleInterval == info.getIdleCheckInterval());
	
	// throw IllegalArgument by 0?
	try {
	    info.setIdleCheckInterval(0);
	    fail("Oh! why can set 0 to idleCheckInterval?");
	} catch (IllegalArgumentException e) {
	    // do nothing
	}

	// throw IllegalArgument by -1?
	try {
	    info.setIdleCheckInterval(-1);
	    fail("Oh! why can set -1 to idleCheckInterval?");
	} catch (IllegalArgumentException e) {
	    // do nothing
	}
    }

    /**
     * Ʊͤꤷ̤instanceequalsΩĤ?
     * 㤦ͤꤷ̤instanceequalsΩʤ?
     */
    public void testEquals()
    {
	PoolInfo otherInfo = null;
	{
	    otherInfo = (PoolInfo) info.clone();
	    assertTrue("testEquals fail.",
		       info.equals(otherInfo) && info != otherInfo);
	}
    }

    /**
     * cloneη̤Ʊ줫?
     */
    public void testClone()
    {
	PoolInfo cloneInfo = (PoolInfo) info.clone();
	assertTrue("fail clone", info.equals(cloneInfo));
    }
}
