/*
 * test for Queue
 * $Id: QueueTest.java,v 1.1.1.1 2002/12/10 09:18:13 mitsuhito Exp $
 */

package jp.livewell.baby.pool;


import junit.framework.TestCase;


/**
 *
 *
 * @author mitsuhito
 */
public class QueueTest
    extends TestCase
{
    // attributes -------------------------------------------------------------
    /** ͶConnectionο */
    private static final int SIZE = 100;

    /** test target */
    private Queue queue;


    // main -------------------------------------------------------------------
    /**
     * test by unit
     * 
     * @param	args
     *		do nothing
     */
    public static void main(String[] args)
    {
	junit.textui.TestRunner.run(QueueTest.class);
    }


    // constructors & init ----------------------------------------------------
    /**
     * testۤޤ
     *
     * @param	name	test̾
     */
    public QueueTest(String name)
    {
	super(name);
    }

    /**
     * ɬפʥ꥽ξ֤狼ɤƥȤޤ
     *
     * @throws	Exception
     *		꥽ν˼Ԥ
     */
    public void setUp()
	throws Exception
    {
	queue = new Queue(SIZE);
	assertEquals(queue.max(), SIZE);
	assertEquals(queue.isEmpty(), true);
	assertEquals(queue.isFull(), false);
	assertEquals(queue.size(), 0);
    }
    

    // method test ------------------------------------------------------------
    /**
     * ɲäȺϽ뤫?
     * ưθο;֤̤꤫?
     */
    public void testAddAndRemoveFull()
    {
	for (int i = 0; i < SIZE; i++) {
	    queue.add(new DummyWrapper());
	}

	for (int i = 0; i < SIZE; i++) {
	    Wrapper wpr = queue.remove();
	    assertNotNull(wpr);
	}
	assertEquals(queue.max(), SIZE);
	assertEquals(queue.isEmpty(), true);
	assertEquals(queue.isFull(), false);
	assertEquals(queue.size(), 0);
    }

    /**
     * NullɲäƼԤ뤫?
     */
    public void testAddNull()
    {
	try {
	    queue.add(null);
	    fail("oh!! I can add null to queue");
	} catch (NullPointerException e) {
	    // do nothing
	}
    }

    /**
     * empty֤size0?
     * empty֤ưnull֤뤫?
     */
    public void testIsEmpty()
    {
	while (!queue.isEmpty()) {
	    Wrapper wpr = queue.remove();
	    assertNotNull(wpr);
	}
	assertEquals(queue.size(), 0);

	assertNull("oh! I can remove from empty...???",
		   queue.remove());
    }

    /**
     * full֤sizemax?
     * full֤ɲäԤfalse֤뤫?
     */
    public void testFull()
    {
	while (!queue.isFull()) {
	    queue.add(new DummyWrapper());
	}
	assertEquals(queue.max(), queue.size());

	assertFalse("oh! I can add from full...???",
		    queue.add(new DummyWrapper()));
    }

    /**
     * ɲäobjectȼФobejctϡƱΡobject?
     * (queueưԤäƤ뤫?)
     */
    public void testOrder()
    {
	while (!queue.isEmpty()) {
	    queue.remove();
	}

	// connSizeŬ˷
	Wrapper[] nWprs = new Wrapper[SIZE - SIZE / 10];
	for (int i = 0; i < nWprs.length; i++) {
	    Wrapper wpr = new DummyWrapper();
	    queue.add(wpr);
	    nWprs[i] = wpr;
	}

	for (int i = 0; i < nWprs.length; i++) {
	    Wrapper wpr = queue.remove();
	    assertTrue(wpr == nWprs[i]);
	}
    }
}
