/*
 * test for ConnectionFactory 
 * $Id: ConnectionFactoryTest.java,v 1.1.1.1 2002/12/10 09:18:13 mitsuhito Exp $
 */

package jp.livewell.baby.pool.jdbc;


import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import junit.framework.TestCase;

import jp.livewell.baby.pool.Wrapper;


/**
 * ConnectionFactory classƥȤޤ
 *
 * @author mitsuhito
 */
public class ConnectionFactoryTest
    extends TestCase
{
    // main -------------------------------------------------------------------
    /**
     * test by unit
     * 
     * @param	args
     *		do nothing
     */
    public static void main(String[] args)
    {
	junit.textui.TestRunner.run(ConnectionFactoryTest.class);
    }


    // share ConnectionFactoty ------------------------------------------------
    /**
     * μ¤ưʬäƤConnectionFactoryᤷޤ
     * ¾ΥƥȥǤѤޤ
     *
     * @return	ѲǽConnectionFactory
     */
    public static ConnectionFactory getAbsolute()
    {
	ConnectionPoolInfo info = new ConnectionPoolInfo();
	ConnectionPoolInfoTest.setAbsolute(info);
	ConnectionFactory factory = new ConnectionFactory();

	try {
	    factory.init(info);
	    assertTrue("init flag is not set.", factory.isInit());
	} catch (SQLException e) {
	    fail("init ConnectionFactory fail."
		 + " check Driver, URL, User, Password."
		 + e.toString());
	}
	return factory;
    }


    // attributes -------------------------------------------------------------
    /** test target */
    private ConnectionFactory factory;


    // construstors & init ----------------------------------------------------
    /**
     * ƥȤۤޤ
     *
     * @param	name	test̾
     */
    public ConnectionFactoryTest(String name)
    {
	super(name);
    }

    /**
     * ɬפʥ꥽ξ֤狼ɤƥȤޤ
     *
     * @throws	Exception
     *		꥽ν˼Ԥ
     */
    public void setUp()
	throws Exception
    {
	factory = getAbsolute();
    }
    

    // method test ------------------------------------------------------------
    /**
     * create˹Ԥ뤫?
     */
    public void testCreate()
    {
	try {
	    Wrapper wrp = factory.create();
	    assertNotNull("factory must be not return null!!", wrp);
	} catch (Exception e) {
	    fail("pool instance creation failed.!");
	}
    }

    /**
     * connectTest˹Ԥ뤫?
     * ְäͿƤExceptionФʤ?
     */
    public void testConnectTest()
    {
	ConnectionPoolInfo inf = new ConnectionPoolInfo();
	ConnectionPoolInfoTest.setAbsolute(inf);

	try {
	    ConnectionFactory fac = new ConnectionFactory();
	    assertTrue("testConnectTest fail.",
		       fac.connectTest(inf));
	    assertFalse("testConnecTest fail.", 
			fac.connectTest(new ConnectionPoolInfo()));
	    assertFalse("testConnecTest fail.",
			fac.connectTest(null));
	} catch (Exception e) {
	    fail("testConnectTest fail. why throw Exception?");
	}
    }

    /**
     * 󥹥ȥ饯ConnectionPoolInfoͿƤinitƤ뤫?
     * 2initIllegalStateExceptionФ?
     * initϴְäSQLExceptionthrow뤫?
     */
    public void testInit()
    {
	ConnectionPoolInfo inf = new ConnectionPoolInfo();
	ConnectionPoolInfoTest.setAbsolute(inf);

	try {
	    ConnectionFactory fac = new ConnectionFactory(inf);
	    assertTrue("testInit fail.", fac.isInit());
	} catch (SQLException e) {
	    fail("testInit fail. check driver, url, user, password");
	}

	try {
	    factory.init(inf);
	    fail("Oh! 2time init. but not throw Exception?");
	} catch (IllegalStateException e) {
	    // do nothing
	} catch (SQLException e) {
	    fail("testInit fail. check driver, url, user, password");
	}

	inf.setUser("badUser");
	try {
	    ConnectionFactory fac = new ConnectionFactory();
	    fac.init(inf);
	    fail("Oh! given bad user name. but not throw SQLException?");
	} catch (SQLException e) {
	    // do nothing
	}
    }

    /**
     * logWriterϽͤnullǤϤʤȤݾڤƤ뤫?
     * logWriterϥåȤǤ뤫?
     * set줿ΤgetΤפ뤫?
     * ϤƤ뤫?
     */
    public void testLogWriter()
    {
	// not null?
	assertNotNull(factory.getLogWriter());

	StringWriter sw = new StringWriter();
	PrintWriter pw = new PrintWriter(sw);
	// settable?
	factory.setLogWriter(pw);

	// same object?
	assertTrue(pw == factory.getLogWriter());

	// writeable?
	factory.connectTest(null);
	assertFalse(sw.toString().equals(""));
    }	    

    /**
     * Ƥ֤true֤?
     * Ƥʤ֤false֤?
     */
    public void testIsInit()
    {
	ConnectionFactory fac = new ConnectionFactory();
	assertFalse("testIsInit fail."
		    + " this factory is not init. but return true.",
		    fac.isInit());

	ConnectionPoolInfo inf = new ConnectionPoolInfo();
	ConnectionPoolInfoTest.setAbsolute(inf);
	try {
	    fac.init(inf);
	} catch (Exception e) {
	    fail("init fail.");
	} 
	assertTrue("testIsInit fail."
		   + "this factory already init. but return false",
		   fac.isInit());
    }

    /**
     * Ƥʤ֤IllegalStateExceptionthrow뤫?
     * Driver˼Ǥ뤫?
     */
    public void testGetDriver()
    {
	ConnectionFactory fac = new ConnectionFactory();
	try {
	    fac.getDriver();
	    fail("this factory is not init. but getDriver is not throw.");
	} catch (IllegalStateException e) {
	    // do nothing
	}

	ConnectionPoolInfo inf = new ConnectionPoolInfo();
	ConnectionPoolInfoTest.setAbsolute(inf);
	try {
	    fac.init(inf);
	} catch (Exception e) {
	    fail("init fail.");
	} 

	String drvName = fac.getDriver().getClass().getName();
	assertTrue("testGetDriver fail. driver name is not same.",
		   drvName.equals(inf.getDriverName()));
    }
	
    /**
     * Ƥʤ֤IllegalStateExceptionthrow뤫?
     * URL˼Ǥ뤫?
     */
    public void testGetUrl()
    {
	ConnectionFactory fac = new ConnectionFactory();

	try {
	    fac.getUrl();
	    fail("this factory is not init. but getUrl is not throw.");
	} catch (IllegalStateException e) {
	    // do nothing
	}

	ConnectionPoolInfo inf = new ConnectionPoolInfo();
	ConnectionPoolInfoTest.setAbsolute(inf);
	try {
	    fac.init(inf);
	} catch (Exception e) {
	    fail("init fail.");
	} 

	assertTrue("testGetUrl fail. url is not same.",
		   fac.getUrl().equals(inf.getUrl()));
    }
	
    /**
     * Ƥʤ֤IllegalStateExceptionthrow뤫?
     * Properties˼Ǥ뤫?
     */
    public void testGetInfo()
    {
	ConnectionFactory fac = new ConnectionFactory();

	try {
	    fac.getInfo();
	    fail("this factory is not init. but getInfo is not throw.");
	} catch (IllegalStateException e) {
	    // do nothing
	}

	ConnectionPoolInfo inf = new ConnectionPoolInfo();
	ConnectionPoolInfoTest.setAbsolute(inf);
	try {
	    fac.init(inf);
	} catch (Exception e) {
	    fail("init fail.");
	} 

	assertTrue("testGetInfo fail. properties is not same.",
		   fac.getInfo().equals(inf.toProperties()));
    }

    /**
     * Ƥʤ֤IllegalStateExceptionthrow뤫?
     * Ʊͤtrue֤?
     * 㤦ͤfalse֤?
     */
    public void testHasSameData()
    {
	ConnectionFactory fac = new ConnectionFactory();
	ConnectionPoolInfo inf = new ConnectionPoolInfo();
	ConnectionPoolInfoTest.setAbsolute(inf);

	try {
	    fac.hasSameData(inf.getUrl(), inf.toProperties());
	    fail("this factory is not init. but hasSameData is not throw.");
	} catch (IllegalStateException e) {
	    // do nothing
	}

	try {
	    fac.init(inf);
	} catch (Exception e) {
	    fail("init fail.");
	} 

	assertTrue("testHasSameData fail. must be return true.",
		   fac.hasSameData(inf.getUrl(), inf.toProperties()));

	Properties prop = inf.toProperties();
	prop.setProperty("user", "bad user");
	assertFalse("testHasSameData fail. must be return false.",
		    fac.hasSameData(inf.getUrl(), prop));
    }

    /**
     * ³Ǥ뤫?
     * Ƥʤ֤IllegalStateExceptionthrow뤫?
     */
    public void testGetConnection()
    {
	// can get connection?
	Connection conn = null;
	try {
	    conn = factory.getConnection();
	} catch (SQLException e) {
	    fail("testGetConnection fail. check driver, url, user, password.");
	} finally {
	    if (conn != null) {
		try {
		    conn.createStatement().executeQuery("select 1");
		    conn.close();
		} catch (SQLException e) {
		    fail("what happend? can't close JDBC Connection.");
		}
	    }
	}
	assertNotNull("testGetConnection fail.", conn);

	// throw IllegalState?
	try {
	    ConnectionFactory fac = new ConnectionFactory();
	    fac.getConnection();
	    fail("Oh! factory is not init. why can call getConnection?");
	} catch (IllegalStateException e) {
	    // do nothing
	} catch (SQLException e) {
	    fail("testGetConnection fail. check driver, url, user, password.");
	}	    
    }
}	
