/*
 * test for ConnectionPoolInfo
 * $Id: ConnectionPoolInfoTest.java,v 1.1.1.1 2002/12/10 09:18:14 mitsuhito Exp $
 */

package jp.livewell.baby.pool.jdbc;


import java.util.Properties;
import jp.livewell.baby.pool.PoolInfoTest;


/**
 * ConnectionPoolInfo classƥȤޤ
 *
 * @author mitsuhito
 */
public class ConnectionPoolInfoTest
    extends PoolInfoTest
{
    // main -------------------------------------------------------------------
    /**
     * test by unit
     * 
     * @param	args
     *		do nothing
     */
    public static void main(String[] args)
    {
	junit.textui.TestRunner.run(ConnectionPoolInfoTest.class);
    }


    // share ConnectionPoolInfo -----------------------------------------------
    /**
     * μ¤³ǤʬäƤǡ١ꤷƤޤ
     * ¾ΥƥȥǤѤޤ
     *
     * @param	info
     *		ԤʤConnectionPoolInfoinstance
     */
    public static void setAbsolute(ConnectionPoolInfo info)
    {
	try {
	    PoolInfoTest.setAbsolute(info);

	    info.setDriverName(DRIVER);
	    info.setUrl(URL);
	    info.setUser(USER);
	    info.setPassword(PASSWORD);
	    info.setPingCommand(COMMAND);
	    info.setPingInterval(INTERVAL);
	} catch (Exception e) {
	    fail("create ConnectionPoolInfo fail."
		 + "check driver, url, user, password, "
		 + "pingCommand, pingInterval.\n" + e.toString());
	}
    }


    // attributes -------------------------------------------------------------
    /** database driver name */
    public static final String DRIVER = "org.postgresql.Driver";

    /** database url */
    public static final String URL = "jdbc:postgresql://127.0.0.1/ayu";

    /** database user name */
    public static final String USER = "ayu";

    /** database user's password */
    public static final String PASSWORD = "ayu";

    /** database ping command */
    public static final String COMMAND = "select 2";

    /** ping shortest interval */
    public static final long INTERVAL = 1000;

    /** test target */
    private ConnectionPoolInfo info;


    // constructors & init ----------------------------------------------------
    /**
     * testۤޤ
     *
     * @param	name	test̾
     */
    public ConnectionPoolInfoTest(String name)
    {
	super(name);
    }

    /**
     * ɬפʥ꥽ξ֤狼ɤƥȤޤ
     *
     * @throws	Exception
     *		꥽ν˼Ԥ
     */
    public void setUp()
	throws Exception
    {
	super.setUp();
	info = new ConnectionPoolInfo();
    }
    

    // method test ------------------------------------------------------------
    /**
     * JDBC Driver̾뤫?
     * η̤ͤƱ?
     * (nullޤ)̵Driver̾ꤷ
     * IllegalArgumentExceptionthrow뤫?
     */
    public void testDriverName()
    {
	info.setDriverName(DRIVER);
	assertEquals("fail driver equals.", info.getDriverName(), DRIVER);

	try {
	    info.setDriverName(null);
	    fail("oh! I can set null to DriverName");
	} catch (IllegalArgumentException e) {
	    // do nothing
	}
    }

    /**
     * database URL뤫?
     * η̤ͤƱ?
     * nullꤷNullPointerExceptionthrow뤫?
     */
    public void testUrl()
    {
	info.setUrl(URL);
	assertEquals("fail URL equals", info.getUrl(), URL);

	try {
	    info.setUrl(null);
	    fail("oh! I can set null to URL");
	} catch (NullPointerException e) {
	    // do nothing
	}
    }

    /**
     * database userǤ뤫?
     * η̤ͤƱ?
     * nullꤷNullPointerExceptionthrow뤫?
     */
    public void testUser()
    {
	info.setUser(USER);
	assertEquals("fail USER equals", info.getUser(), USER);

	try {
	    info.setUser(null);
	    fail("oh! I can set null to database user.");
	} catch (NullPointerException e) {
	    // do nothing
	}
    }

    /**
     * database userpasswordǤ뤫?
     * η̤ͤƱ?
     * nullꤷNullPointerExceptionthrow뤫?
     */
    public void testPassword()
    {
	info.setPassword(PASSWORD);
	assertEquals("fail PASSWORD equals.", info.getPassword(), PASSWORD);
	
	try {
	    info.setPassword(null);
	    fail("oh! I can set null to database user's password.");
	} catch (NullPointerException e) {
	    // do nothing
	}
    }

    /**
     * ĥ°Ǥ뤫?
     * η̤ͤƱ?
     * nullꤷNullPointerExceptionthrow뤫?
     */
    public void testExtention()
    {
	String extKey1 = "characterEncoding";
	String extVal1 = "euc-jp";
	info.setExtention(extKey1, extVal1);
	assertEquals("fail Extention equals1.",
		     info.getExtention(extKey1), extVal1);

	String extKey2 = "useUnicode";
	String extVal2 = "true";
	info.setExtention(extKey2, extVal2);
	assertEquals("fail Extention equals1.",
		     info.getExtention(extKey2), extVal2);

	try {
	    info.setExtention(null, extVal1);
	    fail("oh! I can set null to extention key.");
	} catch (NullPointerException e) {
	    // do nothing
	}

	try {
	    info.setExtention(extKey1, null);
	    fail("oh! I can set null to extention value.");
	} catch (NullPointerException e) {
	    // do nothing
	}
    }

    /**
     * ǡ١³ǧSQLǤ뤫?
     * η̤ͤƱ?
     * nullꤷNullPointerExceptionthrow뤫?
     */
    public void testPingCommand()
    {
	info.setPingCommand(COMMAND);
	assertEquals("fail COMMAND equals.", info.getPingCommand(), COMMAND);
	
	try {
	    info.setPingCommand(null);
	    fail("oh! I can set null to ping command.");
	} catch (NullPointerException e) {
	    // do nothing
	}
    }

    /**
     * ǡ١³ǧδֳ֤Ǥ뤫?
     * η̤ͤƱ?
     * ͤꤷIllegalArgumentExceptionthrow뤫?
     */
    public void testPingInverval()
    {
	info.setPingInterval(INTERVAL);
	assertEquals("fail INTERVAL equals.",
		     info.getPingInterval(), INTERVAL);
	
	try {
	    info.setPingInterval(-1);
	    fail("oh! I can set minous value.");
	} catch (IllegalArgumentException e) {
	    // do nothing
	}
    }

    /**
     * JDBC DriverϤͤƴޤjava.util.Properties
     * Ǥ뤫?
     */
    public void testToProperties()
    {
	String extKey1 = "characterEncoding";
	String extVal1 = "euc-jp";

	String extKey2 = "useUnicode";
	String extVal2 = "true";

	ConnectionPoolInfo inf = new ConnectionPoolInfo();
	inf.setUser(USER);
	inf.setPassword(PASSWORD);
	inf.setExtention(extKey1, extVal1);
	inf.setExtention(extKey2, extVal2);

	Properties prop = inf.toProperties();
	
	assertEquals("fail equals Properties1.",
		     prop.getProperty("user"), USER);
	assertEquals("fail equals Properties2.",
		     prop.getProperty("password"), PASSWORD);
	assertEquals("fail equals Properties3.",
		     prop.getProperty(extKey1), extVal1);
	assertEquals("fail equals Properties4.",
		     prop.getProperty(extKey2), extVal2);
    }

    /**
     * Ʊͤꤷ̤instanceequalsΩĤ?
     * 㤦ͤꤷ̤instanceequalsΩʤ?
     */
    public void testEquals()
    {
	ConnectionPoolInfo infoX = new ConnectionPoolInfo();
	setAbsolute(infoX);
	ConnectionPoolInfo infoY = new ConnectionPoolInfo();
	setAbsolute(infoY);
	{
	    String extKey1 = "characterEncoding";
	    String extVal1 = "euc-jp";
	    
	    String extKey2 = "useUnicode";
	    String extVal2 = "true";

	    infoX.setExtention(extKey1, extVal1);
	    infoX.setExtention(extKey2, extVal2);

	    infoY.setExtention(extKey1, extVal1);
	    infoY.setExtention(extKey2, extVal2);
	}
	assertTrue("fail equals1.", infoX.equals(infoY));

	infoY.setUser(USER + USER);
	assertFalse("fail equals2.", infoX.equals(infoY));
    }

    /**
     * cloneη̤Ʊ줫?
     */
    public void testClone()
    {
	ConnectionPoolInfo cloneInfo = (ConnectionPoolInfo) info.clone();
	assertTrue("fail clone", info.equals(cloneInfo));
    }
}
