/*
 * test for ConnectionPool
 * $Id: ConnectionPoolTest.java,v 1.1.1.1 2002/12/10 09:18:14 mitsuhito Exp $
 */


package jp.livewell.baby.pool.jdbc;


import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;

import jp.livewell.baby.pool.DefaultPool;
import jp.livewell.baby.pool.DefaultPoolTest;


/**
 * ConnectionPoolƥȤޤ
 *
 * @author mitsuhito
 */
public class ConnectionPoolTest
    extends DefaultPoolTest
{
    // main -------------------------------------------------------------------
    /**
     * test by unit
     * 
     * @param	args
     *		do nothing
     */
    public static void main(String[] args)
    {
	junit.textui.TestRunner.run(ConnectionPoolTest.class);
    }


    // share ConnectionPool ---------------------------------------------------
    /**
     * μ¤ưʬäƤConnectionPoolᤷޤ
     * ¾ΥƥȥǤѤޤ
     *
     * @return	ѤǤConnectionPool
     */
    public static DefaultPool getAbsolute()
    {
	ConnectionPool pl = null;
	{
	    ConnectionPoolInfo info = new ConnectionPoolInfo();
	    ConnectionPoolInfoTest.setAbsolute(info);
	    try {
		pl = new ConnectionPool(info);
	    } catch (Exception e) {
		fail("create ConnectionPool fail. check properties.");
	    }
	}
	return pl;
    }


    // attributes -------------------------------------------------------------
    /** test target */
    private ConnectionPool pool;


    // constructors & init ----------------------------------------------------
    /**
     * testۤޤ
     *
     * @param	name	test̾
     */
    public ConnectionPoolTest(String name)
    {
	super(name);
    }

    /**
     * ɬפʥ꥽ξ֤狼ɤƥȤޤ
     *
     * @throws	Exception
     *		꥽ν˼Ԥ
     */
    public void setUp()
	throws Exception
    {
	setPool((ConnectionPool) getAbsolute());
    }

    /**
     * ƥȤǻѤConnectionPoolꤷޤ
     *
     * @param	pool
     *		ConnectionPool
     */
    protected void setPool(ConnectionPool pool)
    {
	super.setPool(pool);
	this.pool = pool;
    }


    // test methods -----------------------------------------------------------
    /**
     * factoryƱurlpropretiesCONNECT_POOLING֤?
     * factoryƱurlȰ㤦propertiesCONNECT_ACCEPT֤?
     * facotryȰ㤦urlDriveracceptsURLtrueλˤ
     *   CONNECT_ACCEPTfalseλˤCONNECT_IMPOSSIBLE֤?
     */
    public void testCheckavailable()
    {
	ConnectionPoolInfo inf = new ConnectionPoolInfo();
	ConnectionPoolInfoTest.setAbsolute(inf);
	ConnectionPool pl = null;
	ConnectionFactory fac = null;

	try {
	    pl = new ConnectionPool(inf);
	    fac = (ConnectionFactory) pl.getFactory();
	} catch (SQLException e) {
	    fail("please check database is uped.\n" + e);
	}

	// case same url & properties
	try {
	    int pooled = pl.checkAvailable(inf.getUrl(), inf.toProperties());
	    assertTrue("testCheckavailable same url & properties case fail.",
		       pooled == ConnectionPool.CONNECT_POOLING);
	} catch (SQLException e) {
	    fail("connection pool throw SQLException.\n" + e);
	}

	// case same url & different properties
	try {
	    Properties prop = inf.toProperties();
	    prop.setProperty("user", "bad user");
	    int pooled = pl.checkAvailable(inf.getUrl(), prop);
	    assertTrue("testCheckavailable same url"
		       + " & different properties case fail.",
		       pooled == ConnectionPool.CONNECT_ACCEPT);
	} catch (SQLException e) {
	    fail("connection pool throw SQLException.\n" + e);
	}


	// case different good url
	try {
	    String url = inf.getUrl() + "test";
	    int pooled = pl.checkAvailable(url);
	    Driver drv = fac.getDriver();

	    assertTrue("testCheckavailable different good url fail.",
		       pooled == ConnectionPool.CONNECT_ACCEPT 
		       && drv.acceptsURL(url));
	} catch (SQLException e) {
	    fail("connection pool throw SQLException.\n" + e);
	}

	// case different bad url
	try {
	    String url = "jdbc:badurl://127.0.0.1/baddb";
	    int pooled = pl.checkAvailable(url);
	    Driver drv = fac.getDriver();

	    assertTrue("testCheckavailable different bad url.",
		       pooled == ConnectionPool.CONNECT_IMPOSSIBLE 
		       && !drv.acceptsURL(url));
	} catch (SQLException e) {
	    fail("connection pool throw SQLException.\n" + e);
	}
    }	

    /**
     * ơgetConnectionԤ̤֤?
     */
    public void testGetConnection()
    {
	ConnectionPoolInfo inf = new ConnectionPoolInfo();
	ConnectionPoolInfoTest.setAbsolute(inf);
	ConnectionPool pl = null;

	try {
	    pl = new ConnectionPool(inf);
	} catch (SQLException e) {
	    fail("please check database is uped.\n" + e);
	}

	Connection conn = null;
	try {
	    conn = pl.getConnection();
	} catch (SQLException e) {
	    fail("database access error?");
	} finally {
	    if (conn != null) {
		try {
		    conn.close();
		} catch (SQLException e) {
		    fail("can't close connection. check ConnectionWrapper.");
		}
	    }
	}

	try {
	    conn = pool.getConnection(inf.getUser(), inf.getPassword());
	} catch (SQLException e) {
	    fail("database access error?");
	} finally {
	    if (conn != null) {
		try {
		    conn.close();
		} catch (SQLException e) {
		    fail("can't close connection. check ConnectionWrapper.");
		}
	    }
	}

	try {
	    conn = pool.getConnection(inf.getUrl(), inf.toProperties());
	} catch (SQLException e) {
	    fail("database access error?");
	} finally {
	    if (conn != null) {
		try {
		    conn.close();
		} catch (SQLException e) {
		    fail("can't close connection. check ConnectionWrapper.");
		}
	    }
	}
    }

    /**
     * getLoginTimeoutgetTimeoutƱ?
     */
    public void testGetLoginTimeout()
    {
	try {
	    assertTrue("why getLoginTimeout not equal getTimeout?",
		       pool.getLoginTimeout() == pool.getTimeout());
	} catch (SQLException e) {
	    fail("what happen?");
	}
    }

    /**
     * loginTimeoutǤ뤫?
     */
    public void testSetLoginTimeout()
    {
	try {
	    int timeout = pool.getLoginTimeout();
	    pool.setLoginTimeout(++timeout);
	    assertTrue("timeout is not equal set value!",
		       pool.getLoginTimeout() == timeout);
	} catch (SQLException e) {
	    fail("waht happen?");
	}
    }    
}
