/*
 * test for ConnectionWrapper
 * $Id: ConnectionWrapperTest.java,v 1.1.1.1 2002/12/10 09:18:14 mitsuhito Exp $
 */


package jp.livewell.baby.pool.jdbc;


import junit.framework.TestCase;
import jp.livewell.baby.pool.ComparisonKey;
import jp.livewell.baby.pool.Pool;


/**
 * ConnectionWrapperƥȤޤ
 *
 * @author mitsuhito
 */
public class ConnectionWrapperTest
    extends TestCase
{
    // main -------------------------------------------------------------------
    /**
     * test by unit
     * 
     * @param	args
     *		do nothing
     */
    public static void main(String[] args)
    {
	junit.textui.TestRunner.run(ConnectionWrapperTest.class);
    }


    // share ConnectionWrapper ------------------------------------------------
    /**
     * μ¤ưʬäƤConnectionWrapperᤷޤ
     * ¾ΥƥȥǤѤޤ
     *
     * @return	ѤǤConnectionWrapper
     */
    public static ConnectionWrapper getAbsolute()
    {
	ConnectionWrapper wrp = null;
	try {
	    ConnectionPool pool 
		= (ConnectionPool) ConnectionPoolTest.getAbsolute();
	    wrp = (ConnectionWrapper) pool.getConnection();
	} catch (Exception e) {
	    fail("get ConnectionWrapper fail. check jdbc properties");
	}
	return wrp;
    }
	

    // attributes -------------------------------------------------------------
    /** test target */
    private ConnectionWrapper wrap;


    // constructors & init ----------------------------------------------------
    /**
     * testۤޤ
     *
     * @param	name	test̾
     */
    public ConnectionWrapperTest(String name)
    {
	super(name);
    }

    /**
     * ɬפʥ꥽ξ֤狼ɤƥȤޤ
     *
     * @throws	Exception
     *		꥽ν˼Ԥ
     */
    public void setUp()
	throws Exception
    {
	wrap = getAbsolute();
    }


    // test methods -----------------------------------------------------------
    /**
     * isWorkableϼtrue֤?
     * releasefalse?
     */
    public void testIsWorkable()
    {
	assertTrue("active Wrapper must return true.", wrap.isWorkable());
	try {
	    wrap.release();
	} catch (Exception e) {
	    fail("passivate Wrapper fail.");
	}
	assertFalse("passve Wrapper must return false.", wrap.isWorkable());
    }

    /**
     * activateϼfalse֤?
     * release˰㤦activateϼԤ뤫?
     */
    public void testActivate()
    {
	assertFalse(wrap.activate(new ComparisonKey()));

	try {
	    wrap.release();
	    wrap.activate(new ComparisonKey());
	    fail("why not throw IllegalArgumentException by illegal Key?");
	} catch (IllegalArgumentException e) {
	    // success!
	}
    }

    /**
     * 㤦ǤpassivateϼԤ뤫?
     * releasepassivatefalse֤?
     */
    public void testPassivate()
    {
	try {
	    wrap.passivate(new ComparisonKey());
	    fail("why can passivate illegal key?");
	} catch (IllegalArgumentException e) {
	    // success!
	}
	wrap.release();
	assertFalse(wrap.passivate(new ComparisonKey()));
    }

    /**
     * 㤦ǤdestroyƤӽФϼԤ뤫?
     */
    public void testDestroy()
    {
	try {
	    wrap.destroy(new ComparisonKey());
	    fail("why can destroy illegal key?");
	} catch (IllegalArgumentException e) {
	    // success!
	}
    }
}
