/*
 * test for DataSourceFactory
 * $Id: DataSourceFactoryTest.java,v 1.1.1.1 2002/12/10 09:18:14 mitsuhito Exp $
 */


package jp.livewell.baby.pool.jdbc;


import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.naming.CompositeName;
import javax.naming.Name;
import javax.naming.Reference;
import junit.framework.TestCase;



/**
 * DataSourceFactoryƥȤޤ
 *
 * @author mitsuhito
 */
public class DataSourceFactoryTest
    extends TestCase
{
    // main -------------------------------------------------------------------
    /**
     * test by unit
     * 
     * @param	args
     *		do nothing
     */
    public static void main(String[] args)
    {
	junit.textui.TestRunner.run(DataSourceFactoryTest.class);
    }


    // attributes -------------------------------------------------------------
    /** test target */
    private DataSourceFactory factory;
  

    // constructors & init ----------------------------------------------------
    /**
     * ƥȤۤޤ
     *
     * @param	name	test̾
     */
    public DataSourceFactoryTest(String name)
    {
	super(name);
    }

    /**
     * ɬפʥ꥽ξ֤狼ɤƥȤޤ
     *
     * @throws	Exception
     *		꥽ν˼Ԥ
     */
    public void setUp()
	throws Exception
    {
	ResourceManager.getInstance(); // load all pool
	factory = new DataSourceFactory();
    }


    // test method ------------------------------------------------------------
    /**
     * Ƥload줿ConnectionPoolfactoryǤ뤫?
     */
    public void testGetObjectInstance()
    {
	HashSet pools = new HashSet();
	{
	    ResourceManager manager = ResourceManager.getInstance();
	    Set names = manager.poolNameSet();

	    for (Iterator itr = names.iterator(); itr.hasNext();) {
		String name = (String) itr.next();
		ConnectionPool pool = manager.findPoolByName(name);
		pools.add(pool);
	    }
	    assertTrue("must need same size.",
		       names.size() == pools.size());
	}

	try {
	    for (Iterator itr = pools.iterator(); itr.hasNext();) {
		ConnectionPool pool = (ConnectionPool) itr.next();
	    
		Reference ref = pool.getReference();
		Name name = new CompositeName(pool.getName());

		ConnectionPool jndiPool = (ConnectionPool) factory
		    .getObjectInstance(ref, name, null, null);
		assertTrue("it' not same instance!",
			   pool == jndiPool);
	    }
	} catch (Exception e) {
	    fail("why is exception thrown?\n" + e);
	}
    }
}

