/*
 * test for PoolDriver
 * $Id: PoolDriverTest.java,v 1.1.1.1 2002/12/10 09:18:14 mitsuhito Exp $
 */


package jp.livewell.baby.pool.jdbc;


import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import junit.framework.TestCase;


/**
 * PoolDriverƥȤޤ
 *
 * @author mitsuhito
 */
public class PoolDriverTest
    extends TestCase
{
    // main -------------------------------------------------------------------
    /**
     * test by unit
     * 
     * @param	args
     *		do nothing
     */
    public static void main(String[] args)
    {
	junit.textui.TestRunner.run(PoolDriverTest.class);
    }


    // attributes -------------------------------------------------------------
    /** test target */
    private PoolDriver driver;


    // constructors & init ----------------------------------------------------
    /**
     * testۤޤ
     *
     * @param	name	test̾
     */
    public PoolDriverTest(String name)
    {
	super(name);
    }

    /**
     * ɬפʥ꥽ξ֤狼ɤƥȤޤ
     *
     * @throws	Exception
     *		꥽ν˼Ԥ
     */
    public void setUp()
	throws Exception
    {
	driver = null;
	try {
	    String name = "jp.livewell.baby.pool.jdbc.PoolDriver";
	    Class.forName(name);
	
	    for (Enumeration enum = DriverManager.getDrivers();
			 enum.hasMoreElements();) {
		Driver d = (Driver) enum.nextElement();

		if (d.getClass().getName().equals(name)) {
		    driver = (PoolDriver) d;
		    break;
		}
	    }
	} catch (Exception e) {
	    // do nothing
	}

	assertNotNull("PoolDriver creation fail.", driver);
    }


    // test methods -----------------------------------------------------------
    /**
     * DriveracceptsURLƥȤޤ
     */
    public void testAcceptsURL()
    {
	ConnectionPoolInfo info = new ConnectionPoolInfo();
	ConnectionPoolInfoTest.setAbsolute(info);
	
	try {
	    assertTrue("acceptsURL fail. this URL is must be connectable.\n"
		       + info.getUrl() + ".\n",
		       driver.acceptsURL(info.getUrl()));
	} catch (Exception e) {
	    fail("database access error.");
	}

	try {
	    String url = "jdbc:badurl:/127.0.0.1/baddb";
	    assertFalse("acceptsURL fail. this URL is bad. why can connect?\n"
			+ url + ".\n",
			driver.acceptsURL(url));
	} catch (Exception e) {
	    fail("database access error");
	}
    }

    /**
     * DriverȤ³뤫?
     * ̵UsersqlExceptionthrow뤫?
     * Ǥurlnull֤?
     */
    public void testConnect()
    {
	ConnectionPoolInfo info = new ConnectionPoolInfo();
	ConnectionPoolInfoTest.setAbsolute(info);

	Connection conn = null;
	try {
	    conn = driver.connect(info.getUrl(), info.toProperties());
	    assertNotNull("driver connect fail.\n", conn);
	} catch (SQLException e) {
	    fail("testConnect fail.\n" + e);
	} finally {
	    if (conn != null) {
		try {
		    conn.close();
		} catch (SQLException e) {
		    // do nothing
		}
	    }
	}


	try {
	    Properties prop = info.toProperties();
	    prop.setProperty(ConnectionPoolInfo.KEY_USER, "baduser");
	    conn = driver.connect(info.getUrl(), prop);
	    fail("this case must throw SQLException");
	} catch (SQLException e) {
	    // success!!
	} finally {
	    if (conn != null) {
		try {
		    conn.close();
		} catch (SQLException e) {
		    // do nothing
		}
	    }
	}


	try {
	    conn = driver.connect("jdbc:badurl://127.0.0.1/baddb",
				  info.toProperties());
	    assertNull("this case must be null.", conn);
	} catch (SQLException e) {
	    fail("nogood for bad url to thrown SQLException");
	} finally {
	    if (conn != null) {
		try {
		    conn.close();
		} catch (SQLException e) {
		    // do nothing
		}
	    }
	}
    }

    /**
     * ᥸㡼СϸͤƱƤ뤫?
     */
    public void testGetMajorVersion()
    {
	assertTrue("version is different!",
		   driver.getMajorVersion() == 1);
    }

    /**
     * ޥʡСϸͤƱƤ뤫?
     */
    public void testGetMinoreVersion()
    {
	assertTrue("version is different!",
		   driver.getMinorVersion() == 0);
    }

    /**
     * DriverPropertyInfolength0?
     */
    public void testGetPropertyInfo()
    {
	ConnectionPoolInfo info = new ConnectionPoolInfo();
	ConnectionPoolInfoTest.setAbsolute(info);

	try {
	    DriverPropertyInfo[] pinfos 
		= driver.getPropertyInfo(info.getUrl(), info.toProperties());
	    assertTrue("DriverPropertyInfo length different!",
		       pinfos.length == 0);
	} catch (SQLException e) {
	    fail("this method is not throw SQLException");
	}
    }

    /**
     * jdbcCompliantfalse֤?
     */
    public void testJdbcCompliant()
    {
	assertFalse("jdbcCompliant must be false!",
		    driver.jdbcCompliant());
    }
}    
