/*
 * test for ConnectionPoolManager
 * $Id: ResourceManagerTest.java,v 1.1.1.1 2002/12/10 09:18:14 mitsuhito Exp $
 */


package jp.livewell.baby.pool.jdbc;


import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import junit.framework.TestCase;


/**
 * ResourceManagerƥȤޤ
 *
 * @author mitsuhito
 */
public class ResourceManagerTest
    extends TestCase
{
    // main -------------------------------------------------------------------
    /**
     * test by unit
     * 
     * @param	args
     *		do nothing
     */
    public static void main(String[] args)
    {
	junit.textui.TestRunner.run(ResourceManagerTest.class);
    }


    // attributes -------------------------------------------------------------
    /** test target */
    private ResourceManager manager;


    // constructors & init ----------------------------------------------------
    /**
     * ƥȤۤޤ
     *
     * @param	name	test̾
     */
    public ResourceManagerTest(String name)
    {
	super(name);
    }

    /**
     * ɬפʥ꥽ξ֤狼ɤƥȤޤ
     *
     * @throws	Exception
     *		꥽ν˼Ԥ
     */
    public void setUp()
	throws Exception
    {
	manager = ResourceManager.getInstance();
    }


    // test methods -----------------------------------------------------------
    /**
     * getInstanceƱΥ󥹥󥹤֤?
     */
    public void testGetInstance()
    {
	ResourceManager other = ResourceManager.getInstance();
	assertTrue("instance is not same!", manager == other);
    }

    /**
     * Ͽpoolס̾ǼФȤ뤫?
     * ¸ߤʤPool̾null֤뤫?
     */
    public void testFindPoolByName()
    {
	ConnectionPoolInfo info = new ConnectionPoolInfo();
	ConnectionPoolInfoTest.setAbsolute(info);
	ConnectionPool pool = null;

	try {
	    pool = new ConnectionPool(info);
	} catch (SQLException e) {
	    fail("fail create ConnectionPool.\n" + e);
	}

	manager.registerPool(pool);
	assertTrue("why can't find same instance?",
		   manager.findPoolByName(info.getName()) == pool);
	assertNull("why not null by bad name finding?",
		   manager.findPoolByName("badpoolname"));

	manager.deregisterPool(pool.getName());
    }

    /**
     * url³ƱʤϿConnectionPoolƱΥ󥹥󥹤
     *   ֤?
     * url³󤬰㤨null֤?
     */
    public void testFindPoolByBetter()
    {
	ConnectionPoolInfo info = new ConnectionPoolInfo();
	ConnectionPoolInfoTest.setAbsolute(info);
	ConnectionPool pool = null;

	try {
	    pool = new ConnectionPool(info);
	} catch (SQLException e) {
	    fail("fail create ConnectionPool.");
	}
	manager.registerPool(pool);
	
	try {
	    ConnectionPool foundPool = manager
		.findPoolByBetter(info.getUrl(), info.toProperties());
	    int avail = foundPool.checkAvailable(info.getUrl(),
						 info.toProperties());
	    assertTrue("testFindPoolByBetter fail.",
		       avail == ConnectionPool.CONNECT_POOLING);
	} catch (SQLException e) {
	    fail("database access error");
	}

	// case different good url
	try {
	    String url = info.getUrl() + "test";
	    ConnectionPool foundPool = manager
		.findPoolByBetter(url, info.toProperties());
	    int avail = foundPool.checkAvailable(info.getUrl(),
						 info.toProperties());
	    assertTrue("testFindPoolByBetter fail.",
		       avail >= ConnectionPool.CONNECT_ACCEPT);
	} catch (SQLException e) {
	    fail("database access error");
	}

	// case different bad url
	try {
	    String url = "jdbc:badurl:/127.0.0.1/baddb";
	    ConnectionPool foundPool = manager
		.findPoolByBetter(url, info.toProperties());
	    assertNull("testFindPoolByBetter fail. why not null?", foundPool);
	} catch (SQLException e) {
	    fail("database access error");
	}
	manager.deregisterPool(pool.getName());
    }

    /**
     * ³ȻפURLΤȿ뤫?
     * ³ʤȻפURLΤȿǤ뤫?
     */
    public void testIsAvailableUrl()
    {
	ConnectionPoolInfo info = new ConnectionPoolInfo();
	ConnectionPoolInfoTest.setAbsolute(info);
	ConnectionPool pool = null;

	try {
	    pool = new ConnectionPool(info);
	} catch (SQLException e) {
	    fail("fail create ConnectionPool.");
	}

	manager.registerPool(pool);

	try {
	    assertTrue("this url is good url. why say no?",
		       manager.isAvailableUrl(info.getUrl()));
	} catch (SQLException e) {
	    fail("database access error.");
	}

	try {
	    assertTrue("this url is maybe good. why say no?",
		       manager.isAvailableUrl(info.getUrl() + "test"));
	} catch (SQLException e) {
	    fail("database access error.");
	}

	try {
	    assertFalse("this url is bad url. why say yes?",
			manager.isAvailableUrl("jdbc:badurl:/127.0.0.1/"));
	} catch (SQLException e) {
	    fail("database access error.");
	}
	
	manager.deregisterPool(pool.getName());
    }

    /**
     * ConnectionPoolϿ뤫?
     */
    public void testRegistToUnRegistCase()
    {
	ConnectionPoolInfo info = new ConnectionPoolInfo();
	ConnectionPoolInfoTest.setAbsolute(info);
	ConnectionPool pool = null;

	try {
	    pool = new ConnectionPool(info);
	} catch (SQLException e) {
	    fail("fail create ConnectionPool.");
	}

	manager.registerPool(pool);

	assertTrue("registToUnregistCase get fail. why other pool returned?",
		   manager.findPoolByName(info.getName()) == pool);

	// JDBC Driver not found?
	for (Enumeration enum = DriverManager.getDrivers();
	     enum.hasMoreElements();) {
	    Driver d = (Driver) enum.nextElement();

	    assertFalse("why exist in DriverManager master Driver?",
			d.getClass().getName().equals(info.getDriverName()));
	}

	assertTrue("registToUnregistCase unregist fail."
		   + " why other pool returned",
		   manager.deregisterPool(info.getName()) == pool);

	assertNull("registToUnregistCase check unregist fail."
		   + " why found instance after unregist?",
		   manager.findPoolByName(info.getName()));

	Set names = manager.poolNameSet();
	for (Iterator itr = names.iterator(); itr.hasNext();) {
	    String name = (String) itr.next();

	    manager.deregisterPool(name);
	}

	// JDBC Driver found?
	boolean isFound = false;
	for (Enumeration enum = DriverManager.getDrivers();
	     enum.hasMoreElements();) {
	    Driver d = (Driver) enum.nextElement();

	    if (d.getClass().getName().equals(info.getDriverName())) {
		isFound = true;
		break;
	    }
	}
	assertTrue("why Driver not released?", isFound);
    }

    /**
     * Ͽ줿ConnectionPool֤̾뤫?
     */
    public void testPoolNameSet()
    {
	ConnectionPoolInfo info = new ConnectionPoolInfo();
	ConnectionPoolInfoTest.setAbsolute(info);
	ConnectionPool pool = null;

	try {
	    pool = new ConnectionPool(info);
	} catch (SQLException e) {
	    fail("fail create ConnectionPool.");
	}

	manager.registerPool(pool);

	Set nameSet = manager.poolNameSet();
	boolean isFound = false;

	for (Iterator itr = nameSet.iterator(); itr.hasNext();) {
	    String regName = (String) itr.next();

	    if (regName.equals(pool.getName())) {
		isFound = true;
	    }
	}

	assertTrue("why pool name is not found in poolNameSet?", isFound);

	manager.deregisterPool(pool.getName());
	nameSet = manager.poolNameSet();
	isFound = false;

	for (Iterator itr = nameSet.iterator(); itr.hasNext();) {
	    String regName = (String) itr.next();

	    if (regName.equals(pool.getName())) {
		isFound = true;
	    }
	}
	
	assertFalse("why pool name is found in poolNameSet after deregister?",
		    isFound);
    }

    /**
     * ɥ饤Ф˼Ǥ뤫?
     * ConnectionPoolѤʤʤäDriverDriverManager᤻뤫?
     */
    public void testFindDriverByName()
    {
	ConnectionPoolInfo info = new ConnectionPoolInfo();
	ConnectionPoolInfoTest.setAbsolute(info);
	ConnectionPool pool = null;

	try {
	    pool = new ConnectionPool(info);
	} catch (SQLException e) {
	    fail("fail create ConnectionPool.");
	}

	manager.registerPool(pool);

	Driver drv = manager.findDriverByName(info.getDriverName());
	assertTrue("testFindDriverByName fail. driver name is not same.",
		   info.getDriverName().equals(drv.getClass().getName()));

	Set names = manager.poolNameSet();
	for (Iterator itr = names.iterator(); itr.hasNext();) {
	    String name = (String) itr.next();

	    manager.deregisterPool(name);
	}

	drv = manager.findDriverByName(info.getDriverName());
	assertNull("testFindDriverByName fail. why driver found?", drv);
    }	
}
