/*
 * $Id: ResultSetWrapperTest.java,v 1.1.1.1 2002/12/10 09:18:14 mitsuhito Exp $
 */


package jp.livewell.baby.pool.jdbc;


import java.sql.ResultSet;
import java.sql.Statement;
import junit.framework.TestCase;


/**
 * ResultSetWrapper ƥȤޤ
 *
 * @author mitsuhito
 */
public class ResultSetWrapperTest
    extends TestCase
{
    // main -------------------------------------------------------------------
    /**
     * test by unit
     * 
     * @param	args
     *		do nothing
     */
    public static void main(String[] args)
    {
	junit.textui.TestRunner.run(ResultSetWrapperTest.class);
    }


    // share ResultSetWrapper ------------------------------------------------
    /**
     * μ¤ưʬäƤResultSetWrapperᤷޤ
     * ¾ΥƥȥǤѤޤ
     *
     * @return	ѤǤResultSetWrapper
     */
    public static ResultSetWrapper getAbsolute()
    {
	ResultSetWrapper wrp = null;
	try {
	    Statement stmt = StatementWrapperTest.getAbsolute();
	    wrp = (ResultSetWrapper) stmt.executeQuery("select 1");
	} catch (Exception e) {
	    fail("get ResultSetWrapper fail. "
		 + "check jdbc properties.\n" + e);
	}
	return wrp;
    }
	

    // attributes -------------------------------------------------------------
    /** test target */
    private ResultSetWrapper wrap;


    // constructors & init ----------------------------------------------------
    /**
     * testۤޤ
     *
     * @param	name	test̾
     */
    public ResultSetWrapperTest(String name)
    {
	super(name);
    }

    /**
     * ɬפʥ꥽ξ֤狼ɤƥȤޤ
     *
     * @throws	Exception
     *		꥽ν˼Ԥ
     */
    public void setUp()
	throws Exception
    {
	setResultSet(getAbsolute());
    }

    /**
     * test targetꤷޤ
     *
     * @param	res
     *		ꤷResultSet(sub class)
     * @throws	NullPointerException
     *		stmtnullꤷ
     */
    protected void setResultSet(ResultSet res)
	throws NullPointerException
    {
	if (res != null) {
	    this.wrap = (ResultSetWrapper) res;
	} else {
	    throw new NullPointerException("result set is null!!");
	}
    }


    // test methods -----------------------------------------------------------
    /**
     * isWorkabletrue֤?
     */
    public void testIsWorkable()
    {
	assertTrue(wrap.isWorkable());
    }

    /**
     * close(Ǥdestroy)ƤӽФworkablefalse?
     */
    public void testClose()
    {
	try {
	    wrap.close();
	    assertFalse(wrap.isWorkable());
	} catch (Exception e) {
	    e.printStackTrace();
	    fail("exception throwed");
	}
    }
}
