/*
 * $Id: StatementWrapperTest.java,v 1.1.1.1 2002/12/10 09:18:14 mitsuhito Exp $
 */


package jp.livewell.baby.pool.jdbc;


import java.sql.Connection;
import java.sql.Statement;
import junit.framework.TestCase;


/**
 * StatementWrapper ƥȤޤ
 *
 * @author mitsuhito
 */
public class StatementWrapperTest
    extends TestCase
{
    // main -------------------------------------------------------------------
    /**
     * test by unit
     * 
     * @param	args
     *		do nothing
     */
    public static void main(String[] args)
    {
	junit.textui.TestRunner.run(StatementWrapperTest.class);
    }


    // share StatementWrapper ------------------------------------------------
    /**
     * μ¤ưʬäƤStatementWrapperᤷޤ
     * ¾ΥƥȥǤѤޤ
     *
     * @return	ѤǤStatementWrapper
     */
    public static StatementWrapper getAbsolute()
    {
	StatementWrapper wrp = null;
	try {
	    ConnectionPool pool 
		= (ConnectionPool) ConnectionPoolTest.getAbsolute();
	    Connection conn = pool.getConnection();
	    wrp = (StatementWrapper) conn.createStatement();
	} catch (Exception e) {
	    fail("get StatementWrapper fail. "
		 + "check jdbc properties.\n" + e);
	}
	return wrp;
    }
	

    // attributes -------------------------------------------------------------
    /** test target */
    private StatementWrapper wrap;


    // constructors & init ----------------------------------------------------
    /**
     * testۤޤ
     *
     * @param	name	test̾
     */
    public StatementWrapperTest(String name)
    {
	super(name);
    }

    /**
     * ɬפʥ꥽ξ֤狼ɤƥȤޤ
     *
     * @throws	Exception
     *		꥽ν˼Ԥ
     */
    public void setUp()
	throws Exception
    {
	setStatement(getAbsolute());
    }

    /**
     * test targetꤷޤ
     *
     * @param	stmt
     *		ꤷStatement(sub class)
     * @throws	NullPointerException
     *		stmtnullꤷ
     */
    protected void setStatement(Statement stmt)
	throws NullPointerException
    {
	if (stmt != null) {
	    this.wrap = (StatementWrapper) stmt;
	} else {
	    throw new NullPointerException("statement is null!!");
	}
    }


    // test methods -----------------------------------------------------------
    /**
     * isWorkabletrue֤?
     */
    public void testIsWorkable()
    {
	assertTrue(wrap.isWorkable());
    }

    /**
     * close(Ǥdestroy)ƤӽФworkablefalse?
     */
    public void testClose()
    {
	try {
	    wrap.close();
	    assertFalse(wrap.isWorkable());
	} catch (Exception e) {
	    e.printStackTrace();
	    fail("exception throwed");
	}
    }
}
