/*
 * Decompiled with CFR 0.152.
 */
package org.basex;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.basex.core.BaseXException;
import org.basex.core.Main;
import org.basex.core.MainProp;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.core.cmd.Check;
import org.basex.core.cmd.Set;
import org.basex.core.cmd.XQuery;
import org.basex.io.IO;
import org.basex.io.in.TextInput;
import org.basex.io.out.PrintOutput;
import org.basex.server.LocalSession;
import org.basex.server.Session;
import org.basex.util.Args;
import org.basex.util.Util;

public class BaseX
extends Main {
    private boolean writeProps;
    private String commands;
    private String file;
    protected String input;
    private String query;
    protected String user;
    protected String pass;

    public static void main(String ... args) {
        try {
            new BaseX(args);
        }
        catch (IOException ex) {
            Util.errln(ex, new Object[0]);
            System.exit(1);
        }
    }

    public BaseX(String ... args) throws IOException {
        super(args);
        try {
            this.session();
            if (this.input != null) {
                this.execute(new Check(this.input), this.verbose);
            }
            if (this.file != null) {
                IO io = IO.get(this.file);
                if (!io.exists()) {
                    throw new BaseXException(String.valueOf(Text.INFOERROR) + Text.FILEWHICH, this.file);
                }
                this.query = TextInput.content(io).toString().trim();
                this.execute(new Set(Prop.QUERYPATH, (Object)io.path()), false);
            }
            if (this.query != null) {
                this.execute(new XQuery(this.query), this.verbose);
            } else if (this.commands != null) {
                this.execute(this.commands);
            } else {
                Util.outln(String.valueOf(Text.CONSOLE) + Text.CONSOLE2, this.sa() ? "Standalone" : "Client");
                this.console();
            }
            if (this.writeProps) {
                this.context.mprop.write();
            }
        }
        finally {
            this.quit();
        }
    }

    protected boolean sa() {
        return true;
    }

    @Override
    protected Session session() throws IOException {
        if (this.session == null) {
            this.session = new LocalSession(this.context, this.out);
        }
        this.session.setOutputStream(this.out);
        return this.session;
    }

    @Override
    protected final void parseArguments(String[] args) throws IOException {
        StringBuilder serial = new StringBuilder();
        StringBuilder bind = new StringBuilder();
        HashMap<Object[], Object> options = new HashMap<Object[], Object>();
        Args arg = new Args(args, this, this.sa() ? Text.LOCALINFO : Text.CLIENTINFO, Util.info(Text.CONSOLE, this.sa() ? "Standalone" : "Client"));
        while (arg.more()) {
            if (arg.dash()) {
                char c = arg.next();
                if (c == 'b') {
                    if (bind.length() != 0) {
                        bind.append(',');
                    }
                    bind.append(arg.string());
                    continue;
                }
                if (c == 'c') {
                    this.commands = arg.remaining();
                    continue;
                }
                if (c == 'd') {
                    this.context.mprop.set(MainProp.DEBUG, true);
                    continue;
                }
                if (c == 'D' && this.sa()) {
                    options.put(Prop.DOTPLAN, true);
                    continue;
                }
                if (c == 'i') {
                    this.input = arg.string();
                    continue;
                }
                if (c == 'n' && !this.sa()) {
                    this.context.mprop.set(MainProp.HOST, arg.string());
                    continue;
                }
                if (c == 'o') {
                    this.out = new PrintOutput(arg.string());
                    if (this.session == null) continue;
                    this.session.setOutputStream(this.out);
                    continue;
                }
                if (c == 'p' && !this.sa()) {
                    this.context.mprop.set(MainProp.PORT, arg.num());
                    continue;
                }
                if (c == 'P' && !this.sa()) {
                    this.pass = arg.string();
                    continue;
                }
                if (c == 'q') {
                    this.query = arg.remaining();
                    continue;
                }
                if (c == 'r') {
                    options.put(Prop.RUNS, arg.string());
                    continue;
                }
                if (c == 's') {
                    if (serial.length() != 0) {
                        serial.append(',');
                    }
                    serial.append(arg.string());
                    continue;
                }
                if (c == 'u') {
                    options.put(Prop.WRITEBACK, true);
                    continue;
                }
                if (c == 'U' && !this.sa()) {
                    this.user = arg.string();
                    continue;
                }
                if (c == 'v') {
                    this.verbose = true;
                    continue;
                }
                if (c == 'V') {
                    this.verbose = true;
                    options.put(Prop.QUERYINFO, true);
                    continue;
                }
                if (c == 'w') {
                    options.put(Prop.CHOP, false);
                    continue;
                }
                if (c == 'W') {
                    this.writeProps = true;
                    continue;
                }
                if (c == 'x') {
                    options.put(Prop.XMLPLAN, true);
                    this.verbose = true;
                    continue;
                }
                if (c == 'X') {
                    options.put(Prop.COMPPLAN, false);
                    continue;
                }
                if (c == 'z') {
                    options.put(Prop.SERIALIZE, false);
                    continue;
                }
                arg.usage();
                continue;
            }
            String string = this.file = this.file == null ? arg.string() : String.valueOf(this.file) + " " + arg.string();
        }
        boolean bl = this.console = this.file == null && this.commands == null && this.query == null;
        if (serial.length() != 0) {
            options.put(Prop.SERIALIZER, serial);
        }
        if (bind.length() != 0) {
            options.put(Prop.BINDINGS, bind);
        }
        for (Map.Entry entry : options.entrySet()) {
            try {
                this.execute(new Set(entry.getKey(), entry.getValue()), false);
            }
            catch (IOException ex) {
                Util.errln(ex, new Object[0]);
                this.out.close();
                arg.usage();
            }
        }
    }
}

