/*
 * Decompiled with CFR 0.152.
 */
package org.basex;

import java.awt.Font;
import java.awt.Toolkit;
import java.util.Enumeration;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.basex.core.BaseXException;
import org.basex.core.Context;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.core.cmd.Check;
import org.basex.gui.GUI;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIMacOSX;
import org.basex.gui.GUIProp;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.util.Args;
import org.basex.util.Util;

public final class BaseXGUI {
    final Context context = new Context();
    GUIMacOSX osxGUI;
    String file;

    public static void main(String[] args) {
        try {
            new BaseXGUI(args);
        }
        catch (BaseXException ex) {
            Util.errln(ex, new Object[0]);
            System.exit(1);
        }
    }

    public BaseXGUI(String[] args) throws BaseXException {
        this.parseArguments(args);
        if (Prop.MAC) {
            try {
                this.osxGUI = new GUIMacOSX();
            }
            catch (Exception ex) {
                throw new BaseXException("Failed to initialize native Mac OS X interface", new Object[]{ex});
            }
        }
        this.context.prop.set(Prop.CACHEQUERY, true);
        final GUIProp gprop = new GUIProp();
        GUIConstants.init(gprop);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BaseXGUI.this.init(gprop);
                GUI gui = new GUI(BaseXGUI.this.context, gprop);
                if (BaseXGUI.this.osxGUI != null) {
                    BaseXGUI.this.osxGUI.init(gui);
                }
                if (BaseXGUI.this.file != null) {
                    String input = BaseXGUI.this.file.replace('\\', '/');
                    IOFile io = new IOFile(input);
                    boolean xq = false;
                    String[] stringArray = IO.XQSUFFIXES;
                    int n = IO.XQSUFFIXES.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String suf = stringArray[n2];
                        xq |= input.endsWith(suf);
                        ++n2;
                    }
                    if (xq) {
                        gui.editor.open(io);
                    } else {
                        gui.execute(new Check(input));
                        gprop.set(GUIProp.CREATEPATH, io.path());
                        gprop.set(GUIProp.CREATENAME, io.dbname());
                    }
                }
            }
        });
    }

    void init(GUIProp prop) {
        try {
            UIManager.getInstalledLookAndFeels();
            Toolkit.getDefaultToolkit().setDynamicLayout(true);
            if (prop.is(GUIProp.JAVALOOK)) {
                UIDefaults def = UIManager.getDefaults();
                Enumeration en = def.keys();
                while (en.hasMoreElements()) {
                    Object k = en.nextElement();
                    Object v = def.get(k);
                    if (!(v instanceof Font)) continue;
                    def.put(k, ((Font)v).deriveFont(0));
                }
            } else {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
        }
        catch (Exception ex) {
            Util.stack(ex);
        }
    }

    private void parseArguments(String[] args) throws BaseXException {
        Args arg = new Args(args, this, Text.GUIINFO, Util.info(Text.CONSOLE, "GUI"));
        while (arg.more()) {
            if (arg.dash()) {
                arg.usage();
                continue;
            }
            String string = this.file = this.file == null ? arg.string() : String.valueOf(this.file) + " " + arg.string();
        }
    }
}

