/*
 * Decompiled with CFR 0.152.
 */
package org.basex;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.basex.core.BaseXException;
import org.basex.core.Context;
import org.basex.core.Main;
import org.basex.core.MainProp;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.io.IOFile;
import org.basex.io.in.BufferInput;
import org.basex.server.ClientListener;
import org.basex.server.ClientSession;
import org.basex.server.LocalSession;
import org.basex.server.Log;
import org.basex.server.LoginException;
import org.basex.server.Session;
import org.basex.util.Args;
import org.basex.util.Performance;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.TokenIntMap;

public final class BaseXServer
extends Main
implements Runnable {
    public volatile boolean running;
    ServerSocket esocket;
    IOFile stop;
    Log log;
    private final EventListener events = new EventListener();
    private final TokenIntMap blocked = new TokenIntMap();
    private boolean quiet;
    private boolean service;
    private volatile boolean stopped;
    private ServerSocket socket;
    private String commands;

    public static void main(String[] args) {
        try {
            new BaseXServer(args);
        }
        catch (IOException ex) {
            Util.errln(ex, new Object[0]);
            System.exit(1);
        }
    }

    public BaseXServer(String ... args) throws IOException {
        this((Context)null, args);
    }

    public BaseXServer(Context ctx, String ... args) throws IOException {
        super(args, ctx);
        int port = this.context.mprop.num(MainProp.SERVERPORT);
        String host = this.context.mprop.get(MainProp.SERVERHOST);
        InetAddress hostAddress = host.isEmpty() ? null : InetAddress.getByName(host);
        int eport = this.context.mprop.num(MainProp.EVENTPORT);
        if (this.service) {
            BaseXServer.start(port, args);
            Util.outln(Text.SERVERSTART, new Object[0]);
            Performance.sleep(1000L);
            return;
        }
        if (this.stopped) {
            BaseXServer.stop(port, eport);
            Performance.sleep(1000L);
            return;
        }
        try {
            if (this.commands != null) {
                this.execute(this.commands);
            }
            this.log = new Log(this.context, this.quiet);
            this.log.write(Text.SERVERSTART);
            this.socket = new ServerSocket();
            this.socket.setReuseAddress(true);
            this.socket.bind(new InetSocketAddress(hostAddress, port));
            this.esocket = new ServerSocket();
            this.esocket.setReuseAddress(true);
            this.esocket.bind(new InetSocketAddress(hostAddress, eport));
            this.stop = BaseXServer.stopFile(port);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    BaseXServer.this.log.write(Text.SERVERSTOPPED);
                    BaseXServer.this.log.close();
                    Util.outln(Text.SERVERSTOPPED, new Object[0]);
                }
            });
            new Thread(this).start();
            while (!this.running) {
                Performance.sleep(100L);
            }
            Util.outln(String.valueOf(Text.CONSOLE) + (this.console ? Text.CONSOLE2 : Text.SERVERSTART), "Server");
            if (this.console) {
                this.console();
                this.quit();
            }
        }
        catch (IOException ex) {
            if (this.log != null) {
                this.log.write(ex.getMessage());
            }
            throw ex;
        }
    }

    @Override
    public void run() {
        this.events.start();
        this.running = true;
        while (this.running) {
            try {
                Socket s = this.socket.accept();
                if (this.stop.exists()) {
                    if (!this.stop.delete()) {
                        this.log.write(Util.info(Text.DBNOTDELETED, this.stop));
                    }
                    this.quit();
                    continue;
                }
                long ka = (long)this.context.mprop.num(MainProp.KEEPALIVE) * 1000L;
                if (ka > 0L) {
                    long ms = System.currentTimeMillis();
                    for (ClientListener cs : this.context.sessions) {
                        if (ms - cs.last <= ka) continue;
                        cs.exit();
                    }
                }
                new ClientListener(s, this.context, this.log, this).start();
            }
            catch (IOException ex) {
                break;
            }
        }
    }

    private static IOFile stopFile(int port) {
        return new IOFile(Prop.TMP, String.valueOf(Util.name(BaseXServer.class)) + port);
    }

    @Override
    public void quit() throws IOException {
        if (!this.running) {
            return;
        }
        this.running = false;
        super.quit();
        try {
            if (this.console) {
                System.in.close();
            }
            this.esocket.close();
            this.socket.close();
        }
        catch (IOException ex) {
            this.log.write(ex.getMessage());
            Util.stack(ex);
        }
        this.console = false;
        this.context.close();
    }

    @Override
    protected Session session() {
        if (this.session == null) {
            this.session = new LocalSession(this.context, this.out);
        }
        return this.session;
    }

    @Override
    protected void parseArguments(String[] args) throws IOException {
        Args arg = new Args(args, this, Text.SERVERINFO, Util.info(Text.CONSOLE, "Server"));
        boolean daemon = false;
        while (arg.more()) {
            if (arg.dash()) {
                char c = arg.next();
                if (c == 'c') {
                    this.commands = arg.remaining();
                    continue;
                }
                if (c == 'd') {
                    this.context.mprop.set(MainProp.DEBUG, true);
                    continue;
                }
                if (c == 'D') {
                    daemon = true;
                    continue;
                }
                if (c == 'e') {
                    this.context.mprop.set(MainProp.EVENTPORT, arg.num());
                    continue;
                }
                if (c == 'i') {
                    this.console = true;
                    continue;
                }
                if (c == 'p') {
                    this.context.mprop.set(MainProp.SERVERPORT, arg.num());
                    continue;
                }
                if (c == 's') {
                    this.service = !daemon;
                    continue;
                }
                if (c == 'z') {
                    this.quiet = true;
                    continue;
                }
                arg.usage();
                continue;
            }
            if (arg.string().equalsIgnoreCase("stop")) {
                this.stopped = true;
                continue;
            }
            arg.usage();
        }
        if (this.context.mprop.num(MainProp.SERVERPORT) == this.context.mprop.num(MainProp.EVENTPORT)) {
            throw new BaseXException(Text.SERVERPORTS, new Object[0]);
        }
    }

    public void stop() throws IOException {
        this.stop.write(Token.EMPTY);
        new Socket("localhost", this.context.mprop.num(MainProp.EVENTPORT)).close();
        int port = this.context.mprop.num(MainProp.SERVERPORT);
        new Socket("localhost", port).close();
        Performance.sleep(50L);
    }

    public static void start(int port, String ... args) throws BaseXException {
        if (BaseXServer.ping("localhost", port)) {
            throw new BaseXException(Text.SERVERBIND, new Object[0]);
        }
        Util.start(BaseXServer.class, args);
        int c = 0;
        while (c < 10) {
            if (BaseXServer.ping("localhost", port)) {
                return;
            }
            Performance.sleep(100L);
            ++c;
        }
        throw new BaseXException(Text.SERVERERROR, new Object[0]);
    }

    public static boolean ping(String host, int port) {
        try {
            new ClientSession(host, port, "", "");
            return false;
        }
        catch (IOException ex) {
            return ex instanceof LoginException;
        }
    }

    public static void stop(int port, int eport) throws IOException {
        IOFile stop = BaseXServer.stopFile(port);
        try {
            stop.write(Token.EMPTY);
            new Socket("localhost", eport).close();
            new Socket("localhost", port).close();
            Performance.sleep(50L);
            Util.outln(Text.SERVERSTOPPED, new Object[0]);
        }
        catch (IOException ex) {
            stop.delete();
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int block(byte[] client) {
        TokenIntMap tokenIntMap = this.blocked;
        synchronized (tokenIntMap) {
            int delay = this.blocked.get(client);
            delay = delay == -1 ? 1 : Math.min(delay, 1024) * 2;
            this.blocked.add(client, delay);
            return delay;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unblock(byte[] client) {
        TokenIntMap tokenIntMap = this.blocked;
        synchronized (tokenIntMap) {
            this.blocked.delete(client);
        }
    }

    final class EventListener
    extends Thread {
        EventListener() {
        }

        @Override
        public void run() {
            block2: while (BaseXServer.this.running) {
                try {
                    Socket es = BaseXServer.this.esocket.accept();
                    if (BaseXServer.this.stop.exists()) {
                        BaseXServer.this.esocket.close();
                        break;
                    }
                    BufferInput bi = new BufferInput(es.getInputStream());
                    long id = Token.toLong(bi.readString());
                    for (ClientListener s : BaseXServer.this.context.sessions) {
                        if (s.getId() != id) continue;
                        s.register(es);
                        continue block2;
                    }
                }
                catch (IOException ex) {
                    break;
                }
            }
        }
    }
}

