/*
 * Decompiled with CFR 0.152.
 */
package org.basex.api.jaxp;

import java.io.IOException;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.basex.api.dom.BXNList;
import org.basex.core.BaseXException;
import org.basex.core.Context;
import org.basex.core.cmd.CreateDB;
import org.basex.data.Data;
import org.basex.data.Nodes;
import org.basex.data.Result;
import org.basex.io.out.ArrayOutput;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.XMLSerializer;
import org.basex.query.QueryException;
import org.basex.query.QueryProcessor;
import org.basex.query.item.DBNode;
import org.xml.sax.InputSource;

final class BXPathExpression
implements XPathExpression {
    private final Context context = new Context();
    private final QueryProcessor xproc;

    protected BXPathExpression(String qu) {
        this.xproc = new QueryProcessor(qu, this.context);
    }

    @Override
    public String evaluate(Object item) throws XPathExpressionException {
        return this.evaluate(item, XPathConstants.STRING).toString();
    }

    @Override
    public String evaluate(InputSource is) throws XPathExpressionException {
        return this.evaluate(is, XPathConstants.STRING).toString();
    }

    @Override
    public Object evaluate(Object item, QName res) throws XPathExpressionException {
        return this.finish(this.execute(), res);
    }

    @Override
    public Object evaluate(InputSource is, QName res) throws XPathExpressionException {
        try {
            new CreateDB(is.getSystemId()).execute(this.context);
            return this.finish(this.execute(), res);
        }
        catch (BaseXException ex) {
            throw new XPathExpressionException(ex.getMessage());
        }
    }

    private Result execute() throws XPathExpressionException {
        try {
            return this.xproc.execute();
        }
        catch (QueryException ex) {
            throw new XPathExpressionException(ex);
        }
    }

    private Object finish(Result item, QName res) throws XPathExpressionException {
        Nodes nodes;
        Nodes nodes2 = nodes = item instanceof Nodes ? (Nodes)item : null;
        if (res == XPathConstants.NODESET || res == XPathConstants.NODE) {
            if (nodes == null) {
                throw new XPathExpressionException("Result can't be cast to a nodeset");
            }
            if (nodes.size() == 0L) {
                return null;
            }
            Data data = nodes.data;
            return res == XPathConstants.NODESET ? new BXNList(nodes) : new DBNode(data, nodes.list[0]).toJava();
        }
        try {
            ArrayOutput ao = new ArrayOutput();
            XMLSerializer ser = Serializer.get(ao);
            item.serialize(ser);
            ((Serializer)ser).close();
            String val = ao.toString();
            if (res == XPathConstants.NUMBER) {
                return Double.valueOf(val);
            }
            if (res == XPathConstants.STRING) {
                return val;
            }
            if (res == XPathConstants.BOOLEAN) {
                return Boolean.valueOf(val);
            }
            throw new XPathExpressionException("Invalid type: " + res);
        }
        catch (IOException ex) {
            throw new XPathExpressionException(ex);
        }
    }
}

