/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build.file;

import java.io.IOException;
import org.basex.build.SingleParser;
import org.basex.build.file.ParserProp;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.io.IO;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.XMLToken;
import org.basex.util.list.TokenList;

public final class CSVParser
extends SingleParser {
    public static final String[] SEPARATORS = new String[]{"comma", "semicolon", "tab"};
    public static final String[] FORMATS = new String[]{"simple", "verbose"};
    private static final byte[] CSV = Token.token("csv");
    private static final byte[] HEADER = Token.token("header");
    private static final byte[] RECORD = Token.token("record");
    private static final byte[] ENTRY = Token.token("entry");
    private static final byte[] COLUMN = Token.token("col");
    private final int separator;
    private final TokenList headers = new TokenList();
    private final boolean simple;
    private final String encoding;
    private int row;
    private int col;

    public CSVParser(IO path, String ta, Prop prop) throws IOException {
        super(path, ta);
        ParserProp props = new ParserProp(prop.get(Prop.PARSEROPT));
        this.row = props.is(ParserProp.HEADER) ? 0 : 1;
        String s = props.get(ParserProp.SEPARATOR).toLowerCase();
        int n = s.equals(SEPARATORS[0]) ? 44 : (s.equals(SEPARATORS[1]) ? 59 : (this.separator = s.equals(SEPARATORS[2]) ? 9 : -1));
        if (this.separator == -1) {
            throw new IOException(Util.info(Text.SETVAL, ParserProp.SEPARATOR[0], s));
        }
        s = props.get(ParserProp.FORMAT).toLowerCase();
        this.simple = s.equals(FORMATS[0]);
        if (!this.simple && !s.equals(FORMATS[1])) {
            throw new IOException(Util.info(Text.SETVAL, ParserProp.FORMAT[0], s));
        }
        this.encoding = props.get(ParserProp.ENCODING);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void parse() throws IOException {
        this.builder.startElem(CSVParser.CSV, this.atts);
        tb = new TokenBuilder();
        bi = this.src.buffer();
        bi.encoding(this.encoding);
        quoted = false;
        open = true;
        ch = -1;
        while (true) {
            block14: {
                block13: {
                    if (ch == -1) {
                        ch = bi.readChar();
                    }
                    if (ch == -1) break;
                    if (!quoted) break block13;
                    if (ch != 34 || (ch = bi.readChar()) == 34) ** GOTO lbl21
                    quoted = false;
                    continue;
lbl-1000:
                    // 1 sources

                    {
                        ch = bi.readChar();
                        if (ch == 10) continue;
                        tb.add(10);
lbl21:
                        // 3 sources

                        ** while (ch == 13)
                    }
lbl22:
                    // 1 sources

                    if (ch != 13) {
                        tb.add(ch);
                    }
                    break block14;
                }
                if (ch == this.separator) {
                    if (open) {
                        this.open();
                        open = false;
                    }
                    this.add(tb);
                } else if (ch == 13) {
                    ch = bi.readChar();
                    if (ch == 10) continue;
                    this.finish(tb, open);
                    open = true;
                } else if (ch == 10) {
                    this.finish(tb, open);
                    open = true;
                } else if (ch == 34) {
                    quoted = true;
                } else {
                    tb.add(ch);
                }
            }
            ch = -1;
        }
        bi.close();
        this.finish(tb, open);
        this.builder.endElem();
    }

    private void open() throws IOException {
        if (this.row == 0) {
            if (this.simple) {
                this.builder.startElem(HEADER, this.atts);
            }
        } else {
            this.builder.startElem(RECORD, this.atts);
        }
    }

    private void finish(TokenBuilder tb, boolean open) throws IOException {
        boolean close;
        boolean bl = close = !open;
        if (open && tb.size() != 0) {
            this.open();
            close = true;
        }
        this.add(tb);
        if (close) {
            if (this.simple || this.row != 0) {
                this.builder.endElem();
            }
            ++this.row;
        }
        this.col = 0;
    }

    private void add(TokenBuilder tb) throws IOException {
        byte[] t;
        if (this.row == 0 && !this.simple) {
            this.addHeader(tb.finish());
            tb.reset();
            return;
        }
        if (this.simple) {
            t = ENTRY;
        } else {
            if (this.col == this.headers.size()) {
                this.addHeader(COLUMN);
            }
            t = this.headers.get(this.col);
        }
        if (tb.size() != 0 || this.simple) {
            this.builder.startElem(t, this.atts);
            this.builder.text(tb.finish());
            this.builder.endElem();
            tb.reset();
        }
        ++this.col;
    }

    private void addHeader(byte[] f) {
        byte[] fb;
        TokenBuilder nm = new TokenBuilder();
        int p = 0;
        while (p < f.length) {
            int cp = Token.cp(f, p);
            nm.add((p == 0 ? XMLToken.isNCStartChar(cp) : XMLToken.isNCChar(cp)) ? cp : 95);
            p += Token.cl(f, p);
        }
        if (nm.size() == 0) {
            nm.add(COLUMN);
        }
        if (this.headers.contains(fb = nm.finish())) {
            int c = 2;
            while (this.headers.contains(fb = Token.concat(nm.finish(), Token.token(c++)))) {
            }
        }
        this.headers.add(fb);
    }
}

