/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build.file;

import java.io.IOException;
import org.basex.build.SingleParser;
import org.basex.build.file.ParserProp;
import org.basex.core.Prop;
import org.basex.io.IO;
import org.basex.io.in.TextInput;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public final class TextParser
extends SingleParser {
    private static final byte[] TEXT = Token.token("text");
    private static final byte[] LINE = Token.token("line");
    private final boolean lines;
    private final String encoding;

    public TextParser(IO path, String ta, Prop prop) throws IOException {
        super(path, ta);
        ParserProp props = new ParserProp(prop.get(Prop.PARSEROPT));
        this.lines = props.is(ParserProp.LINES);
        this.encoding = props.get(ParserProp.ENCODING);
    }

    @Override
    public void parse() throws IOException {
        this.builder.startElem(TEXT, this.atts);
        TokenBuilder tb = new TokenBuilder();
        TextInput ti = new TextInput(this.src);
        try {
            int ch;
            ti.encoding(this.encoding);
            while ((ch = ti.next()) != -1) {
                if (ch == 13) {
                    if (ti.next() != 10) {
                        ti.prev(1);
                    }
                    ch = 10;
                }
                if (ch == 10 && this.lines) {
                    this.builder.startElem(LINE, this.atts);
                    this.builder.text(tb.finish());
                    this.builder.endElem();
                    tb.reset();
                    continue;
                }
                tb.add(ch);
            }
        }
        finally {
            ti.close();
        }
        if (!this.lines) {
            this.builder.text(tb.finish());
        }
        this.builder.endElem();
    }
}

