/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build.xml;

import java.io.IOException;
import java.util.Stack;
import org.basex.build.Builder;
import org.basex.build.Parser;
import org.basex.util.Token;
import org.basex.util.Util;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public final class DOMWrapper
extends Parser {
    private final String filename;
    private final Node root;
    private int nodes;

    public DOMWrapper(Document doc, String fn) {
        super(fn);
        this.root = doc;
        this.filename = fn;
    }

    @Override
    public void parse(Builder builder) throws IOException {
        builder.startDoc(Token.token(this.filename));
        Stack<NodeIterator> stack = new Stack<NodeIterator>();
        stack.push(new NodeIterator(this.root));
        while (!stack.empty()) {
            NodeIterator ni = (NodeIterator)stack.peek();
            if (ni.more()) {
                Node n = ni.curr();
                if (n instanceof Element) {
                    stack.push(new NodeIterator(n));
                    this.atts.reset();
                    NamedNodeMap at = n.getAttributes();
                    int a = 0;
                    int as = at.getLength();
                    while (a < as) {
                        Attr att = (Attr)at.item(a);
                        byte[] k = Token.token(att.getName());
                        byte[] v = Token.token(att.getValue());
                        if (Token.eq(k, Token.XMLNS)) {
                            builder.startNS(Token.EMPTY, v);
                        } else if (Token.startsWith(k, Token.XMLNSC)) {
                            builder.startNS(Token.ln(k), v);
                        } else {
                            this.atts.add(k, v);
                        }
                        ++a;
                    }
                    builder.startElem(Token.token(n.getNodeName()), this.atts);
                } else if (n instanceof Text) {
                    builder.text(Token.token(n.getNodeValue()));
                } else if (n instanceof Comment) {
                    builder.comment(Token.token(n.getNodeValue()));
                } else if (n instanceof ProcessingInstruction) {
                    builder.pi(Token.token(String.valueOf(n.getNodeName()) + ' ' + n.getNodeValue()));
                }
                ++this.nodes;
                continue;
            }
            stack.pop();
            if (stack.empty()) break;
            builder.endElem();
        }
        builder.endDoc();
    }

    @Override
    public String det() {
        return Util.info(org.basex.core.Text.NODESPARSED, this.filename, this.nodes);
    }

    @Override
    public double prog() {
        return (double)this.nodes / 1000000.0 % 1.0;
    }

    private static final class NodeIterator {
        private final NodeList nl;
        private int i = -1;

        NodeIterator(Node n) {
            this.nl = n.getChildNodes();
        }

        boolean more() {
            return ++this.i < this.nl.getLength();
        }

        Node curr() {
            return this.nl.item(this.i);
        }
    }
}

