/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.basex.core.BaseXException;
import org.basex.core.CommandBuilder;
import org.basex.core.Commands;
import org.basex.core.Context;
import org.basex.core.MainProp;
import org.basex.core.Progress;
import org.basex.core.ProgressException;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.core.cmd.Close;
import org.basex.data.Data;
import org.basex.data.Result;
import org.basex.io.IOFile;
import org.basex.io.out.ArrayOutput;
import org.basex.io.out.NullOutput;
import org.basex.io.out.PrintOutput;
import org.basex.util.Performance;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.StringList;
import org.xml.sax.InputSource;

public abstract class Command
extends Progress {
    public static final int STANDARD = 256;
    public static final int DATAREF = 512;
    protected final TokenBuilder info = new TokenBuilder();
    protected final String[] args;
    protected Performance perf;
    protected Context context;
    protected PrintOutput out;
    protected InputSource in;
    protected Prop prop;
    protected MainProp mprop;
    private final int flags;

    public Command(int flag, String ... arg) {
        this.flags = flag;
        this.args = arg;
    }

    public final void execute(Context ctx, OutputStream os) throws BaseXException {
        if (!this.exec(ctx, os)) {
            throw new BaseXException(this.info(), new Object[0]);
        }
    }

    public final String execute(Context ctx) throws BaseXException {
        ArrayOutput ao = new ArrayOutput();
        this.execute(ctx, ao);
        return ao.toString();
    }

    public void setInput(InputStream is) {
        this.setInput(new InputSource(is));
    }

    public void setInput(InputSource is) {
        this.in = is;
    }

    public final boolean run(Context ctx) {
        return this.run(ctx, new NullOutput());
    }

    public final String info() {
        return this.info.toString();
    }

    public Result result() {
        return null;
    }

    public boolean updating(Context ctx) {
        return (this.flags & 6) != 0;
    }

    public boolean newData(Context ctx) {
        return false;
    }

    public boolean supportsProg() {
        return false;
    }

    public boolean stoppable() {
        return false;
    }

    public void build(CommandBuilder cb) {
        cb.init().args();
    }

    public final String toString() {
        CommandBuilder cb = new CommandBuilder(this);
        this.build(cb);
        return cb.toString();
    }

    protected abstract boolean run() throws IOException;

    protected final boolean error(String msg, Object ... ext) {
        this.info.reset();
        this.info.addExt(msg == null ? "" : msg, ext);
        return false;
    }

    protected final boolean info(String str, Object ... ext) {
        this.info.addExt(str, ext).add(Text.NL);
        return true;
    }

    protected final String[] databases(String name) {
        String pat = name.matches(".*[*?,].*") ? IOFile.regex(name) : name;
        StringList sl = new StringList();
        IOFile[] iOFileArray = this.mprop.dbpath().children(pat);
        int n = iOFileArray.length;
        int n2 = 0;
        while (n2 < n) {
            IOFile f = iOFileArray[n2];
            String n3 = f.name();
            if (!n3.contains(".")) {
                sl.add(n3);
            }
            ++n2;
        }
        return sl.toArray();
    }

    protected final <E extends Enum<E>> E getOption(Class<E> typ) {
        E e = Command.getOption(this.args[0], typ);
        if (e == null) {
            this.error(Text.CMDWHICH, this.args[0]);
        }
        return e;
    }

    protected static final <E extends Enum<E>> E getOption(String s, Class<E> typ) {
        try {
            return Enum.valueOf(typ, s.toUpperCase());
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected static final boolean close(Context ctx, String db) {
        boolean close;
        boolean bl = close = ctx.data() != null && db.equals(ctx.data().meta.name) && ctx.datas.pins(db) == 1;
        return close && new Close().run(ctx);
    }

    private boolean exec(Context ctx, OutputStream os) {
        Data data = ctx.data();
        if (data == null && (this.flags & 0x200) != 0) {
            return this.error(Text.PROCNODB, new Object[0]);
        }
        if (!ctx.perm(this.flags & 0xFF, data != null ? data.meta : null)) {
            Commands.CmdPerm[] perms = Commands.CmdPerm.values();
            int i = perms.length;
            int f = this.flags & 0xFF;
            while (--i >= 0 && (1 << i & f) == 0) {
            }
            return this.error(Text.PERMNO, new Object[]{perms[i + 1]});
        }
        boolean ok = false;
        boolean writing = this.updating(ctx);
        ctx.register(writing);
        ok = this.run(ctx, os);
        ctx.unregister(writing);
        return ok;
    }

    private boolean run(Context ctx, OutputStream os) {
        this.perf = new Performance();
        this.context = ctx;
        this.prop = ctx.prop;
        this.mprop = ctx.mprop;
        this.out = PrintOutput.get(os);
        try {
            boolean bl = this.run();
            return bl;
        }
        catch (ProgressException ex) {
            this.abort();
            boolean bl = this.error("Interrupted.", new Object[0]);
            return bl;
        }
        catch (Throwable ex) {
            block21: {
                Performance.gc(2);
                this.abort();
                if (!(ex instanceof OutOfMemoryError)) break block21;
                Util.debug(ex);
                boolean bl = this.error(String.valueOf(Text.PROCMEM) + ((this.flags & 6) != 0 ? Text.PROCMEMCREATE : ""), new Object[0]);
                try {
                    if (this.out != null) {
                        this.out.flush();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return bl;
            }
            boolean bl = this.error(Util.bug(ex), new Object[0]);
            try {
                if (this.out != null) {
                    this.out.flush();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return bl;
        }
        finally {
            try {
                if (this.out != null) {
                    this.out.flush();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

