/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core;

import org.basex.core.Datas;
import org.basex.core.Events;
import org.basex.core.Lock;
import org.basex.core.MainProp;
import org.basex.core.Prop;
import org.basex.core.User;
import org.basex.core.Users;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.data.Nodes;
import org.basex.query.util.pkg.Repo;
import org.basex.server.ClientListener;
import org.basex.server.Sessions;

public final class Context {
    public final ClientListener listener;
    public final Prop prop = new Prop();
    public final MainProp mprop;
    public final Sessions sessions;
    public final Events events;
    public final Datas datas;
    public final Users users;
    public final Repo repo;
    public User user;
    public Nodes marked;
    public Nodes copied;
    public int focused = -1;
    private String path;
    private Nodes current;
    private final Lock lock;
    private Data data;

    public Context() {
        this.listener = null;
        this.mprop = new MainProp();
        this.datas = new Datas();
        this.events = new Events();
        this.sessions = new Sessions();
        this.lock = new Lock(this);
        this.users = new Users(true);
        this.repo = new Repo(this);
        this.user = this.users.get("admin");
    }

    public Context(Context ctx, ClientListener cl) {
        this.listener = cl;
        this.mprop = ctx.mprop;
        this.datas = ctx.datas;
        this.events = ctx.events;
        this.sessions = ctx.sessions;
        this.lock = ctx.lock;
        this.users = ctx.users;
        this.repo = ctx.repo;
    }

    public synchronized void close() {
        while (this.sessions.size() > 0) {
            ((ClientListener)this.sessions.get(0)).exit();
        }
        this.datas.close();
    }

    public boolean client() {
        return this.listener != null;
    }

    public boolean root() {
        return this.current != null && this.current.root;
    }

    public Data data() {
        return this.data;
    }

    public Nodes current() {
        if (this.current == null && this.data != null) {
            this.current = new Nodes((this.path == null ? this.data.docs() : this.data.docs(this.path)).toArray(), this.data);
            this.current.root = this.path == null;
        }
        return this.current;
    }

    public void current(Nodes curr) {
        this.current = curr;
    }

    public void openDB(Data d) {
        this.openDB(d, null);
    }

    public void openDB(Data d, String p) {
        this.data = d;
        this.path = p;
        this.copied = null;
        this.set(null, new Nodes(d));
    }

    public void closeDB() {
        this.data = null;
        this.copied = null;
        this.set(null, null);
    }

    public void set(Nodes curr, Nodes mark) {
        this.current = curr;
        this.marked = mark;
        this.focused = -1;
    }

    public void update() {
        this.current = null;
    }

    public void pin(Data d) {
        this.datas.add(d);
    }

    public Data pin(String name) {
        return this.datas.pin(name);
    }

    public boolean unpin(Data d) {
        return this.datas.unpin(d);
    }

    public boolean pinned(String db) {
        return this.datas.pinned(db);
    }

    public void register(boolean w) {
        this.lock.lock(w);
    }

    public void unregister(boolean w) {
        this.lock.unlock(w);
    }

    public void add(ClientListener s) {
        this.sessions.add(s);
    }

    public void delete(ClientListener s) {
        this.sessions.remove(s);
    }

    public boolean perm(int p, MetaData md) {
        User us = md == null || p == 4 || p == 8 ? null : md.users.get(this.user.name);
        return (us == null ? this.user : us).perm(p);
    }
}

