/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.basex.core.Command;
import org.basex.core.CommandBuilder;
import org.basex.core.Commands;
import org.basex.core.Text;
import org.basex.data.MetaData;
import org.basex.io.IOFile;
import org.basex.io.Zip;
import org.basex.util.Util;

public final class CreateBackup
extends Command {
    private static final SimpleDateFormat DATE = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");

    public CreateBackup(String arg) {
        super(4, arg);
    }

    @Override
    protected boolean run() {
        if (!MetaData.validName(this.args[0], true)) {
            return this.error(Text.NAMEINVALID, this.args[0]);
        }
        String[] dbs = this.databases(this.args[0]);
        if (dbs.length == 0) {
            return this.error(Text.DBNOTFOUND, this.args[0]);
        }
        boolean ok = true;
        String[] stringArray = dbs;
        int n = dbs.length;
        int n2 = 0;
        while (n2 < n) {
            String db = stringArray[n2];
            if (this.mprop.dbpath(db).isDirectory()) {
                if (this.backup(db)) {
                    this.info(Text.DBBACKUP, db, this.perf);
                } else {
                    this.info(Text.DBNOBACKUP, db);
                    ok = false;
                }
            }
            ++n2;
        }
        return ok;
    }

    private boolean backup(String db) {
        try {
            File path = this.mprop.dbpath(db);
            IOFile file = new IOFile(this.mprop.dbpath(String.valueOf(db) + "-" + DATE.format(new Date()) + ".zip"));
            Zip zip = this.progress(new Zip(file));
            zip.zip(path);
            return true;
        }
        catch (IOException ex) {
            Util.debug(ex);
            return false;
        }
    }

    @Override
    protected String tit() {
        return Text.BUTTONBACKUP;
    }

    @Override
    public boolean supportsProg() {
        return true;
    }

    @Override
    public void build(CommandBuilder cb) {
        cb.init((Object)((Object)Commands.Cmd.CREATE) + " " + (Object)((Object)Commands.CmdCreate.BACKUP)).args();
    }
}

