/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.core.CommandBuilder;
import org.basex.core.Commands;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.core.cmd.ACreate;
import org.basex.data.Data;
import org.basex.data.MemData;
import org.basex.index.IndexToken;
import org.basex.util.Util;
import org.basex.util.ft.Language;

public final class CreateIndex
extends ACreate {
    public CreateIndex(Object type) {
        super(514, type != null ? type.toString() : null);
    }

    @Override
    protected boolean run() {
        Data data = this.context.data();
        if (data instanceof MemData) {
            return this.error(Text.PROCMM, new Object[0]);
        }
        try {
            IndexToken.IndexType index = null;
            Commands.CmdIndex ci = this.getOption(Commands.CmdIndex.class);
            if (ci == null) {
                return this.error(Text.CMDUNKNOWN, this);
            }
            switch (ci) {
                case TEXT: {
                    index = IndexToken.IndexType.TEXT;
                    break;
                }
                case ATTRIBUTE: {
                    index = IndexToken.IndexType.ATTRIBUTE;
                    break;
                }
                case FULLTEXT: {
                    data.meta.wildcards = this.prop.is(Prop.WILDCARDS);
                    data.meta.stemming = this.prop.is(Prop.STEMMING);
                    data.meta.casesens = this.prop.is(Prop.CASESENS);
                    data.meta.diacritics = this.prop.is(Prop.DIACRITICS);
                    data.meta.scoring = this.prop.num(Prop.SCORING);
                    data.meta.language = Language.get(this.prop);
                    index = IndexToken.IndexType.FULLTEXT;
                    break;
                }
                case PATH: {
                    index = IndexToken.IndexType.PATH;
                    break;
                }
                default: {
                    throw Util.notexpected(new Object[0]);
                }
            }
            this.index(index, data);
            data.flush();
            return this.info(Text.INDCREATED, new Object[]{index, this.perf});
        }
        catch (IOException ex) {
            Util.debug(ex);
            return this.error(ex.getMessage(), new Object[0]);
        }
    }

    @Override
    public void build(CommandBuilder cb) {
        cb.init((Object)((Object)Commands.Cmd.CREATE) + " " + (Object)((Object)Commands.CmdCreate.INDEX)).args();
    }
}

